/*
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;

import static org.junit.Assert.assertNotNull;

/**
 * Created by andrzej on 23.09.2016.
 */
//@Ignore
public class LicenceLoaderTest {

	private static final char[] DIGITS = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };;

	public static final String licenceText = "comment=Licence for non registered users\n" +
			"for-component=acs\n" +
			"licence-nr=16\n" +
			"licence-id=45141fa6-eeb1-306e-9479-c12cbbbcbc6a\n" +
			"customer-name=etd\n" +
			"customer-email=etd@tigase.org\n" +
			"template-id=45458c69e9f02ccaa6c378fe3c2b684ea7d30beb\n" +
			"vhosts=cluster-c.xmpp-test.net\n" +
			"valid-since=2016-09-23\n" +
			"valid-until=2016-09-30\n" +
			"signature=76c174b26405915be2948ee17f9878a09c4c77da1678bfc1951c58cc812624af00d86bba82da9307abf346b02171e291e7f32280262bb9c926b81b4cec384e626a77de11aac93ff6ef37c7b409f4d908b935d863b37cc9b9c3c8391f8e5846903456cb81d1c778e40f5d06ba92df48470bc41dddbe5c6fa747e981e57b26466a\n";

	@Test
	public void testLicenceLoader() throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, ParseException, InvalidKeyException, SignatureException {
		LicenceLoader loader = new LicenceLoaderImpl();
		ByteArrayInputStream in = new ByteArrayInputStream(licenceText.getBytes());
		Licence licence = loader.loadLicence(in);
		in.close();

		assertNotNull(licence);
		assertNotNull(licence.getPropertyAsString("signature"));

		Assert.assertEquals("Digest is different",
							"a5c474863f2e5b9306da021ce235d2c7fb10e63a41c53044d9dbbda460dab4b5",
							licence.getLicenceDigest());

	}

}
