/*
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import org.junit.*;
import tigase.server.XMPPServer;
import tigase.vhosts.VHostItemImpl;
import tigase.vhosts.VHostManager;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

import static org.junit.Assert.*;
import static tigase.conf.ConfigHolder.TDSL_CONFIG_FILE_KEY;
import static tigase.licence.LicenceChecker.INSTALLATION_ID_KEY;

/**
 * @author Wojtek
 */
@Ignore
public class LicenceCheckerTest {

	private final String INSTALLATION_ID = "1Q2GR2N7MBKNSALRA80KT5Q3JHR7ABM3Q";
	private final Set<String> DEFAULT_VHOST_LIST = Set.of("vhost1", "vhost2", "vhost3");

	private SimpleParser parser = SingletonFactory.getParserInstance();

	public LicenceCheckerTest() {
	}

	@Before
	public void setUp() {
		System.setProperty(INSTALLATION_ID_KEY, INSTALLATION_ID);

		String[] args = new String[] {TDSL_CONFIG_FILE_KEY, "src/test/resources/config.tdsl"};
		XMPPServer.start(args);
	}

	@Test
	public void testGetLicenceChecker() throws Exception {

		final VHostManager vHostManager = XMPPServer.getComponent(VHostManager.class);
		for (String vh : DEFAULT_VHOST_LIST) {
			vHostManager.getComponentRepository().addItem(new VHostItemImpl(vh));
		}

		List<String> cmpNames = new CopyOnWriteArrayList<>();
		cmpNames.add("monitor");
		cmpNames.add("ua");
		cmpNames.forEach(LicenceChecker::getLicenceChecker);

		final String module = "acs";
		cmpNames.add(module);

		final LicenceCheckerUpdateCallbackImpl testCallback = new TestUpdateCallback(module);

		final LicenceChecker licenceChecker = LicenceChecker.getLicenceChecker(module, testCallback);

		LicenceChecker.getInstallationId(true);

		Set<String> licencedComponents = LicenceChecker.getLicencedComponents();
		assertTrue("Collections are different", licencedComponents.containsAll(cmpNames));

		Element licencingDetails = LicenceChecker.getLicencingDetails(cmpNames.get(0));
		String installationId = licencingDetails.getCDataStaticStr(
				new String[]{"licence-details", INSTALLATION_ID_KEY});
		String vHosts = licencingDetails.getCDataStaticStr(new String[]{"licence-details", "vhosts"});

		assertNotNull("Installation-id was not received", installationId);

		Set<String> hostsFromDetails = new HashSet<>(Arrays.asList(vHosts.split(",")));
		assertEquals("VHosts list differ", hostsFromDetails, DEFAULT_VHOST_LIST);

		String acs = LicenceChecker.getCodeForLicenceRetrieval(module);
		acs = new String(tigase.util.Base64.decode(acs));

		DomBuilderHandler handler = new DomBuilderHandler();
		parser.parse(handler, acs.toCharArray(), 0, acs.length());

		final Element element = handler.getParsedElements().poll();

		Set<String> requiredElements = new HashSet<>(
				Arrays.asList("installation-id", "vhosts", "module", "cluster-nodes-count", "online-users-count"));
		final List<Element> items = element.getChildren(new String[]{"data", "fields"});
		for (Element el : items) {
			final String var = el.getCDataStaticStr(new String[]{"item", "var"});
			requiredElements.remove(var);
			if (var.equals("installation-id")) {
				String val = el.getCDataStaticStr(new String[]{"item", "value"});
				assertEquals("Installation-id is different", installationId, val);
			}
			if (var.equals("vhosts")) {
				List<Element> subItems = el.getChildrenStaticStr(new String[]{"item", "value"});
				if (subItems != null) {
					Set<String> vhosts = subItems.stream().map(Element::getCData).collect(Collectors.toSet());
					assertEquals("Installation-id is different", DEFAULT_VHOST_LIST, vhosts);
				} else {
					Assert.fail("VHosts are missing");
				}
			}
			if (var.equals("module")) {
				String val = el.getCDataStaticStr(new String[]{"item", "value"});
				assertEquals("Module is different", module, val);
			}

			if (var.equals("cluster-nodes-count")) {
				String val = el.getCDataStaticStr(new String[]{"item", "value"});
				assertEquals("Cluster nodes count is different", "1", val);
			}
			if (var.equals("online-users-count")) {
				String val = el.getCDataStaticStr(new String[]{"item", "value"});
				assertEquals("Online users count is different", "10", val);
			}
		}
		assertEquals("Not all elements found", Collections.emptySet(), requiredElements);
	}

	static class TestUpdateCallback
			extends LicenceCheckerUpdateCallbackImpl {

		public TestUpdateCallback(String cmpName) {
			super(cmpName);
		}

		@Override
		public Optional<Map<String, String>> getServerVerifiableMetrics() {
			Map<String, String> metrics = new ConcurrentHashMap<>(2);
			metrics.put("cluster-nodes-count", "1");
			metrics.put("online-users-count", "10");

			return Optional.of(metrics);
		}

		@Override
		public boolean additionalValidation(Licence lic) {
			return true;
		}
	}
}