/*
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import tigase.server.XMPPServer;
import tigase.vhosts.VHostItemImpl;
import tigase.vhosts.VHostManager;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

import static tigase.conf.ConfigHolder.TDSL_CONFIG_FILE_KEY;
import static tigase.licence.LicenceChecker.INSTALLATION_ID_KEY;

/**
 * It's recommendable to run the test with `-Dstatistics-log-level=ALL -Dlicence-library-test-mode=true` parameters
 */
@Ignore
public class LicenceCheckDailyTaskTest {

//	final String INSTALLATION_ID = "1Q2GR2N7MBKNSALRA80KT5Q3JHR7ABM3Q";
	final String INSTALLATION_ID = "1CNP4NL6H8NCAIHHUTGCKA4PNJV37AK4T";
	private final String[] VHOSTS_DEF = {"vhost1", "vhost2", "vhost3"};

	@Before
	public void setUp() {
		System.setProperty(INSTALLATION_ID_KEY, INSTALLATION_ID);

		String[] args = new String[] {TDSL_CONFIG_FILE_KEY, "src/test/resources/config.tdsl"};
		XMPPServer.start(args);
	}

	@Test
	public void testGetLicenceCheckerDailyTaskDefaultScheduleAcsOnly() throws Exception {

		final VHostManager vHostManager = XMPPServer.getComponent(VHostManager.class);
		for (String vh : VHOSTS_DEF) {
			vHostManager.getComponentRepository().addItem(new VHostItemImpl(vh));
		}

//		LicenceChecker.initialCheckDelay = 5;
//		LicenceChecker.dailyCheckDelay = TimeUnit.MINUTES.toSeconds(5);

		List<String> cmpNames = new CopyOnWriteArrayList<>();
//		cmpNames.add("meet");
		cmpNames.add("tigase-monitor");
		cmpNames.add("unified-archive");
//		cmpNames.add("muc"); //to test errors

		cmpNames.add("acs");
		cmpNames.forEach(cmpName -> {
			LicenceChecker.getLicenceChecker(cmpName, new LicenceCheckerTest.TestUpdateCallback(cmpName));
		});

		TimeUnit.MINUTES.sleep(210);
	}



	@Test
	public void testGetLicenceCheckerDailyTaskSingleRun() throws Exception {

		final VHostManager vHostManager = XMPPServer.getComponent(VHostManager.class);
		for (String vh : VHOSTS_DEF) {
			vHostManager.getComponentRepository().addItem(new VHostItemImpl(vh));
		}

		LicenceChecker.isCheckTaskScheduled = true;

		final String module = "acs";
		final LicenceCheckerUpdateCallbackImpl testCallback = new LicenceCheckerTest.TestUpdateCallback(module);
		final LicenceChecker licenceChecker = LicenceChecker.getLicenceChecker(module, testCallback);
		final LicenceCheckDailyTask licenceCheckDailyTask = new LicenceCheckDailyTask(Map.of(module, licenceChecker));
		licenceCheckDailyTask.runLicenceCheck();

		TimeUnit.MINUTES.sleep(210);
	}

	@Test
	public void testGetLicenceCheckerDailyTaskInvalidUpdateCallback() throws Exception {

		final VHostManager vHostManager = XMPPServer.getComponent(VHostManager.class);
		for (String vh : VHOSTS_DEF) {
			vHostManager.getComponentRepository().addItem(new VHostItemImpl(vh));
		}

		LicenceChecker.isCheckTaskScheduled = true;

		final String module = "acs";
		final LicenceCheckerUpdateCallbackImpl testCallback = new LicenceCheckerUpdateCallbackImpl(module) {
			@Override
			public boolean additionalValidation(Licence lic) {
				return 1 > lic.getPropertyAsInteger("meets-limit");
			}
		};

		final LicenceChecker licenceChecker = LicenceChecker.getLicenceChecker(module, testCallback);
		final LicenceCheckDailyTask licenceCheckDailyTask = new LicenceCheckDailyTask(Map.of(module, licenceChecker));
		licenceCheckDailyTask.runLicenceCheck();

		TimeUnit.MINUTES.sleep(210);
	}
}