/*
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.licence.utils.TooManyRequestsHTTPException;
import tigase.licence.utils.VHostsRetriever;
import tigase.server.XMPPServer;
import tigase.stats.collector.provider.HTTPException;
import tigase.vhosts.VHostItemImpl;
import tigase.vhosts.VHostManager;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static tigase.licence.InstallationIdRetriever.parseInstIdResponse;
import static tigase.licence.LicenceChecker.INSTALLATION_ID_KEY;

@Ignore
public class InstallationIdRetrieverTest {

	private static final String repoClass = "tigase.db.xml.XMLRepository";
//	private static final String repoUri = "memory://xmlRepo?autoCreateUser=true";
	private static final String repoUri = "memory://xmlRepo";
	private static final String INSTALLATION_ID = "1Q2GR2N7MBKNSALRA80KT5Q3JHR7ABM3Q";
	private static final String[] VHOSTS_DEF = {"vhost1","vhost2","vhost3"};

	static Logger log = Logger.getLogger(InstallationIdRetriever.class.getName());

	@BeforeClass
	public static void setUp() {
		System.setProperty(RepositoryFactory.USER_REPO_CLASS_PROP_KEY, repoClass);
		System.setProperty(RepositoryFactory.GEN_USER_DB_URI_PROP_KEY, repoUri);
		System.setProperty(RepositoryFactory.USER_REPO_POOL_SIZE_PROP_KEY, "1");

		log = Logger.getLogger("tigase.licence");
		TestLogger.configureLogger(log, Level.ALL);
	}

	@Test
	@Ignore
	public void getInstallationIdFromServer2() {

		List<JID> j = List.of("vhost1", "vhost2", "vhost3")
				.stream()
				.map(JID::jidInstanceNS)
				.collect(Collectors.toList());
		List<String> h = List.of("hash1", "hash2", "hash3");
		final InstallationIdRetriever installationIdRetriever = InstallationIdRetriever.getInstallationIdRetriever();

		try {
			Element element = null;

			try {
				element = installationIdRetriever.loadData(null, j, h);
			} catch (TooManyRequestsHTTPException e) {
				log.log(Level.WARNING, "Server returned error {0}: {1}; next retry in {2}s)",
						new Object[]{e.getStatusCode(), e.getMessage(), e.getRetryAfter()});
			} catch (HTTPException e) {
				log.log(Level.WARNING, "Server returned error: {0}, code: {1}",
						new Object[]{e.getMessage(), e.getStatusCode()});
			} catch (Exception e) {
				log.log(Level.WARNING, "Other error", e);
			}

			System.out.println("element: " + element);
			if (element != null) {
				final String InstallationID = parseInstIdResponse(element);
				log.log(Level.INFO, "InstallationID: " + InstallationID);
				assertNotNull(InstallationID);
			}

		} catch (Exception e) {
			log.log(Level.WARNING, "Other error", e);
		}
	}

	@Test
	@Ignore
	public void getInstallationIdFromServer() throws Exception {

		final VHostManager vHostManager = XMPPServer.getComponent(VHostManager.class);
		for (String vh : VHOSTS_DEF) {
			vHostManager.getComponentRepository().addItem(new VHostItemImpl(vh));
		}

		final InstallationIdRetriever installationIdRetriever = InstallationIdRetriever.getInstallationIdRetriever();
		final String installationId = installationIdRetriever.getInstallationId();

		System.out.println(installationId);

		// check if it's in repository
		final UserRepository userRepository = RepositoryFactory.getUserRepository(null, null, null);
		final String data = userRepository.getData(BareJID.bareJIDInstance("licence-library"), INSTALLATION_ID_KEY);
		assertEquals("Received installation-id and stored in database are different!",installationId,data);
	}

	@Test
	@Ignore
	public void getInstallationIdFromFile() throws Exception {
		System.setProperty(INSTALLATION_ID_KEY, INSTALLATION_ID);

		final InstallationIdRetriever installationIdRetriever = InstallationIdRetriever.getInstallationIdRetriever();
		final String installationId = installationIdRetriever.getInstallationId();

		System.out.println(installationId);

		assertEquals("Received installation-id and the one in file are different!",installationId,INSTALLATION_ID);


	}

	@Test
	public void testParseInstIdResponse() {
		String response = "<command>  <fields>    <item>      <var>installation-id</var>      <label>Installation-ID</label>      <type>text-single</type>      <value>1HGK15testtesttestV3K</value>    </item>  </fields>  <instructions>Following Installation-ID should be added to etc/init.properties configuration file in line --installation-id=1HGK15RG36M6D7AL3LC9R20A7P4T94V3K</instructions>  <captcha/>  <status>completed</status></command>";

		SimpleParser parser = new SimpleParser();
		DomBuilderHandler handler = new DomBuilderHandler();
		parser.parse(handler, response.toCharArray(), 0, response.length());
		final Element responseElement = handler.getParsedElements().poll();
		final String installationId = parseInstIdResponse(responseElement);
		assertEquals("1HGK15testtesttestV3K", installationId);
	}
}