/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import org.junit.Assert;
import org.junit.Test;
import tigase.licence.TOTP;

public class TOTPTest {
    @Test
    public void testGenerate() throws Exception {
        TOTP totp = new TOTP();
        totp.setSecret("123456");
        Assert.assertEquals((Object)"VUJPEPFFHBU9911P882IGV7FDFFAUI0E", (Object)totp.generateTOTP(1L));
        Assert.assertEquals((Object)"CK6MJE7MNGOE23UG4UUUGVR3VNJ90CD9", (Object)totp.generateTOTP(2L));
        Assert.assertEquals((Object)"L2IRL3DUOM7K5AQRHQCG23OIM1K9IE9T", (Object)totp.generateTOTP(3L));
        Assert.assertEquals((Object)"4C70HD9F4JOM0UBB03OBR399B6PF6OSB", (Object)totp.generateTOTP(10L));
        Assert.assertEquals((Object)"E19TGORHA4VKS5KQD3FS6BJP0HDC61MT", (Object)totp.generateTOTP(100L));
        Assert.assertEquals((Object)"K1HBCQOC1KTT9VEVN8RHQP2BETH4I7GP", (Object)totp.generateTOTP(1000L));
        Assert.assertEquals((Object)"T842VH8KJEON5SVG2RSBU88VLGV6RCTB", (Object)totp.generateTOTP(10000L));
        Assert.assertEquals((Object)"J4O2KR3EVVRML7U9JTI7S3NE2SQNH24F", (Object)totp.generateTOTP(10001L));
    }

    @Test
    public void testGenerateVerify() throws Exception {
        TOTP totp = new TOTP();
        totp.setSecret("123456");
        Assert.assertTrue((boolean)totp.verify(totp.generateTOTP()));
        String x = totp.generateTOTP();
        totp.setSecret("123465");
        Assert.assertFalse((boolean)totp.verify(x));
    }

    @Test
    public void testVerify() throws Exception {
        TOTP totp = new TOTP();
        totp.setSecret("123456");
        Assert.assertFalse((boolean)totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 8L));
        Assert.assertTrue((boolean)totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 9L));
        Assert.assertTrue((boolean)totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 10L));
        Assert.assertTrue((boolean)totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 11L));
        Assert.assertFalse((boolean)totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 12L));
    }
}

