/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import tigase.licence.Licence;
import tigase.licence.LicenceLoader;
import tigase.licence.LicenceLoaderFactory;
import tigase.licence.LicenceRetriever;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class LicenceRetrieverTest {
    private static final String repoClass = "tigase.db.xml.XMLRepository";
    private static final String repoUri = "memory://xmlRepo?autoCreateUser=true";
    private String URL = null;
    private Map<String, String> additionalParameters;
    private String component = "acs";
    private String installationId = "1A3LGLD4S0P526M1Q05CIIFMJG3TEN5RE";
    private LicenceRetriever retriever;
    private List<JID> vhosts;

    @BeforeClass
    public static void setUpLogger() {
        Logger logger = Logger.getLogger("tigase.licence");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        Level LEVEL = Level.WARNING;
        consoleHandler.setLevel(LEVEL);
        logger.addHandler(consoleHandler);
        logger.setLevel(LEVEL);
        logger.setUseParentHandlers(false);
    }

    @Before
    public void setUp() {
        this.retriever = new LicenceRetriever();
        this.vhosts = new ArrayList<JID>();
        this.vhosts.add(JID.jidInstanceNS((String)"vhost2"));
        this.vhosts.add(JID.jidInstanceNS((String)"vhost3"));
        this.vhosts.add(JID.jidInstanceNS((String)"vhost1"));
        this.additionalParameters = new ConcurrentHashMap<String, String>();
    }

    @Test
    public void testLicenceRetrievalWithinLimits() throws Exception {
        this.additionalParameters.put("cluster-nodes-count", "1");
        this.additionalParameters.put("online-users-count", "1");
        Element result = this.retriever.loadData(this.URL, this.installationId, this.component, this.vhosts, this.additionalParameters);
        Assert.assertNotNull((Object)result);
        String licenceString = this.retriever.extractLicenceText(result);
        Assert.assertNotNull((Object)licenceString);
        LicenceLoader licenceLoader = LicenceLoaderFactory.create();
        Licence licence = licenceLoader.loadLicence((InputStream)new ByteArrayInputStream(licenceString.getBytes()));
        Date since = licence.getPropertyAsDate("valid-since");
        LocalDate sinceLD = LocalDateTime.ofInstant(since.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Date until = licence.getPropertyAsDate("valid-until");
        LocalDate untilLD = LocalDateTime.ofInstant(until.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Assert.assertEquals((String)"Licence is not valid for 30 days!", (Object)sinceLD.plusDays(30L), (Object)untilLD);
        Boolean sendingStatistics = licence.getPropertyAsBoolean("sendingStatistics");
        Assert.assertFalse((String)"Sending statistics is forced", (boolean)sendingStatistics);
    }

    @Test
    public void testLicenceRetrievalUserExceeded() throws Exception {
        this.additionalParameters.put("cluster-nodes-count", "1");
        this.additionalParameters.put("online-users-count", "2");
        Element result = this.retriever.loadData(this.URL, this.installationId, this.component, this.vhosts, this.additionalParameters);
        Assert.assertNotNull((Object)result);
        String licenceString = this.retriever.extractLicenceText(result);
        Assert.assertNotNull((Object)licenceString);
        LicenceLoader licenceLoader = LicenceLoaderFactory.create();
        Licence licence = licenceLoader.loadLicence((InputStream)new ByteArrayInputStream(licenceString.getBytes()));
        Date since = licence.getPropertyAsDate("valid-since");
        LocalDate sinceLD = LocalDateTime.ofInstant(since.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Date until = licence.getPropertyAsDate("valid-until");
        LocalDate untilLD = LocalDateTime.ofInstant(until.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Assert.assertEquals((String)"Licence is not valid for 7 days!", (Object)sinceLD.plusDays(7L), (Object)untilLD);
        Boolean sendingStatistics = licence.getPropertyAsBoolean("sendingStatistics");
        Assert.assertTrue((String)"Sending statistics is NOT forced", (boolean)sendingStatistics);
    }

    @Test
    public void testLicenceRetrievalNodesExceeded() throws Exception {
        this.additionalParameters.put("cluster-nodes-count", "2");
        this.additionalParameters.put("online-users-count", "1");
        Element result = this.retriever.loadData(this.URL, this.installationId, this.component, this.vhosts, this.additionalParameters);
        Assert.assertNotNull((Object)result);
        String licenceString = this.retriever.extractLicenceText(result);
        Assert.assertNotNull((Object)licenceString);
        LicenceLoader licenceLoader = LicenceLoaderFactory.create();
        Licence licence = licenceLoader.loadLicence((InputStream)new ByteArrayInputStream(licenceString.getBytes()));
        Date since = licence.getPropertyAsDate("valid-since");
        LocalDate sinceLD = LocalDateTime.ofInstant(since.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Date until = licence.getPropertyAsDate("valid-until");
        LocalDate untilLD = LocalDateTime.ofInstant(until.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Assert.assertEquals((String)"Licence is not valid for 7 days!", (Object)sinceLD.plusDays(7L), (Object)untilLD);
        Boolean sendingStatistics = licence.getPropertyAsBoolean("sendingStatistics");
        Assert.assertTrue((String)"Sending statistics is NOT forced", (boolean)sendingStatistics);
    }
}

