/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import org.junit.Assert;
import org.junit.Test;
import tigase.licence.Licence;
import tigase.licence.LicenceLoaderImpl;

public class LicenceLoaderTest {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String licenceText = "comment=Licence for non registered users\nfor-component=acs\nlicence-nr=16\nlicence-id=45141fa6-eeb1-306e-9479-c12cbbbcbc6a\ncustomer-name=etd\ncustomer-email=etd@tigase.org\ntemplate-id=45458c69e9f02ccaa6c378fe3c2b684ea7d30beb\nvhosts=cluster-c.xmpp-test.net\nvalid-since=2016-09-23\nvalid-until=2016-09-30\nsignature=76c174b26405915be2948ee17f9878a09c4c77da1678bfc1951c58cc812624af00d86bba82da9307abf346b02171e291e7f32280262bb9c926b81b4cec384e626a77de11aac93ff6ef37c7b409f4d908b935d863b37cc9b9c3c8391f8e5846903456cb81d1c778e40f5d06ba92df48470bc41dddbe5c6fa747e981e57b26466a\n";

    @Test
    public void testLicenceLoader() throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, ParseException, InvalidKeyException, SignatureException {
        LicenceLoaderImpl loader = new LicenceLoaderImpl();
        ByteArrayInputStream in = new ByteArrayInputStream(licenceText.getBytes());
        Licence licence = loader.loadLicence((InputStream)in);
        in.close();
        Assert.assertNotNull((Object)licence);
        Assert.assertNotNull((Object)licence.getPropertyAsString("signature"));
        Assert.assertEquals((String)"Digest is different", (Object)"a5c474863f2e5b9306da021ce235d2c7fb10e63a41c53044d9dbbda460dab4b5", (Object)licence.getLicenceDigest());
    }
}

