/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.licence.LicenceChecker;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.utils.VHostsRetriever;
import tigase.server.XMPPServer;
import tigase.util.Base64;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.JID;

public class LicenceCheckerTest {
    final String INSTALLATION_ID = "1Q2GR2N7MBKNSALRA80KT5Q3JHR7ABM3Q";
    private final String[] VHOSTS_DEF = new String[]{"vhost1", "vhost2", "vhost3"};
    private SimpleParser parser = SingletonFactory.getParserInstance();

    @Before
    public void setUp() {
        String repoClass = "tigase.db.xml.XMLRepository";
        String repoUri = "memory://xmlRepo?autoCreateUser=true";
        Logger logger = Logger.getLogger("tigase.licence");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        Level LEVEL = Level.ALL;
        consoleHandler.setLevel(LEVEL);
        logger.addHandler(consoleHandler);
        logger.setLevel(LEVEL);
        logger.setUseParentHandlers(false);
        String config_class_name = "tigase.conf.Configurator";
        System.setProperty("user-repo-class", "tigase.db.xml.XMLRepository");
        System.setProperty("user-db-uri", "memory://xmlRepo?autoCreateUser=true");
        System.setProperty("user-repo-pool-size", "1");
        System.setProperty("installation-id", "1Q2GR2N7MBKNSALRA80KT5Q3JHR7ABM3Q");
        XMPPServer.start((String[])new String[0]);
    }

    @Test
    public void testGetLicenceChecker_String() throws Exception {
        for (String vh : this.VHOSTS_DEF) {
            VHostsRetriever.addDefaultVHost((JID)JID.jidInstanceNS((String)vh));
        }
        CopyOnWriteArrayList<String> cmpNames = new CopyOnWriteArrayList<String>();
        cmpNames.add("monitor");
        cmpNames.add("ua");
        cmpNames.forEach(LicenceChecker::getLicenceChecker);
        String module = "acs";
        cmpNames.add("acs");
        LicenceChecker.getLicenceChecker((String)"acs", (LicenceCheckerUpdateCallback)new LicenceCheckerUpdateCallbackImpl("acs"){

            public Optional<Map<String, String>> getServerVerifiableMetrics() {
                ConcurrentHashMap<String, String> metrics = new ConcurrentHashMap<String, String>(2);
                metrics.put("cluster-nodes-count", "1");
                metrics.put("online-users-count", "10");
                return Optional.of(metrics);
            }
        });
        LicenceChecker.getInstallationId((boolean)true);
        Set licencedComponents = LicenceChecker.getLicencedComponents();
        Assert.assertTrue((String)"Collections are different", (boolean)licencedComponents.containsAll(cmpNames));
        Element licencingDetails = LicenceChecker.getLicencingDetails((String)((String)cmpNames.get(0)));
        String installationId = licencingDetails.getCDataStaticStr(new String[]{"licence-details", "installation-id"});
        System.out.println(licencingDetails);
        String vHosts = licencingDetails.getCDataStaticStr(new String[]{"licence-details", "vhosts"});
        Assert.assertNotNull((String)"Installation-id was not received", (Object)installationId);
        Object[] split = vHosts.split(",");
        Arrays.sort(split);
        Arrays.sort(this.VHOSTS_DEF);
        Assert.assertArrayEquals((String)"VHosts list differ", (Object[])split, (Object[])this.VHOSTS_DEF);
        String acs = LicenceChecker.getCodeForLicenceRetrieval((String)"acs");
        acs = new String(Base64.decode((String)acs));
        DomBuilderHandler handler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)handler, acs.toCharArray(), 0, acs.length());
        Element element = (Element)handler.getParsedElements().poll();
        System.out.println("decoded: " + element.toString());
        HashSet<String> requiredElements = new HashSet<String>(Arrays.asList("installation-id", "vhosts", "module", "cluster-nodes-count", "online-users-count"));
        List items = element.getChildren(new String[]{"data", "fields"});
        for (Element el : items) {
            Object val;
            String var = el.getCDataStaticStr(new String[]{"item", "var"});
            requiredElements.remove(var);
            if (var.equals("installation-id")) {
                val = el.getCDataStaticStr(new String[]{"item", "value"});
                Assert.assertEquals((String)"Installation-id is different", (Object)installationId, (Object)val);
            }
            if (var.equals("vhosts")) {
                val = new ArrayList();
                List subItems = el.getChildrenStaticStr(new String[]{"item", "value"});
                if (subItems != null && !subItems.isEmpty()) {
                    for (Element e : subItems) {
                        val.add(e.getCData());
                    }
                }
                Assert.assertEquals((String)"Installation-id is different", (Object[])this.VHOSTS_DEF, (Object[])val.toArray());
            }
            if (var.equals("module")) {
                val = el.getCDataStaticStr(new String[]{"item", "value"});
                Assert.assertEquals((String)"Module is different", (Object)"acs", (Object)val);
            }
            if (var.equals("cluster-nodes-count")) {
                val = el.getCDataStaticStr(new String[]{"item", "value"});
                Assert.assertEquals((String)"Cluster nodes count is different", (Object)"1", (Object)val);
            }
            if (!var.equals("online-users-count")) continue;
            val = el.getCDataStaticStr(new String[]{"item", "value"});
            Assert.assertEquals((String)"Online users count is different", (Object)"10", (Object)val);
        }
        Assert.assertEquals((String)"Not all elements found", Collections.emptySet(), requiredElements);
    }
}

