/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.licence.InstallationIdRetriever;
import tigase.licence.utils.VHostsRetriever;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Ignore
public class InstallationIdRetrieverTest {
    private static final String repoClass = "tigase.db.xml.XMLRepository";
    private static final String repoUri = "memory://xmlRepo";
    private static final String INSTALLATION_ID = "1Q2GR2N7MBKNSALRA80KT5Q3JHR7ABM3Q";
    private static final String[] VHOSTS_DEF = new String[]{"vhost1", "vhost2", "vhost3"};

    @BeforeClass
    public static void setUp() {
        System.setProperty("user-repo-class", repoClass);
        System.setProperty("user-db-uri", repoUri);
        System.setProperty("user-repo-pool-size", "1");
        Logger logger = Logger.getLogger("tigase.licence");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        Level LEVEL = Level.CONFIG;
        consoleHandler.setLevel(LEVEL);
        logger.addHandler(consoleHandler);
        logger.setLevel(LEVEL);
        logger.setUseParentHandlers(false);
    }

    @Test
    public void getInstallationIdFromServer() throws Exception {
        for (String vh : VHOSTS_DEF) {
            VHostsRetriever.addDefaultVHost((JID)JID.jidInstanceNS((String)vh));
        }
        InstallationIdRetriever installationIdRetriever = InstallationIdRetriever.getInstallationIdRetriever();
        String installationId = installationIdRetriever.getInstallationId();
        System.out.println(installationId);
        UserRepository userRepository = RepositoryFactory.getUserRepository(null, null, null);
        String data = userRepository.getData(BareJID.bareJIDInstance((String)"licence-library"), "installation-id");
        Assert.assertEquals((String)"Received installation-id and stored in database are different!", (Object)installationId, (Object)data);
    }

    @Test
    public void getInstallationIdFromFile() throws Exception {
        System.setProperty("installation-id", INSTALLATION_ID);
        InstallationIdRetriever installationIdRetriever = InstallationIdRetriever.getInstallationIdRetriever();
        String installationId = installationIdRetriever.getInstallationId();
        System.out.println(installationId);
        Assert.assertEquals((String)"Received installation-id and the one in file are different!", (Object)installationId, (Object)INSTALLATION_ID);
    }
}

