/**
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.licence.utils.VHostsRetriever;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

import static org.junit.Assert.*;
import static tigase.licence.LicenceChecker.INSTALLATION_ID_KEY;

@Ignore
public class InstallationIdRetrieverTest {

	private static final String repoClass = "tigase.db.xml.XMLRepository";
//	private static final String repoUri = "memory://xmlRepo?autoCreateUser=true";
	private static final String repoUri = "memory://xmlRepo";
	private static final String INSTALLATION_ID = "1Q2GR2N7MBKNSALRA80KT5Q3JHR7ABM3Q";
	private static final String[] VHOSTS_DEF = {"vhost1","vhost2","vhost3"};


	@BeforeClass
	public static void setUp() {
		System.setProperty(RepositoryFactory.USER_REPO_CLASS_PROP_KEY, repoClass);
		System.setProperty(RepositoryFactory.GEN_USER_DB_URI_PROP_KEY, repoUri);
		System.setProperty(RepositoryFactory.USER_REPO_POOL_SIZE_PROP_KEY, "1");

		Logger logger = Logger.getLogger("tigase.licence" );
		final ConsoleHandler consoleHandler = new ConsoleHandler();
		final Level LEVEL = Level.CONFIG;
		consoleHandler.setLevel( LEVEL );
		logger.addHandler( consoleHandler );
		logger.setLevel( LEVEL );
		logger.setUseParentHandlers( false );
	}

	@Test
	public void getInstallationIdFromServer() throws Exception {

		for (String vh : VHOSTS_DEF) {
			VHostsRetriever.addDefaultVHost(JID.jidInstanceNS(vh));
		}

		final InstallationIdRetriever installationIdRetriever = InstallationIdRetriever.getInstallationIdRetriever();
		final String installationId = installationIdRetriever.getInstallationId();

		System.out.println(installationId);

		// check if it's in repository
		final UserRepository userRepository = RepositoryFactory.getUserRepository(null, null, null);
		final String data = userRepository.getData(BareJID.bareJIDInstance("licence-library"), INSTALLATION_ID_KEY);
		assertEquals("Received installation-id and stored in database are different!",installationId,data);
	}

	@Test
	public void getInstallationIdFromFile() throws Exception {
		System.setProperty(INSTALLATION_ID_KEY, INSTALLATION_ID);

		final InstallationIdRetriever installationIdRetriever = InstallationIdRetriever.getInstallationIdRetriever();
		final String installationId = installationIdRetriever.getInstallationId();

		System.out.println(installationId);

		assertEquals("Received installation-id and the one in file are different!",installationId,INSTALLATION_ID);


	}

}