/**
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence.utils;

import tigase.server.XMPPServer;
import tigase.vhosts.VHostManager;
import tigase.xmpp.jid.JID;

import java.util.ArrayList;
import java.util.List;

public class VHostsRetriever {

	private static List<JID> temps = new ArrayList<>();

	public static boolean addDefaultVHost(JID vhost) {
		return temps.add(vhost);
	}

	public static List<JID> getManagedVHosts() {
		List<JID> result = new ArrayList<>();
		VHostManager vhostman = XMPPServer.getComponent(VHostManager.class);
		if (vhostman != null) {
			result = vhostman.getAllVHosts();
		} else {
			// quite possibly we are simply running test
			if (!temps.isEmpty()) {
				result.addAll(temps);
			}
		}
		return result;
	}
}
