/**
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence.utils;

import tigase.stats.collector.provider.HTTPException;

public class TooManyRequestsHTTPException
		extends HTTPException {

	private int retryAfter;

	/**
	 * Constructor for the TooManyRequestsHTTPException
	 *
	 * @param statusCode <code>int</code> for the HTTP status code
	 **/
	public TooManyRequestsHTTPException(int statusCode) {
		super(statusCode);
		this.retryAfter = 60;
	}

	/**
	 * Constructor for the TooManyRequestsHTTPException
	 *
	 * @param statusCode <code>int</code> for the HTTP status code
	 * @param retryAfter <code>int</code> for the delay time after which
	 * subsequent request should be made
	 **/
	public TooManyRequestsHTTPException(int statusCode, int retryAfter) {
		super(statusCode);
		this.retryAfter = retryAfter;
	}

	public int getRetryAfter() {
		return this.retryAfter;
	}

	@Override
	public String getMessage() {
		return "Too Many Requests";
	}
}
