/**
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import tigase.kernel.beans.config.ConfigField;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;

/**
 * Created by bmalkow on 13.12.2016.
 */
public class TOTP {

	private final static String ALGORITHM = "HmacSHA1";
	private final static int TIME_STEP = 10;
	@ConfigField(desc = "TOTP secret")
	private String secret = "Ia10W2CdaTY6F8unCSg08/cN8oAdThwFhWwg9OoRGJjb";

	private static String encodeString32(byte[] buff) {
		byte[] r = new byte[buff.length + 1];
		r[0] = 0;
		System.arraycopy(buff, 0, r, 1, buff.length);
		BigInteger bi = new BigInteger(r);
		return bi.toString(32).toUpperCase();
	}

	static String generateTOTP(byte[] k, String time) {
		while (time.length() < 16) {
			time = "0" + time;
		}
		// Get the HEX in a Byte[]
		byte[] msg = hexStr2Bytes(time);
		byte[] hash = hmac_sha(ALGORITHM, k, msg);
		return encodeString32(hash);
	}

	/**
	 * This method converts a HEX string to Byte[]
	 *
	 * @param hex : the HEX string
	 */

	static byte[] hexStr2Bytes(String hex) {
		// Adding one byte to get the right conversion
		// Values starting with "0" can be converted
		byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();

		// Copy all the REAL bytes, not the "first"
		byte[] ret = new byte[bArray.length - 1];
		for (int i = 0; i < ret.length; i++) {
			ret[i] = bArray[i + 1];
		}
		return ret;
	}

	/**
	 * This method uses the JCE to provide the crypto algorithm. HMAC computes a
	 * Hashed Message Authentication Code with the crypto hash algorithm as a
	 * parameter.
	 *
	 * @param crypto : the crypto algorithm (HmacSHA1, HmacSHA256, HmacSHA512)
	 * @param keyBytes : the bytes to use for the HMAC key
	 * @param text : the message or text to be authenticated
	 */

	private static byte[] hmac_sha(String crypto, byte[] keyBytes, byte[] text) {
		try {
			Mac hmac;
			hmac = Mac.getInstance(crypto);
			SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
			hmac.init(macKey);
			return hmac.doFinal(text);
		} catch (GeneralSecurityException gse) {
			throw new UndeclaredThrowableException(gse);
		}
	}

	static String stepsToString(long steps) {
		String s = Long.toHexString(steps).toUpperCase();

		while (s.length() < 16) {
			s = "0" + s;
		}

		return s;
	}

	static long timeToSteps(long timeInSec) {
		long T0 = 0;

		return (timeInSec - T0) / TIME_STEP;
	}

	static String timeToStepsString(long timeInSec) {
		return stepsToString(timeToSteps(timeInSec));
	}

	public String generateTOTP() {
		final long steps = timeToSteps(System.currentTimeMillis() / 1000);
		return generateTOTP(steps);
	}

	public String getSecret() {
		return secret;
	}

	public void setSecret(String secret) {
		this.secret = secret;
	}

	public boolean verify(final String totp) {
		final long steps = timeToSteps(System.currentTimeMillis() / 1000);
		return verify(totp, steps);

	}

	String generateTOTP(long timeSteps) {
		String steps = stepsToString(timeSteps);
		return generateTOTP(this.secret.getBytes(), steps);
	}

	boolean verify(final String totp, long timeSteps) {

		String x = generateTOTP(this.secret.getBytes(), stepsToString(timeSteps));
		if (x.equalsIgnoreCase(totp)) {
			return true;
		}
		x = generateTOTP(this.secret.getBytes(), stepsToString(timeSteps - 1));
		if (x.equalsIgnoreCase(totp)) {
			return true;
		}
		x = generateTOTP(this.secret.getBytes(), stepsToString(timeSteps + 1));
		return x.equalsIgnoreCase(totp);
	}
}
