/**
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

class LicenceLoaderImpl
		implements LicenceLoader {

	LicenceLoaderImpl() {
	}

	@Override
	public Licence loadLicence(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
		InputStream in = null;
		try {
			in = new FileInputStream(file);
			return loadLicence(in);
		} finally {
			if (in != null) {
				in.close();
			}
		}
	}

	@Override
	public Licence loadLicence(InputStream inputStream)
			throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
		ImmutableLicence licence = new ImmutableLicence();

		licence.load(inputStream);

		licence.setValidator(new LicenceValidatorImpl());

		return licence;
	}

	@Override
	public Licence loadLicence(String filename) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
		return loadLicence(new File(filename));
	}
}
