/**
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

//~--- non-JDK imports --------------------------------------------------------

import tigase.xml.Element;

import java.util.logging.Logger;

//~--- JDK imports ------------------------------------------------------------

/**
 * Default implementation of {@link tigase.licence.LicenceCheckerUpdateCallback}
 *
 * @author Wojciech Kapcia
 */
public class LicenceCheckerUpdateCallbackImpl
		implements LicenceCheckerUpdateCallback {

	private static final Logger log = Logger.getLogger("tigase.stats");
	private String componentName;

	//~--- constructors ---------------------------------------------------------

	/**
	 * Constructs default implementation of handling updates of statistics data on
	 * per-component basis providing most basic statistics data about system.
	 *
	 * @param cmpName - name of the component for which UpdateCallback should be constructed
	 */

	public LicenceCheckerUpdateCallbackImpl(String cmpName) {
		this.componentName = cmpName;
	}

	//~--- methods --------------------------------------------------------------
	@Override
	public Element getComponentAdditionalData() {
		log.finest("Obtaining additional component information");
		Element componentAdditionalInfo = new Element("ComponentAdditionalInfo");
		componentAdditionalInfo.setAttribute("name", componentName);
		return (componentAdditionalInfo);
	}

	//~--- get methods ----------------------------------------------------------
	@Override
	public String getMissingLicenseWarning() {
		//J-
		return "\n" + "This installation contains Tigase ACS package, not an open source software.\n" +
				"The Tigase ACS is only available under a commercial license.\n" +
				"The full text of the commercial license agreement is available upon request.\n" + "\n" +
				"More information about ACS component and licensing can be found here:\n" +
				"http://www.tigase.com/content/tigase-acs-advanced-clustering-strategy" + "\n" +
				"The Tigase ACS component is provided free of charge for testing and\n" +
				"development purposes only. Any use of the component on production systems,\n" +
				"either commercial or not-for-profit, requires the purchase of a license.\n" + "\n" +
				"If the Tigase ACS component is activated without a valid license, it will\n" +
				"continue to work, including its full set of features, but it will send\n" +
				"certain statistical information to Tigase's servers on a regular basis.\n" +
				"If the Tigase ACS component cannot access our servers to send information,\n" +
				"it will stop working. Once a valid license is installed, the Tigase ACS\n" +
				"component will stop sending statistical information to Tigase's servers.\n" + "\n" +
				"By activating the Tigase ACS component without a valid license you agree\n" +
				"and accept that the component will send certain statistical information\n" +
				"(such as DNS domain names, vhost names, number of online users, number of\n" +
				"cluster nodes, etc.) which may be considered confidential and proprietary\n" +
				"by the user. You accept and confirm that such information, which may be\n" +
				"considered confidential or proprietary, will be transferred to Tigase's\n" +
				"servers and that you will not pursue any remedy at law as a result of the\n" +
				"information transfer.\n" +
				"If the Tigase ACS component is installed but not activated, no statistical\n" +
				"information will be sent to Tigase's servers.";
		//J+
	}

	@Override
	public boolean additionalValidation(Licence lic) {
		return true;
	}
}

//~ Formatted in Tigase Code Convention on 13/10/17
