/**
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import tigase.xml.Element;

import java.util.Map;
import java.util.Optional;

/**
 * Interface for handling updates of statistics data on per-component basis.
 * <br>
 *
 * @author Wojciech Kapcia
 */
public interface LicenceCheckerUpdateCallback {

	/**
	 * Method responsible for obtaining additional component information to be
	 * submitted to the server.
	 *
	 * @return object with updated StatisticsData
	 */
	Element getComponentAdditionalData();

	default Optional<Map<String, String>> getServerVerifiableMetrics() {
		return Optional.empty();
	}

	// ~--- get methods
	// ----------------------------------------------------------

	/**
	 * Method responsible for retrieving warning about missing licence.
	 *
	 * @return a value of <code>String</code>
	 */
	String getMissingLicenseWarning();

	/**
	 * Additional licence validation.
	 *
	 * @param lic licence
	 *
	 * @return {@code true} if addiotional check passed and licence is valid.
	 */
	boolean additionalValidation(Licence lic);
}

// ~ Formatted in Tigase Code Convention on 13/10/17
