/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2017 "Tigase, Inc." <office@tigase.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */

package tigase.licence.utils;

import tigase.conf.ConfiguratorAbstract;
import tigase.server.XMPPServer;
import tigase.vhosts.VHostManager;
import tigase.xmpp.JID;

import java.util.ArrayList;
import java.util.List;

public class VHostsRetriever {
	private static List<JID> temps = new ArrayList<>();

	public static List<JID> getManagedVHosts() {
		List<JID> result = new ArrayList<>();
		ConfiguratorAbstract conf = XMPPServer.getConfigurator();
		if (conf != null) {
			VHostManager vhostman = (VHostManager) conf.getComponent("vhost-man");
			if (vhostman != null) {
				result = vhostman.getAllVHosts();
			}
		} else {
			// quite possibly we are simply running test
			if (!temps.isEmpty()) {
				result.addAll(temps);
			}
		}
		return result;
	}

	public static boolean addDefaultVHost(JID vhost) {
		return temps.add(vhost);
	}
}
