/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2016 "Tigase, Inc." <office@tigase.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */

package tigase.licence.utils;

import javax.xml.ws.http.HTTPException;

public class TooManyRequestsHTTPException extends HTTPException {

	private int retryAfter;

	/**
	 * Constructor for the TooManyRequestsHTTPException
	 *
	 * @param statusCode <code>int</code> for the HTTP status code
	 **/
	public TooManyRequestsHTTPException(int statusCode) {
		super(statusCode);
		this.retryAfter = 60;
	}

	/**
	 * Constructor for the TooManyRequestsHTTPException
	 *
	 * @param statusCode <code>int</code> for the HTTP status code
	 * @param retryAfter <code>int</code> for the delay time after which
	 * subsequent request should be made
	 **/
	public TooManyRequestsHTTPException(int statusCode, int retryAfter) {
		super(statusCode);
		this.retryAfter = retryAfter;
	}

	public int getRetryAfter() {
		return this.retryAfter;
	}

	@Override
	public String getMessage() {
		return "Too Many Requests";
	}
}
