/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2013 "Tigase, Inc." <office@tigase.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 */
package tigase.licence;

//~--- non-JDK imports --------------------------------------------------------
import tigase.xml.Element;

import static tigase.licence.LicenceCheckerUpdater.init;


//~--- JDK imports ------------------------------------------------------------
import java.util.logging.Logger;

/**
 * Default implementation of {@link tigase.licence.LicenceCheckerUpdateCallback}
 *
 * @author Wojciech Kapcia <wojciech.kapcia@tigase.org>
 */
public class LicenceCheckerUpdateCallbackImpl
		implements LicenceCheckerUpdateCallback {

	private static final Logger log = Logger.getLogger( "tigase.stats" );
	private String componentName;

	//~--- constructors ---------------------------------------------------------
	/**
	 * Constructs default implementation of handling updates of statistics data on
	 * per-component basis providing most basic statistics data about system.
	 */
	static {
		init();
	}

	public LicenceCheckerUpdateCallbackImpl( String cmpName ) {
		this.componentName = cmpName;
	}

	//~--- methods --------------------------------------------------------------
	@Override
	public Element getComponentAdditionalData() {
		log.finest( "Obtaining additional component information" );
		Element componentAdditionalInfo = new Element( "ComponentAdditionalInfo" );
		componentAdditionalInfo.setAttribute( "name", componentName );
		return ( componentAdditionalInfo );
	}

	//~--- get methods ----------------------------------------------------------
	@Override
	public String getMissingLicenseWarning() {
		//J-
		return "\n"
					 + "This installation contains Tigase ACS package, not an open source software.\n"
					 + "The Tigase ACS is only available under a commercial license.\n"
					 + "The full text of the commercial license agreement is available upon request.\n"
					 + "\n"
					 + "More information about ACS component and licensing can be found here:\n"
					 + "http://www.tigase.com/content/tigase-acs-advanced-clustering-strategy"
					 + "\n"
					 + "The Tigase ACS component is provided free of charge for testing and\n"
					 + "development purposes only. Any use of the component on production systems,\n"
					 + "either commercial or not-for-profit, requires the purchase of a license.\n"
					 + "\n"
					 + "If the Tigase ACS component is activated without a valid license, it will\n"
					 + "continue to work, including its full set of features, but it will send\n"
					 + "certain statistical information to Tigase's servers on a regular basis.\n"
					 + "If the Tigase ACS component cannot access our servers to send information,\n"
					 + "it will stop working. Once a valid license is installed, the Tigase ACS\n"
					 + "component will stop sending statistical information to Tigase's servers.\n"
					 + "\n"
					 + "By activating the Tigase ACS component without a valid license you agree\n"
					 + "and accept that the component will send certain statistical information\n"
					 + "(such as DNS domain names, vhost names, number of online users, number of\n"
					 + "cluster nodes, etc.) which may be considered confidential and proprietary\n"
					 + "by the user. You accept and confirm that such information, which may be\n"
					 + "considered confidential or proprietary, will be transferred to Tigase's\n"
					 + "servers and that you will not pursue any remedy at law as a result of the\n"
					 + "information transfer.\n"
					 + "If the Tigase ACS component is installed but not activated, no statistical\n"
					 + "information will be sent to Tigase's servers.";
		//J+
	}

	@Override
	public boolean additionalValidation(Licence lic) {
		return true;
	}
}

//~ Formatted in Tigase Code Convention on 13/10/17
