package tigase.licence;

import tigase.licence.LicenceValidator.ValidationResult;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public interface Licence {

	static final String APP_ID_KEY = "app-id";

	static final String BANNED_KEY = "banned";

	static final String DISPLAY_LICENCE_NOTICE_KEY = "display-licence-notice";

	static final String SENDING_STATISTICS_KEY = "sendingStatistics";

	static final String MAX_ONLINE_USERS_KEY = "max-online-users";

	static final String MAX_CLUSTER_NODES_KEY = "max-cluster-nodes";

	static final String SIGNATURE_ALGO = "SHA1withRSA";

	static final String VALID_SINCE_KEY = "valid-since";

	static final String VALID_UNTIL_KEY = "valid-until";

	static final String VHOST_NAME_KEY = "vhost-name";

	static final String VHOSTS_KEY = "vhosts";

	static final String VHOSTS_DIFF_RATIO_KEY = "vhosts-diff-ratio";

	ValidationResult check() throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, ParseException;

	byte[] getBytes();

	String getLicenceDigest();

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Boolean</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 */
	Boolean getPropertyAsBoolean(String key);

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Calendar</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 * @throws ParseException
	 *             if the specified properties cannot be parsed.
	 */
	Calendar getPropertyAsCalendar(String key) throws ParseException;

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Integer</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 * @throws ParseException
	 *             if the specified properties cannot be parsed.
	 */
	Date getPropertyAsDate(String key) throws ParseException;

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Double</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 */
	Double getPropertyAsDouble(String key);

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Integer</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 */
	Integer getPropertyAsInteger(String key);

	/**
	 * Searches for the property with the specified key in licence. The method
	 * returns <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 */
	String getPropertyAsString( String key );

}
