/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import tigase.licence.Licence;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.LicenceCheckerUpdater;
import tigase.licence.LicenceLoaderFactory;
import tigase.stats.collector.DefaultElementSigner;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.StatisticsData;
import tigase.stats.collector.provider.StatisticsUploader;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class LicenceChecker {
    protected static int failCount = 0;
    protected static final int failCountLimit = 10;
    private static final Logger a = Logger.getLogger("tigase.stats");
    private static final SecretKeySpec b = new SecretKeySpec("0000".getBytes(), "HmacSHA1");
    protected static final ElementSigner signer = new DefaultElementSigner((Key)b);
    protected static StatisticsUploader uploader = new StatisticsUploader(signer);
    private static StatisticsUploader.ResultCallback c;
    protected static ScheduledExecutorService timer;
    protected static TimerTask licencePeriodicCheck;
    private final String d;
    private Licence e;
    private final File f;
    private final LicenceCheckerUpdateCallback g;
    private Date h;
    private boolean i = true;
    protected static final Map<String, LicenceChecker> licenceCheckers;

    public static LicenceChecker getLicenceChecker(String cmpName) {
        return LicenceChecker.getLicenceChecker(cmpName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static LicenceChecker getLicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        LicenceChecker licenceChecker;
        if (call == null) {
            call = new LicenceCheckerUpdateCallbackImpl(cmpName);
        }
        if ((licenceChecker = licenceCheckers.get(cmpName)) == null) {
            String string;
            void var1_1;
            licenceChecker = new LicenceChecker(cmpName, (LicenceCheckerUpdateCallback)var1_1);
            licenceCheckers.put(string, licenceChecker);
        }
        return licenceChecker;
    }

    /*
     * WARNING - void declaration
     */
    private LicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        void var1_1;
        LicenceChecker licenceChecker;
        this.g = licenceChecker;
        this.d = cmpName;
        licenceChecker = this;
        Logger logger = Logger.getLogger("tigase.licence");
        a.setLevel(Level.ALL);
        logger.setLevel(Level.ALL);
        try {
            FileHandler fileHandler = new FileHandler("logs/statistics.log");
            fileHandler.setLevel(Level.ALL);
            logger.addHandler(fileHandler);
            a.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            a.log(Level.CONFIG, licenceChecker.d);
        }
        if (licencePeriodicCheck == null) {
            licencePeriodicCheck = new a(this, 0);
            timer.schedule(licencePeriodicCheck, 5L, TimeUnit.MINUTES);
        }
        a.log(Level.CONFIG, "Created licence checker for {0}", var1_1);
        this.f = new File("etc/" + this.d + ".licence");
    }

    private boolean c() {
        try {
            Object object = LicenceLoaderFactory.create();
            if (!this.f.exists()) {
                a.log(Level.WARNING, "Missing licence file ({0})!", this.f);
                return false;
            }
            this.e = object.loadLicence(this.f);
            this.h = this.e.getPropertyAsDate("valid-until");
            try {
                switch (this.e.check()) {
                    case invalidDates: {
                        a.warning("Licence is expired.");
                        return false;
                    }
                    case invalidSignature: {
                        a.warning("Invalid or modified licence file.");
                        return false;
                    }
                    case valid: {
                        a.warning("Licence OK");
                    }
                }
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "Licence invalid", exception);
                return false;
            }
            object = this.e.getPropertyAsString("app-id");
            if (object == null || !((String)object).equals(this.d)) {
                a.log(Level.WARNING, "This is not licence for {0} Component!", this.d);
                return false;
            }
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "Can't load licence file. Error: {0}", exception.getMessage());
            return false;
        }
        return true;
    }

    public Date getValidUntil() {
        return this.h;
    }

    public LicenceCheckerUpdateCallback getUpdateCall() {
        return this.g;
    }

    static /* synthetic */ boolean a(LicenceChecker licenceChecker, boolean bl) {
        licenceChecker.i = false;
        return false;
    }

    static {
        timer = Executors.newSingleThreadScheduledExecutor();
        licenceCheckers = new HashMap<String, LicenceChecker>(5);
    }

    public class ResCall
    implements StatisticsUploader.ResultCallback {
        private /* synthetic */ LicenceChecker a;

        public ResCall(LicenceChecker licenceChecker) {
            this.a = licenceChecker;
        }

        /*
         * WARNING - void declaration
         */
        public void onFailure(Exception ex) {
            void var1_1;
            if (this.a.i) {
                a.log(Level.SEVERE, "Could not upload statistics within required period of time, shutting down the system");
                System.exit(402);
                return;
            }
            a.log(Level.WARNING, "Could not upload statistics; " + (10 - ++failCount) + " attempts before system shutdown", (Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void onSuccess(Element result) {
            void var1_1;
            a.log(Level.WARNING, "statistics uploaded = {0}; resetting number of attempts", result != null ? var1_1.toString() : null);
            failCount = 0;
            LicenceChecker.a(this.a, false);
        }
    }

    private final class a
    extends TimerTask {
        private /* synthetic */ LicenceChecker a;

        private a(LicenceChecker licenceChecker) {
            this.a = licenceChecker;
        }

        @Override
        public final void run() {
            boolean bl = false;
            long l = Long.MAX_VALUE;
            long l2 = new Date().getTime();
            a.log(Level.WARNING, "\n\nLicense verification runtime.\n");
            if (failCount > 10) {
                a.log(Level.SEVERE, "Could not upload statistics within required period of time, shutting down the system");
                System.exit(402);
            }
            Element element = new Element("unlicencedComponenents");
            for (String string : licenceCheckers.keySet()) {
                LicenceChecker object = licenceCheckers.get(string);
                if (object.c()) {
                    a.log(Level.WARNING, "Licence valid untill: {0}", object.getValidUntil());
                    long element2 = object.h.getTime() - l2;
                    l = element2 < l ? element2 : l;
                    continue;
                }
                a.warning(object.getUpdateCall().getMissingLicenseWarning());
                Element element2 = object.getUpdateCall().getComponentAdditionalData();
                element.addChild((XMLNodeIfc)element2);
                bl |= true;
            }
            if (bl) {
                StatisticsData statisticsData = LicenceCheckerUpdater.updateData();
                statisticsData.setAdditionalData(statisticsData.getAdditionalData() + element.toString());
                a.warning("Uploading data: " + statisticsData.toElement());
                c = new ResCall(this.a);
                uploader.upload(statisticsData, c);
                timer.schedule(licencePeriodicCheck, 1L, TimeUnit.DAYS);
            } else {
                timer.schedule(licencePeriodicCheck, l, TimeUnit.MILLISECONDS);
            }
            a.log(Level.WARNING, "\n\n");
        }

        /* synthetic */ a(LicenceChecker licenceChecker, byte by) {
            this(licenceChecker);
        }
    }
}

