package tigase.licence;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.util.Calendar;

class LicenceValidatorImpl implements LicenceValidator {

	private final static byte[] DEFAULT_KEY = { (byte) 0x30, (byte) 0x81, (byte) 0x9f, (byte) 0x30, (byte) 0x0d, (byte) 0x06,
			(byte) 0x09, (byte) 0x2a, (byte) 0x86, (byte) 0x48, (byte) 0x86, (byte) 0xf7, (byte) 0x0d, (byte) 0x01,
			(byte) 0x01, (byte) 0x01, (byte) 0x05, (byte) 0x00, (byte) 0x03, (byte) 0x81, (byte) 0x8d, (byte) 0x00,
			(byte) 0x30, (byte) 0x81, (byte) 0x89, (byte) 0x02, (byte) 0x81, (byte) 0x81, (byte) 0x00, (byte) 0xa9,
			(byte) 0x4d, (byte) 0xa6, (byte) 0x57, (byte) 0xd4, (byte) 0xca, (byte) 0xb3, (byte) 0x26, (byte) 0x9b,
			(byte) 0x22, (byte) 0x27, (byte) 0xd2, (byte) 0x47, (byte) 0xb8, (byte) 0xc0, (byte) 0x0b, (byte) 0x85,
			(byte) 0xf5, (byte) 0x4c, (byte) 0x03, (byte) 0x6f, (byte) 0xf1, (byte) 0xd3, (byte) 0x4c, (byte) 0x90,
			(byte) 0x43, (byte) 0x9f, (byte) 0xbc, (byte) 0xeb, (byte) 0xf1, (byte) 0x07, (byte) 0x42, (byte) 0x86,
			(byte) 0xbc, (byte) 0x37, (byte) 0xcb, (byte) 0x5e, (byte) 0x45, (byte) 0x44, (byte) 0xd1, (byte) 0x6a,
			(byte) 0xb4, (byte) 0x01, (byte) 0xc3, (byte) 0x15, (byte) 0xb2, (byte) 0xed, (byte) 0x51, (byte) 0x8f,
			(byte) 0x89, (byte) 0x43, (byte) 0x9e, (byte) 0xb5, (byte) 0xfe, (byte) 0xfd, (byte) 0x2c, (byte) 0xa8,
			(byte) 0x13, (byte) 0x5c, (byte) 0xd2, (byte) 0xf8, (byte) 0x2e, (byte) 0xec, (byte) 0xba, (byte) 0xd8,
			(byte) 0xa1, (byte) 0xa6, (byte) 0xca, (byte) 0x68, (byte) 0x31, (byte) 0x8a, (byte) 0x0d, (byte) 0xb5,
			(byte) 0xf8, (byte) 0xb9, (byte) 0xee, (byte) 0xb5, (byte) 0xff, (byte) 0x16, (byte) 0x93, (byte) 0x1e,
			(byte) 0x64, (byte) 0x6a, (byte) 0xdd, (byte) 0x06, (byte) 0xef, (byte) 0x12, (byte) 0x66, (byte) 0xf6,
			(byte) 0x3d, (byte) 0x8f, (byte) 0xfa, (byte) 0x3f, (byte) 0xf3, (byte) 0x74, (byte) 0x2c, (byte) 0x34,
			(byte) 0x4e, (byte) 0x07, (byte) 0x4b, (byte) 0x9c, (byte) 0x57, (byte) 0x91, (byte) 0x55, (byte) 0xce,
			(byte) 0x78, (byte) 0x4e, (byte) 0x56, (byte) 0x52, (byte) 0xce, (byte) 0x4e, (byte) 0x7b, (byte) 0xf6,
			(byte) 0x02, (byte) 0x8f, (byte) 0xe3, (byte) 0x8a, (byte) 0xcf, (byte) 0x65, (byte) 0xb3, (byte) 0x4e,
			(byte) 0x7e, (byte) 0x2e, (byte) 0xd5, (byte) 0x2d, (byte) 0xe3, (byte) 0x10, (byte) 0x61, (byte) 0x02,
			(byte) 0x03, (byte) 0x01, (byte) 0x00, (byte) 0x01, };

	private final static byte[] DEFAULT_KEY_SUM = { (byte) 0x11, (byte) 0x88, (byte) 0x25, (byte) 0xe8, (byte) 0x87,
			(byte) 0xbf, (byte) 0x46, (byte) 0xb0, (byte) 0xd2, (byte) 0x80, (byte) 0x15, (byte) 0x97, (byte) 0x03,
			(byte) 0x76, (byte) 0xc3, (byte) 0x3e, };

	public static byte[] decodeHex(char[] data) {

		int len = data.length;

		if ((len & 0x01) != 0) {
			throw new RuntimeException("Odd number of characters.");
		}

		byte[] out = new byte[len >> 1];

		// two characters form the hex value.
		for (int i = 0, j = 0; j < len; i++) {
			int f = toDigit(data[j], j) << 4;
			j++;
			f = f | toDigit(data[j], j);
			j++;
			out[i] = (byte) (f & 0xFF);
		}

		return out;
	}

	private static int toDigit(char ch, int index) {
		int digit = Character.digit(ch, 16);
		if (digit == -1) {
			throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
		}
		return digit;
	}

	private final KeyFactory keyFactory;

	private final PublicKey publicKey;

	LicenceValidatorImpl() throws NoSuchAlgorithmException, InvalidKeySpecException {
		this(null);
	}

	LicenceValidatorImpl(PublicKey key) throws NoSuchAlgorithmException, InvalidKeySpecException {
		this.keyFactory = KeyFactory.getInstance("RSA");
		if (key == null) {
			publicKey = extractPublicKey();
		} else {
			publicKey = key;
		}
	}

	@Override
	public ValidationResult check(Licence licence) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException,
			ParseException {
		if (!checkSignature(licence, publicKey))
			return ValidationResult.invalidSignature;

		final Calendar date = Calendar.getInstance();

		final Calendar validUntil = licence.getPropertyAsCalendar(Licence.VALID_UNTIL_KEY);
		if (validUntil != null) {
			validUntil.add(Calendar.DATE, 1);
		}
		final Calendar validSince = licence.getPropertyAsCalendar(Licence.VALID_SINCE_KEY);

		if (validSince != null && date.before(validSince)) {
			return ValidationResult.invalidDates;
		}
		if (validUntil != null && !date.before(validUntil)) {
			return ValidationResult.invalidDates;
		}

		return ValidationResult.valid;
	}

	private boolean checkSignature(Licence licence, PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException,
			SignatureException {
		Signature sig = Signature.getInstance(Licence.SIGNATURE_ALGO);
		sig.initVerify(publicKey);
		byte[] signature = decodeHex(licence.getPropertyAsString("signature").toCharArray());
		byte[] data = licence.getBytes();
		sig.update(data);
		boolean ok = signature == null ? false : sig.verify(signature);
		return ok;
	}

	private final PublicKey extractPublicKey() throws InvalidKeySpecException {
		EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(DEFAULT_KEY);
		return keyFactory.generatePublic(publicKeySpec);
	}

	private PublicKey retrievePublicKey(byte[] buffer) throws InvalidKeySpecException {
		if (buffer == null)
			return null;
		EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(buffer);
		return keyFactory.generatePublic(publicKeySpec);
	}
}
