/*
 * LicenceCheckerUpdateCallback.java
 *
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2013 "Tigase, Inc." <office@tigase.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 */
package tigase.licence;

import tigase.xml.Element;

/**
 * Interface for handling updates of statistics data on per-component basis.
 * <p>
 * @author Wojciech Kapcia <wojciech.kapcia@tigase.org>
 */
public interface LicenceCheckerUpdateCallback {

	/**
	 * Method responsible for obtaining additional component information to be
	 * submitted to the server.
	 *
	 * @return object with updated StatisticsData
	 */
	Element getComponentAdditionalData();

	//~--- get methods ----------------------------------------------------------
	/**
	 * Method responsible for retrieving warning about missing licence.
	 *
	 * @return a value of <code>String</code>
	 */
	String getMissingLicenseWarning();
}


//~ Formatted in Tigase Code Convention on 13/10/17
