package tigase.licence;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import tigase.licence.LicenceValidator.ValidationResult;

public interface Licence {

	static final String SIGNATURE_ALGO = "SHA1withRSA";

	static final String VALID_SINCE_KEY = "valid-since";

	static final String VALID_UNTIL_KEY = "valid-until";

	ValidationResult check() throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, ParseException;

	byte[] getBytes();

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Boolean</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 */
	Boolean getPropertyAsBoolean(String key);

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Calendar</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 * @throws ParseException
	 *             if the specified properties cannot be parsed.
	 */
	Calendar getPropertyAsCalendar(String key) throws ParseException;

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Integer</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 * @throws ParseException
	 *             if the specified properties cannot be parsed.
	 */
	Date getPropertyAsDate(String key) throws ParseException;

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Double</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 */
	Double getPropertyAsDouble(String key);

	/**
	 * Searches for the property with the specified key in licence and try to
	 * convert property to <code>Integer</code>. The method returns
	 * <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 */
	Integer getPropertyAsInteger(String key);

	/**
	 * Searches for the property with the specified key in licence. The method
	 * returns <code>null</code> if the property is not found.
	 * 
	 * @param key
	 *            the property key.
	 * @return the value in this licence with the specified key value.
	 */
	String getPropertyAsString(String key);

}
