/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.omemo;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.SessionBuilder;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignedPreKeyStore;
import tigase.jaxmpp.core.client.AsyncCallback;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.Hex;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.XmppModule;
import tigase.jaxmpp.core.client.criteria.Criteria;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementBuilder;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.forms.JabberDataElement;
import tigase.jaxmpp.core.client.xmpp.forms.XDataType;
import tigase.jaxmpp.core.client.xmpp.modules.ContextAware;
import tigase.jaxmpp.core.client.xmpp.modules.InitializingModule;
import tigase.jaxmpp.core.client.xmpp.modules.ResourceBinderModule;
import tigase.jaxmpp.core.client.xmpp.modules.extensions.Extension;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.Bundle;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.JaXMPPSignalProtocolStore;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.KeysRetriever;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.OmemoExtension;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.XmppOMEMOSession;
import tigase.jaxmpp.core.client.xmpp.modules.pubsub.PubSubErrorCondition;
import tigase.jaxmpp.core.client.xmpp.modules.pubsub.PubSubModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.IQ;

public class OmemoModule
implements XmppModule,
ContextAware,
InitializingModule {
    static final String CURRENT = "current";
    static final String XMLNS = "eu.siacs.conversations.axolotl";
    public static final String DEVICELIST_NODE = "eu.siacs.conversations.axolotl.devicelist";
    public static final String AUTOCREATE_OMEMO_SESSION = "eu.siacs.conversations.axolotl#AUTOCREATE_OMEMO_SESSION";
    static final String BUNDLES_NODE = "eu.siacs.conversations.axolotl.bundles:";
    private static final CipherFactory DEFAULT_CIPHER_FACTORY = new CipherFactory(){

        @Override
        public Cipher cipherInstance(int mode, SecretKeySpec secretKey, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(mode, (Key)secretKey, ivSpec);
            return cipher;
        }
    };
    private final boolean addOwnKeys = true;
    private final Random rnd = new SecureRandom();
    private Context context;
    private CipherFactory customCipherFactory;
    private OmemoExtension extension = new OmemoExtension(this);
    private Logger log = Logger.getLogger(this.getClass().getName());
    private PubSubModule pubSub;

    public static JaXMPPSignalProtocolStore getSignalProtocolStore(SessionObject sessionObject) {
        return (JaXMPPSignalProtocolStore)sessionObject.getProperty("eu.siacs.conversations.axolotl#SignalProtocolStore");
    }

    public static void setSignalProtocolStore(SessionObject sessionObject, JaXMPPSignalProtocolStore store) {
        sessionObject.setProperty(SessionObject.Scope.user, "eu.siacs.conversations.axolotl#SignalProtocolStore", (Object)store);
    }

    public CipherFactory getCustomCipherFactory() {
        return this.customCipherFactory;
    }

    public void setCustomCipherFactory(CipherFactory customCipherFactory) {
        this.customCipherFactory = customCipherFactory;
    }

    public Criteria getCriteria() {
        return null;
    }

    public String[] getFeatures() {
        return new String[]{XMLNS, "eu.siacs.conversations.axolotl.devicelist+notify"};
    }

    public void process(Element element) throws JaxmppException {
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void afterRegister() {
        this.pubSub = (PubSubModule)this.context.getModuleProvider().getModule(PubSubModule.class);
        if (this.pubSub == null) {
            throw new RuntimeException("There is no PubSubModule registered!");
        }
        this.context.getEventBus().addHandler(PubSubModule.NotificationReceivedHandler.NotificationReceivedEvent.class, (EventHandler)((PubSubModule.NotificationReceivedHandler)(sessionObject, message, pubSubJID, nodeName, itemId, payload, delayTime, itemType) -> {
            if (pubSubJID != null && pubSubJID.getBareJid().equals((Object)this.context.getSessionObject().getUserBareJid()) && nodeName.equals(DEVICELIST_NODE) && itemId.equals(CURRENT)) {
                try {
                    this.processOwnDevicesList(payload);
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Cannot handle DeviceList event", e);
                }
            } else if (pubSubJID != null && pubSubJID.getBareJid().equals((Object)this.context.getSessionObject().getUserBareJid()) && nodeName.startsWith(BUNDLES_NODE) && itemId.equals(CURRENT)) {
                try {
                    this.processOwnDevicesBundle(pubSubJID.getBareJid(), payload, nodeName);
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Cannot handle DeviceList event", e);
                }
            }
        }));
    }

    public void subscribeForDeviceList(BareJID jid) throws JaxmppException {
        JID myJid = ResourceBinderModule.getBindedJID((SessionObject)this.context.getSessionObject());
        this.pubSub.subscribe(jid, DEVICELIST_NODE, myJid, new PubSubModule.SubscriptionAsyncCallback(){

            public void onTimeout() throws JaxmppException {
                System.out.println("DEVICE LIST SUBSCRIPTION TIMEOUT");
            }

            protected void onSubscribe(IQ response, PubSubModule.SubscriptionElement subscriptionElement) {
                System.out.println("DEVICE LIST SUBSCRIBE");
            }

            protected void onEror(IQ response, XMPPException.ErrorCondition errorCondition, PubSubErrorCondition pubSubErrorCondition) throws JaxmppException {
                System.out.println("DEVICE LIST SUBSCRIPTION ERROR: " + pubSubErrorCondition);
            }
        });
    }

    public void beforeRegister() {
    }

    public void beforeUnregister() {
    }

    public void publishDeviceList() throws JaxmppException {
        this.pubSub.retrieveItem(null, DEVICELIST_NODE, new PubSubModule.RetrieveItemsAsyncCallback(){

            public void onTimeout() throws JaxmppException {
                this.log.warning("Cannot retrieve own device lists: Timeout");
            }

            protected void onEror(IQ response, XMPPException.ErrorCondition errorCondition, PubSubErrorCondition pubSubErrorCondition) throws JaxmppException {
                this.log.warning("Cannot retrieve own device lists: " + errorCondition);
                if (errorCondition == XMPPException.ErrorCondition.item_not_found) {
                    try {
                        OmemoModule.this.publishOwnKeys(OmemoModule.getSignalProtocolStore(OmemoModule.this.context.getSessionObject()), new ArrayList());
                    }
                    catch (Exception e) {
                        this.log.log(Level.WARNING, "Cannot publish own keys and device list", e);
                    }
                }
            }

            protected void onRetrieve(IQ responseStanza, String nodeName, Collection<PubSubModule.RetrieveItemsAsyncCallback.Item> items) {
                try {
                    Collection<Integer> ids = KeysRetriever.getDeviceIDsFromPayload(items);
                    OmemoModule.this.publishOwnKeys(OmemoModule.getSignalProtocolStore(OmemoModule.this.context.getSessionObject()), ids);
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Cannot publish own keys and device list", e);
                }
            }
        });
    }

    public void getKeys(BareJID jid, final KeysRetrieverHandler handler) throws JaxmppException {
        KeysRetriever keysRetriever = new KeysRetriever(this.context, jid){

            @Override
            protected void finish(List<Bundle> bundles) {
                if (handler != null) {
                    handler.onSuccess(bundles);
                }
            }

            @Override
            protected void error() {
                handler.onError();
            }
        };
        keysRetriever.retrieve();
    }

    public XmppOMEMOSession getOMEMOSession(BareJID jid) {
        return this.getOMEMOSession(jid, this.context.getSessionObject().getProperty(AUTOCREATE_OMEMO_SESSION) == Boolean.TRUE);
    }

    public XmppOMEMOSession createOMEMOSession(BareJID jid) {
        XmppOMEMOSession s = new XmppOMEMOSession(this.context.getEventBus(), jid);
        OmemoModule.getSignalProtocolStore(this.context.getSessionObject()).storeSession(s);
        return s;
    }

    public void createOMEMOSession(final BareJID jid, final CreateOMEMOSessionHandler handler) throws JaxmppException {
        final ArrayList bundles = new ArrayList();
        this.getKeys(jid, new KeysRetrieverHandler(){

            @Override
            public void onError() {
                handler.onError();
            }

            @Override
            public void onSuccess(List<Bundle> b1) {
                bundles.addAll(b1);
                this.runAddOwnKeys();
            }

            private void create() {
                XmppOMEMOSession session = null;
                try {
                    session = OmemoModule.this.createOMEMOSession(jid, bundles);
                    handler.onSessionCreated(session);
                }
                catch (XMLException e) {
                    e.printStackTrace();
                    handler.onError();
                }
                catch (UntrustedIdentityException e) {
                    e.printStackTrace();
                    handler.onError();
                }
            }

            private void runAddOwnKeys() {
                try {
                    OmemoModule.this.getKeys(OmemoModule.this.context.getSessionObject().getUserBareJid(), new KeysRetrieverHandler(){

                        @Override
                        public void onError() {
                            handler.onError();
                        }

                        @Override
                        public void onSuccess(List<Bundle> b2) {
                            bundles.addAll(b2);
                            this.create();
                        }
                    });
                }
                catch (Exception e) {
                    handler.onError();
                }
            }
        });
    }

    public Extension getExtension() {
        return this.extension;
    }

    public boolean isOMEMORequired(BareJID jid) {
        return OmemoModule.getSignalProtocolStore(this.context.getSessionObject()).isOMEMORequired(jid);
    }

    public XmppOMEMOSession getOMEMOSession(BareJID jid, boolean createIfNotExists) {
        XmppOMEMOSession sess = OmemoModule.getSignalProtocolStore(this.context.getSessionObject()).getSession(jid);
        if (sess != null) {
            return sess;
        }
        if (createIfNotExists) {
            return this.createFromOMEMOStore(jid);
        }
        return null;
    }

    CipherFactory getCipherFactory() {
        return this.customCipherFactory == null ? DEFAULT_CIPHER_FACTORY : this.customCipherFactory;
    }

    SessionObject getSessionObject() {
        return this.context.getSessionObject();
    }

    byte[] generateIV() {
        byte[] iv = new byte[12];
        this.rnd.nextBytes(iv);
        return iv;
    }

    void addBundesToSession(XmppOMEMOSession session, Collection<Bundle> bundles) throws XMLException, UntrustedIdentityException {
        JaXMPPSignalProtocolStore store = OmemoModule.getSignalProtocolStore(this.context.getSessionObject());
        for (Bundle b : bundles) {
            try {
                SignalProtocolAddress address = b.getAddress();
                PreKeyBundle bundle = b.getPreKeyBundle();
                List<PreKeyBundle> preKeys = b.getPreKeys();
                PreKeyBundle preKey = preKeys.get(this.rnd.nextInt(preKeys.size()));
                System.out.println(b.getDeviceId() + " :: " + b.getPreKeyBundle().getIdentityKey().getFingerprint());
                PreKeyBundle preKeyBundle = new PreKeyBundle(0, address.getDeviceId(), preKey.getPreKeyId(), preKey.getPreKey(), bundle.getSignedPreKeyId(), bundle.getSignedPreKey(), bundle.getSignedPreKeySignature(), bundle.getIdentityKey());
                SessionBuilder sb = new SessionBuilder((SessionStore)store, (PreKeyStore)store, (SignedPreKeyStore)store, (IdentityKeyStore)store, address);
                sb.process(preKeyBundle);
                SessionCipher sessionCipher = new SessionCipher((SessionStore)store, (PreKeyStore)store, (SignedPreKeyStore)store, (IdentityKeyStore)store, address);
                session.addDeviceCipher(address, sessionCipher);
            }
            catch (org.whispersystems.libsignal.InvalidKeyException e) {
                this.log.warning("Invalid key. Skipping.");
            }
        }
    }

    XmppOMEMOSession createOMEMOSession(BareJID jid, List<Bundle> bundles) throws XMLException, UntrustedIdentityException {
        XmppOMEMOSession session = this.createOMEMOSession(jid);
        this.addBundesToSession(session, bundles);
        return session;
    }

    void addOwnKeysToSession(final XmppOMEMOSession session) {
        try {
            this.getKeys(this.context.getSessionObject().getUserBareJid(), new KeysRetrieverHandler(){

                @Override
                public void onError() {
                }

                @Override
                public void onSuccess(List<Bundle> b2) {
                    try {
                        OmemoModule.this.addBundesToSession(session, b2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (JaxmppException e) {
            e.printStackTrace();
        }
    }

    private XmppOMEMOSession createFromOMEMOStore(BareJID jid) {
        JaXMPPSignalProtocolStore store = OmemoModule.getSignalProtocolStore(this.context.getSessionObject());
        if (store == null) {
            return null;
        }
        XmppOMEMOSession result = this.createOMEMOSession(jid);
        for (Integer id : store.getSubDeviceSessions(jid.toString())) {
            SignalProtocolAddress address = new SignalProtocolAddress(jid.toString(), id.intValue());
            SessionCipher sessionCipher = new SessionCipher((SessionStore)store, (PreKeyStore)store, (SignedPreKeyStore)store, (IdentityKeyStore)store, address);
            result.addDeviceCipher(address, sessionCipher);
        }
        BareJID ownJid = this.context.getSessionObject().getUserBareJid();
        for (Integer id : store.getSubDeviceSessions(ownJid.toString())) {
            SignalProtocolAddress address = new SignalProtocolAddress(ownJid.toString(), id.intValue());
            SessionCipher sessionCipher = new SessionCipher((SessionStore)store, (PreKeyStore)store, (SignedPreKeyStore)store, (IdentityKeyStore)store, address);
            result.addDeviceCipher(address, sessionCipher);
        }
        return result;
    }

    private void publishOwnKeys(final JaXMPPSignalProtocolStore store, final Collection<Integer> publishedDevicesId) throws JaxmppException, InvalidKeyIdException {
        int id = store.getLocalRegistrationId();
        ElementBuilder bldr = ElementBuilder.create((String)"bundle", (String)XMLNS);
        for (Object signedPreKey : store.loadSignedPreKeys()) {
            bldr.child("signedPreKeyPublic").setAttribute("signedPreKeyId", String.valueOf(signedPreKey.getId())).setValue(Base64.encode((byte[])signedPreKey.getKeyPair().getPublicKey().serialize())).up();
            bldr.child("signedPreKeySignature").setValue(Base64.encode((byte[])signedPreKey.getSignature())).up();
        }
        IdentityKeyPair identityKeyPair = store.getIdentityKeyPair();
        bldr.child("identityKey").setValue(Base64.encode((byte[])identityKeyPair.getPublicKey().serialize())).up();
        this.log.info("Publish key id: " + id + ": fingerprint: " + Hex.format((String)Hex.encode((byte[])identityKeyPair.getPublicKey().serialize(), (int)1), (int)8));
        bldr.child("prekeys");
        for (PreKeyRecord preKey : store.loadPreKeys()) {
            bldr.child("preKeyPublic").setAttribute("preKeyId", String.valueOf(preKey.getId())).setValue(Base64.encode((byte[])preKey.getKeyPair().getPublicKey().serialize())).up();
        }
        JabberDataElement options = new JabberDataElement(XDataType.submit);
        options.addTextSingleField("pubsub#access_model", "open");
        this.pubSub.publishItem(null, BUNDLES_NODE + id, CURRENT, bldr.getElement(), options, (AsyncCallback)new PubSubModule.PublishAsyncCallback(){

            public void onTimeout() throws JaxmppException {
                this.log.warning("Bundle " + store.getLocalRegistrationId() + " is not published: Timeout");
            }

            public void onPublish(String itemId) {
                OmemoModule.this.updateDeviceList(store, publishedDevicesId);
                this.log.info("Bundle " + store.getLocalRegistrationId() + " published.");
            }

            protected void onEror(IQ response, XMPPException.ErrorCondition errorCondition, PubSubErrorCondition pubSubErrorCondition) throws JaxmppException {
                this.log.warning("Bundle " + store.getLocalRegistrationId() + " is not published: " + errorCondition + ", " + pubSubErrorCondition);
            }
        });
    }

    private void updateDeviceList(JaXMPPSignalProtocolStore store, Collection<Integer> publishedIds) {
        try {
            HashSet<Integer> deviceIdsToPublish = new HashSet<Integer>();
            deviceIdsToPublish.addAll(publishedIds);
            deviceIdsToPublish.add(store.getLocalRegistrationId());
            this.log.fine("Adding local device id" + store.getLocalRegistrationId() + " to published list.");
            ElementBuilder bldr = ElementBuilder.create((String)"list", (String)XMLNS);
            for (Integer id : deviceIdsToPublish) {
                bldr.child("device").setAttribute("id", String.valueOf(id)).up();
            }
            JabberDataElement options = new JabberDataElement(XDataType.submit);
            options.addTextSingleField("pubsub#access_model", "open");
            this.pubSub.publishItem(null, DEVICELIST_NODE, CURRENT, bldr.getElement(), options, (AsyncCallback)new PubSubModule.PublishAsyncCallback(){

                public void onPublish(String itemId) {
                    this.log.info("Device list is published.");
                }

                public void onTimeout() throws JaxmppException {
                    this.log.warning("Device list is not published: Timeout");
                }

                protected void onEror(IQ response, XMPPException.ErrorCondition errorCondition, PubSubErrorCondition pubSubErrorCondition) throws JaxmppException {
                    this.log.warning("Device list is not published: " + errorCondition + ", " + pubSubErrorCondition);
                }
            });
        }
        catch (JaxmppException e) {
            this.log.log(Level.WARNING, "Cannot update DeviceList", e);
        }
    }

    private Collection<Integer> getDevicesId(Element payload) throws XMLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Element d : payload.getChildren("device")) {
            try {
                result.add(Integer.valueOf(d.getAttribute("id")));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private void processOwnDevicesBundle(BareJID jid, Element payload, String nodeName) throws JaxmppException, org.whispersystems.libsignal.InvalidKeyException {
        JaXMPPSignalProtocolStore store = OmemoModule.getSignalProtocolStore(this.context.getSessionObject());
        if (store == null) {
            this.log.warning("No OMEMO Store in SessionObject!");
            return;
        }
        int deviceId = Integer.valueOf(nodeName.substring(BUNDLES_NODE.length()));
        Bundle b = new Bundle(jid, deviceId, payload);
        SignalProtocolAddress addr = new SignalProtocolAddress(this.context.getSessionObject().getUserBareJid().toString(), deviceId);
        if (store.getIdentity(addr) == null) {
            store.saveIdentity(addr, b.getPreKeyBundle().getIdentityKey());
        }
    }

    private void processOwnDevicesList(Element payload) throws JaxmppException, InvalidKeyIdException {
        final JaXMPPSignalProtocolStore store = OmemoModule.getSignalProtocolStore(this.context.getSessionObject());
        if (store == null) {
            this.log.warning("No OMEMO Store in SessionObject!");
            return;
        }
        int deviceId = store.getLocalRegistrationId();
        Collection<Integer> publishedList = this.getDevicesId(payload);
        if (!publishedList.contains(deviceId)) {
            this.log.info("This device (" + deviceId + ") is not published. Preparing to publish.");
            this.publishOwnKeys(store, publishedList);
        }
        ArrayList<Integer> unknownIdentities = new ArrayList<Integer>();
        for (Integer id : publishedList) {
            IdentityKey identity;
            if (id == deviceId || (identity = store.getIdentity(new SignalProtocolAddress(this.context.getSessionObject().getUserBareJid().toString(), id.intValue()))) != null) continue;
            unknownIdentities.add(id);
        }
        if (!unknownIdentities.isEmpty()) {
            KeysRetriever kr = new KeysRetriever(this.context, this.context.getSessionObject().getUserBareJid()){

                @Override
                protected void finish(List<Bundle> bundles) {
                    for (Bundle bundle : bundles) {
                        try {
                            store.saveIdentity(bundle.getAddress(), bundle.getPreKeyBundle().getIdentityKey());
                        }
                        catch (Exception e) {
                            OmemoModule.this.log.log(Level.WARNING, "Cannot save identity " + bundle.getAddress(), e);
                        }
                    }
                }

                @Override
                protected void error() {
                }
            };
            kr.retrieve(unknownIdentities);
        }
    }

    public static interface KeysRetrieverHandler {
        public void onError();

        public void onSuccess(List<Bundle> var1);
    }

    public static interface CreateOMEMOSessionHandler {
        public void onError();

        public void onSessionCreated(XmppOMEMOSession var1);
    }

    public static interface CipherFactory {
        public Cipher cipherInstance(int var1, SecretKeySpec var2, byte[] var3) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException;
    }
}

