/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.omemo;

import java.util.ArrayList;
import java.util.List;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.PreKeyBundle;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementWrapper;
import tigase.jaxmpp.core.client.xml.XMLException;

public class Bundle
extends ElementWrapper {
    private final Integer deviceId;
    private final BareJID jid;

    public Bundle(BareJID jid, Integer deviceId, Element element) throws JaxmppException {
        super(element);
        this.jid = jid;
        this.deviceId = deviceId;
        if (!element.getName().equals("bundle") || !element.getXMLNS().equals("eu.siacs.conversations.axolotl")) {
            throw new JaxmppException("Invalid bundle!");
        }
    }

    public Integer getDeviceId() {
        return this.deviceId;
    }

    public BareJID getJid() {
        return this.jid;
    }

    public SignalProtocolAddress getAddress() {
        return new SignalProtocolAddress(this.jid.toString(), this.deviceId.intValue());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Bundle{");
        sb.append("deviceId='").append(this.deviceId).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public PreKeyBundle getPreKeyBundle() throws XMLException, InvalidKeyException {
        ECPublicKey signedPreKeyPublic = this.getSignedPreKeyPublic();
        Integer signedPreKeyId = this.getSignedPreKeyId();
        byte[] signedPreKeySignature = this.getSignedPreKeySignature();
        IdentityKey identityKey = this.getIdentityKey();
        return new PreKeyBundle(0, this.deviceId.intValue(), 0, null, signedPreKeyId.intValue(), signedPreKeyPublic, signedPreKeySignature, identityKey);
    }

    public List<PreKeyBundle> getPreKeys() throws XMLException, InvalidKeyException {
        ArrayList<PreKeyBundle> result = new ArrayList<PreKeyBundle>();
        Element prekeys = this.getFirstChild("prekeys");
        for (Element preKeyElement : prekeys.getChildren("preKeyPublic")) {
            Integer preKeyId = new Integer(preKeyElement.getAttribute("preKeyId"));
            ECPublicKey preKeyPublic = Curve.decodePoint((byte[])Base64.decode((String)preKeyElement.getValue()), (int)0);
            result.add(new PreKeyBundle(0, this.deviceId.intValue(), preKeyId.intValue(), preKeyPublic, 0, null, null, null));
        }
        return result;
    }

    private byte[] getSignedPreKeySignature() throws XMLException {
        Element tmp = this.getFirstChild("signedPreKeySignature");
        if (tmp != null) {
            return Base64.decode((String)tmp.getValue());
        }
        return null;
    }

    private IdentityKey getIdentityKey() throws XMLException, InvalidKeyException {
        Element identityKey = this.getFirstChild("identityKey");
        return new IdentityKey(Base64.decode((String)identityKey.getValue()), 0);
    }

    private Integer getSignedPreKeyId() throws XMLException {
        Element signedPreKeyPublic = this.getFirstChild("signedPreKeyPublic");
        return new Integer(signedPreKeyPublic.getAttribute("signedPreKeyId"));
    }

    private ECPublicKey getSignedPreKeyPublic() throws XMLException, InvalidKeyException {
        Element signedPreKeyPublic = this.getFirstChild("signedPreKeyPublic");
        return Curve.decodePoint((byte[])Base64.decode((String)signedPreKeyPublic.getValue()), (int)0);
    }
}

