/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.SessionBuilder;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.state.SignedPreKeyStore;
import org.whispersystems.libsignal.state.impl.InMemorySignalProtocolStore;
import org.whispersystems.libsignal.util.KeyHelper;
import tigase.jaxmpp.core.client.AsyncCallback;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.UIDGenerator;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.XmppModule;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.PingModule;
import tigase.jaxmpp.core.client.xmpp.modules.chat.Chat;
import tigase.jaxmpp.core.client.xmpp.modules.chat.MessageModule;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.Bundle;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.JaXMPPSignalProtocolStore;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.OmemoModule;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.XmppOMEMOSession;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.modules.pubsub.PubSubErrorCondition;
import tigase.jaxmpp.core.client.xmpp.modules.pubsub.PubSubModule;
import tigase.jaxmpp.core.client.xmpp.modules.roster.RosterModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.IQ;
import tigase.jaxmpp.core.client.xmpp.stanzas.Message;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;
import tigase.jaxmpp.core.client.xmpp.stanzas.StanzaType;
import tigase.jaxmpp.j2se.ConnectionConfiguration;
import tigase.jaxmpp.j2se.Jaxmpp;
import tigase.jaxmpp.j2se.Presence;

public class Client {
    public static String TALK_TO_JID = "+48508245952@quicksy.im";
    static HashMap<SignalProtocolAddress, SessionCipher> sessionCiphers = new HashMap();

    private static void createOMEMOSession(Jaxmpp jaxmpp, BareJID jid) throws JaxmppException {
        ((OmemoModule)jaxmpp.getModule(OmemoModule.class)).createOMEMOSession(jid, new OmemoModule.CreateOMEMOSessionHandler(){

            @Override
            public void onError() {
                System.out.println("!!! ERROR !!!!");
            }

            @Override
            public void onSessionCreated(XmppOMEMOSession session) {
                System.out.println("Session created: " + session);
            }
        });
    }

    private static void genKeys(Jaxmpp jaxmpp) throws Exception {
        IdentityKeyPair identityKeyPair = KeyHelper.generateIdentityKeyPair();
        int registrationId = KeyHelper.generateRegistrationId((boolean)true);
        List preKeys = KeyHelper.generatePreKeys((int)1, (int)100);
        SignedPreKeyRecord signedPreKey = KeyHelper.generateSignedPreKey((IdentityKeyPair)identityKeyPair, (int)1);
        Properties props = new Properties();
        props.setProperty("account", jaxmpp.getSessionObject().getUserBareJid().toString());
        props.setProperty("password", (String)jaxmpp.getSessionObject().getProperty("password"));
        props.setProperty("identityKeyPair", Base64.encode((byte[])identityKeyPair.serialize()));
        props.setProperty("registrationId", String.valueOf(registrationId));
        for (int i = 0; i < preKeys.size(); ++i) {
            props.setProperty("preKey." + ((PreKeyRecord)preKeys.get(i)).getId(), Base64.encode((byte[])((PreKeyRecord)preKeys.get(i)).serialize()));
        }
        props.setProperty("signedPreKey", Base64.encode((byte[])signedPreKey.serialize()));
        props.store(System.out, "OMEMO Client credentials");
    }

    private static void getKeys(Jaxmpp jaxmpp, BareJID jid) throws JaxmppException {
        ((OmemoModule)jaxmpp.getModule(OmemoModule.class)).getKeys(jid, null);
    }

    private static JaXMPPSignalProtocolStore loadMyKeys(Jaxmpp jaxmpp, Properties props) throws Exception {
        if (!props.containsKey("registrationId")) {
            return null;
        }
        System.out.println("Loading OMEMO keys...");
        IdentityKeyPair identityKeyPair = new IdentityKeyPair(Base64.decode((String)props.getProperty("identityKeyPair")));
        int registrationId = Integer.valueOf(props.getProperty("registrationId"));
        SignedPreKeyRecord signedPreKeyRecord = new SignedPreKeyRecord(Base64.decode((String)props.getProperty("signedPreKey")));
        ArrayList<PreKeyRecord> preKeys = new ArrayList<PreKeyRecord>();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String n = (String)names.nextElement();
            if (!n.startsWith("preKey.")) continue;
            preKeys.add(new PreKeyRecord(Base64.decode((String)props.getProperty(n))));
        }
        InMemeoryStore store = new InMemeoryStore(identityKeyPair, registrationId){

            public void storeSession(SignalProtocolAddress address, SessionRecord record) {
                System.out.println("!!!!! storeSession()");
                super.storeSession(address, record);
            }

            public boolean containsSession(SignalProtocolAddress address) {
                System.out.println("!!!!! containsSession(" + address + ")");
                return super.containsSession(address);
            }

            public SessionRecord loadSession(SignalProtocolAddress address) {
                System.out.println("!!!!! loadSession(" + address + ")");
                return super.loadSession(address);
            }

            public boolean isTrustedIdentity(SignalProtocolAddress address, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
                System.out.println("!!!!! isTrustedIdentity()");
                return super.isTrustedIdentity(address, identityKey, direction);
            }
        };
        preKeys.forEach(preKeyRecord -> store.storePreKey(preKeyRecord.getId(), (PreKeyRecord)preKeyRecord));
        store.storeSignedPreKey(signedPreKeyRecord.getId(), signedPreKeyRecord);
        System.out.println(signedPreKeyRecord.getId() + "      " + registrationId);
        return store;
    }

    public static void main(String[] args) throws Exception {
        Logger logger = Logger.getLogger("tigase.jaxmpp");
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        logger.addHandler(handler);
        logger.setLevel(Level.ALL);
        Jaxmpp jaxmpp = new Jaxmpp();
        jaxmpp.getSessionObject().setProperty(SessionObject.Scope.user, "COMPRESSION_DISABLED", (Object)Boolean.TRUE);
        Presence.initialize((Jaxmpp)jaxmpp);
        jaxmpp.getModulesManager().register((XmppModule)new PresenceModule());
        jaxmpp.getModulesManager().register((XmppModule)new RosterModule());
        jaxmpp.getModulesManager().register((XmppModule)new PubSubModule());
        jaxmpp.getModulesManager().register((XmppModule)new MessageModule());
        jaxmpp.getModulesManager().register((XmppModule)new OmemoModule());
        jaxmpp.getModulesManager().register((XmppModule)new PingModule());
        ((MessageModule)jaxmpp.getModule(MessageModule.class)).addExtension(((OmemoModule)jaxmpp.getModule(OmemoModule.class)).getExtension());
        Properties props = new Properties();
        try (FileReader reader = new FileReader(args[0]);){
            props.load(reader);
        }
        JaXMPPSignalProtocolStore store = Client.loadMyKeys(jaxmpp, props);
        System.out.println();
        System.out.println();
        System.out.println();
        ConnectionConfiguration configuration = jaxmpp.getConnectionConfiguration();
        configuration.setUserJID(props.getProperty("account"));
        configuration.setUserPassword(props.getProperty("password"));
        configuration.setResource("bot");
        OmemoModule.setSignalProtocolStore(jaxmpp.getSessionObject(), store);
        jaxmpp.getEventBus().addHandler(Connector.StanzaSendingHandler.StanzaSendingEvent.class, (EventHandler)((Connector.StanzaSendingHandler)(sessionObject, stanza) -> System.out.println("<< " + stanza.getAsString())));
        jaxmpp.getEventBus().addHandler(Connector.StanzaReceivedHandler.StanzaReceivedEvent.class, (EventHandler)((Connector.StanzaReceivedHandler)(sessionObject, stanza) -> {
            try {
                System.out.println(">> " + stanza.getAsString());
            }
            catch (XMLException e) {
                e.printStackTrace();
            }
        }));
        jaxmpp.getEventBus().addHandler(MessageModule.MessageReceivedHandler.MessageReceivedEvent.class, (EventHandler)((MessageModule.MessageReceivedHandler)(sessionObject, chat, stanza) -> {
            if (chat != null) {
                try {
                    if (stanza.getBody() != null) {
                        System.out.println("CHAT " + (chat != null ? chat.getJid() : "-") + " :: " + stanza.getBody());
                    }
                }
                catch (XMLException e) {
                    e.printStackTrace();
                }
            }
        }));
        jaxmpp.login(true);
        System.out.println("Connected=" + jaxmpp.isConnected());
        try (BufferedReader br = new BufferedReader(new InputStreamReader(System.in));){
            String line;
            while ((line = br.readLine()) != null) {
                String m;
                JID jid;
                Object p;
                if ("stop".equals(line.trim())) {
                    System.out.println("Stopping...");
                    break;
                }
                if (line.startsWith("ping")) {
                    p = line.split(" ");
                    jid = ((String[])p).length > 1 ? JID.jidInstance((String)p[1]) : null;
                    Client.ping(jaxmpp, jid);
                    continue;
                }
                if ("subscribe".equals(line.trim())) {
                    p = line.split(" ")[1];
                    ((PresenceModule)jaxmpp.getModule(PresenceModule.class)).subscribe(JID.jidInstance((String)p));
                    ((PresenceModule)jaxmpp.getModule(PresenceModule.class)).subscribed(JID.jidInstance((String)p));
                    continue;
                }
                if (line.startsWith("msg ")) {
                    Client.sendMessage(jaxmpp, line.substring(4).trim());
                    continue;
                }
                if (line.startsWith("omemo get ")) {
                    p = line.split(" ")[2];
                    System.out.println("Getting keys for " + (String)p);
                    Client.getKeys(jaxmpp, BareJID.bareJIDInstance((String)p));
                    continue;
                }
                if (line.startsWith("omemo msg ")) {
                    m = line.substring(10);
                    Client.sendMessage(jaxmpp, BareJID.bareJIDInstance((String)TALK_TO_JID), m);
                    continue;
                }
                if ("omemo gen".equals(line.trim())) {
                    System.out.println("Generating OMEMO keys");
                    Client.genKeys(jaxmpp);
                    continue;
                }
                if ("omemo publish".equals(line.trim())) {
                    System.out.println("Publishing own support");
                    Client.publishSupport(jaxmpp);
                    continue;
                }
                if (line.startsWith("omemo sub")) {
                    p = line.split(" ")[2];
                    System.out.println("Subscribing for device lists of " + (String)p);
                    Client.subscribeDeviceList(jaxmpp, (String)p);
                    continue;
                }
                if (line.startsWith("omemo session")) {
                    String[] prms = line.split(" ");
                    jid = prms.length == 3 ? BareJID.bareJIDInstance((String)prms[2]) : BareJID.bareJIDInstance((String)TALK_TO_JID);
                    Client.createOMEMOSession(jaxmpp, (BareJID)jid);
                    continue;
                }
                if (line.startsWith("chat ")) {
                    m = line.substring(5);
                    Client.sendChatMessage(jaxmpp, BareJID.bareJIDInstance((String)TALK_TO_JID), m);
                    continue;
                }
                if (line.equals("list")) {
                    ((PubSubModule)jaxmpp.getModule(PubSubModule.class)).retrieveSubscription(null, "eu.siacs.conversations.axolotl.devicelist", new PubSubModule.SubscriptionsRetrieveAsyncCallback(){

                        public void onTimeout() throws JaxmppException {
                            System.err.println("TIMEOUT");
                        }

                        protected void onRetrieve(IQ response, String node, Collection<PubSubModule.SubscriptionElement> subscriptions) {
                            for (PubSubModule.SubscriptionElement subscription : subscriptions) {
                                try {
                                    System.out.println("SUBSCRIPTION: " + subscription.getSubID());
                                }
                                catch (XMLException e) {
                                    e.printStackTrace();
                                }
                            }
                        }

                        protected void onEror(IQ response, XMPPException.ErrorCondition errorCondition, PubSubErrorCondition pubSubErrorCondition) throws JaxmppException {
                            System.err.println("ERR " + errorCondition + " " + pubSubErrorCondition);
                        }
                    });
                    continue;
                }
                if (!line.equals("unsub")) continue;
                Arrays.asList("eu.siacs.conversations.axolotl.devicelist", "eu.siacs.conversations.axolotl.bundles:1422845261", "eu.siacs.conversations.axolotl.bundles:428200763", "eu.siacs.conversations.axolotl.bundles:2136727595", "eu.siacs.conversations.axolotl.bundles:186505182", "eu.siacs.conversations.axolotl.bundles:186505182", "eu.siacs.conversations.axolotl.bundles:927740648", "eu.siacs.conversations.axolotl.bundles:927740648", "eu.siacs.conversations.axolotl.bundles:871751269", "eu.siacs.conversations.axolotl.devicelist", "eu.siacs.conversations.axolotl.bundles:1810744316", "eu.siacs.conversations.axolotl.bundles:675490094", "eu.siacs.conversations.axolotl.bundles:812230292").forEach(node -> {
                    try {
                        ((PubSubModule)jaxmpp.getModule(PubSubModule.class)).deleteNode(null, node, new AsyncCallback(){

                            public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                                System.out.println("error: " + error);
                            }

                            public void onSuccess(Stanza responseStanza) throws JaxmppException {
                                System.out.println("Unsubscribed");
                            }

                            public void onTimeout() throws JaxmppException {
                                System.out.println("TImeout");
                            }
                        });
                    }
                    catch (JaxmppException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        jaxmpp.disconnect(true);
        System.out.println(".");
    }

    private static void ping(Jaxmpp jaxmpp, JID jid) throws JaxmppException {
        ((PingModule)jaxmpp.getModule(PingModule.class)).ping(jid, new PingModule.PingAsyncCallback(){

            public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                System.out.println("PING ERROR: " + error);
            }

            public void onTimeout() throws JaxmppException {
                System.out.println("PING TIMEOUT");
            }

            protected void onPong(long time) {
                System.out.println("PONG: " + time + " ms");
            }
        });
    }

    private static void publishSupport(Jaxmpp jaxmpp) throws JaxmppException, InvalidKeyIdException {
        ((OmemoModule)jaxmpp.getModule(OmemoModule.class)).publishDeviceList();
    }

    private static void sendChatMessage(Jaxmpp jaxmpp, BareJID jid, String msg) throws JaxmppException {
        Chat chat;
        MessageModule messageModule = (MessageModule)jaxmpp.getModule(MessageModule.class);
        if (messageModule.getChatManager().isChatOpenFor(jid)) {
            System.out.println("OTWARTY");
            chat = messageModule.getChatManager().getChat(JID.jidInstance((BareJID)jid), null);
        } else {
            System.out.println("CREATE CHAT");
            chat = messageModule.createChat(JID.jidInstance((BareJID)jid));
        }
        if (chat == null) {
            System.out.println("WTF KURWA?");
        }
        messageModule.sendMessage(chat, msg);
    }

    private static void sendMessage(Jaxmpp jaxmpp, final BareJID jid, String msg) throws UntrustedIdentityException, JaxmppException {
        final SecureRandom rnd = new SecureRandom();
        final JaXMPPSignalProtocolStore store = OmemoModule.getSignalProtocolStore(jaxmpp.getSessionObject());
        ((OmemoModule)jaxmpp.getModule(OmemoModule.class)).getKeys(jid, new OmemoModule.KeysRetrieverHandler(){

            @Override
            public void onError() {
                System.err.println("JEBLO!");
            }

            @Override
            public void onSuccess(List<Bundle> bundles) {
                try {
                    for (Bundle b : bundles) {
                        PreKeyBundle bundle = b.getPreKeyBundle();
                        List<PreKeyBundle> preKeys = b.getPreKeys();
                        int deviceid = b.getDeviceId();
                        PreKeyBundle preKey = preKeys.get(rnd.nextInt(preKeys.size()));
                        SignalProtocolAddress address = new SignalProtocolAddress(jid.toString(), deviceid);
                        PreKeyBundle preKeyBundle = new PreKeyBundle(0, address.getDeviceId(), preKey.getPreKeyId(), preKey.getPreKey(), bundle.getSignedPreKeyId(), bundle.getSignedPreKey(), bundle.getSignedPreKeySignature(), bundle.getIdentityKey());
                        SessionBuilder sb = new SessionBuilder((SessionStore)store, (PreKeyStore)store, (SignedPreKeyStore)store, (IdentityKeyStore)store, address);
                        sb.process(preKeyBundle);
                        SessionCipher sessionCipher = new SessionCipher((SessionStore)store, (PreKeyStore)store, (SignedPreKeyStore)store, (IdentityKeyStore)store, address);
                        sessionCiphers.put(address, sessionCipher);
                        CiphertextMessage enc = sessionCipher.encrypt("To jest test!".getBytes());
                        System.out.println("! " + b.getDeviceId() + " > " + enc);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void sendMessage(Jaxmpp jaxmpp, String line) throws JaxmppException {
        int p = line.indexOf(" ");
        JID jid = JID.jidInstance((String)line.substring(0, p));
        String msg = line.substring(p + 1);
        Message m = Stanza.createMessage();
        m.setBody(msg);
        m.setTo(jid);
        m.setType(StanzaType.chat);
        m.setId(UIDGenerator.next());
        ((MessageModule)jaxmpp.getModule(MessageModule.class)).sendMessage(m);
    }

    private static void subscribeDeviceList(Jaxmpp jaxmpp, String p) throws JaxmppException {
        ((OmemoModule)jaxmpp.getModule(OmemoModule.class)).subscribeForDeviceList(BareJID.bareJIDInstance((String)p));
    }

    private static class InMemeoryStore
    extends InMemorySignalProtocolStore
    implements JaXMPPSignalProtocolStore {
        private final Map<BareJID, XmppOMEMOSession> sesssions = new ConcurrentHashMap<BareJID, XmppOMEMOSession>();
        private final Map<Integer, byte[]> store = new HashMap<Integer, byte[]>();

        public InMemeoryStore(IdentityKeyPair identityKeyPair, int registrationId) {
            super(identityKeyPair, registrationId);
        }

        @Override
        public XmppOMEMOSession getSession(BareJID jid) {
            return this.sesssions.get(jid);
        }

        @Override
        public void storeSession(XmppOMEMOSession session) {
            this.sesssions.put(session.getJid(), session);
        }

        @Override
        public void removeSession(XmppOMEMOSession session) {
            this.sesssions.remove(session.getJid());
        }

        @Override
        public boolean isOMEMORequired(BareJID jid) {
            return false;
        }

        @Override
        public void setOMEMORequired(BareJID jid, boolean required) {
        }

        public PreKeyRecord loadPreKey(int preKeyId) throws InvalidKeyIdException {
            try {
                if (!this.store.containsKey(preKeyId)) {
                    throw new InvalidKeyIdException("No such prekeyrecord!");
                }
                return new PreKeyRecord(this.store.get(preKeyId));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void storePreKey(int preKeyId, PreKeyRecord record) {
            this.store.put(preKeyId, record.serialize());
        }

        public boolean containsPreKey(int preKeyId) {
            return this.store.containsKey(preKeyId);
        }

        public void removePreKey(int preKeyId) {
            this.store.remove(preKeyId);
        }

        @Override
        public List<PreKeyRecord> loadPreKeys() {
            try {
                LinkedList<PreKeyRecord> results = new LinkedList<PreKeyRecord>();
                for (byte[] serialized : this.store.values()) {
                    results.add(new PreKeyRecord(serialized));
                }
                return results;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public List<Integer> getSubDevice(String name) {
            return null;
        }
    }
}

