/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.auth.scram;

import java.security.MessageDigest;
import java.security.cert.Certificate;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.xmpp.modules.auth.scram.AbstractScram;

public class ScramPlusMechanism
extends AbstractScram {
    public ScramPlusMechanism() {
        super("SCRAM-SHA-1-PLUS", "SHA1", "Client Key".getBytes(UTF_CHARSET), "Server Key".getBytes(UTF_CHARSET));
    }

    protected ScramPlusMechanism(String mechanismName, String algorithm, byte[] clientKey, byte[] serverKey) {
        super(mechanismName, algorithm, clientKey, serverKey);
    }

    private byte[] calculateHash(Certificate cert) {
        try {
            String algo = cert.getPublicKey().getAlgorithm();
            String usealgo = algo.equals("MD5") || algo.equals("SHA-1") ? "SHA-256" : algo;
            MessageDigest md = MessageDigest.getInstance(usealgo);
            byte[] der = cert.getEncoded();
            md.update(der);
            return md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot calculate certificate hash", e);
        }
    }

    @Override
    protected byte[] getBindData(AbstractScram.BindType bindType, SessionObject sessionObject) {
        switch (bindType) {
            case tls_unique: {
                return (byte[])sessionObject.getProperty("TLS_SESSION_ID_KEY");
            }
            case tls_server_end_point: {
                Certificate peerCertificate = (Certificate)sessionObject.getProperty("TLS_PEER_CERTIFICATE_KEY");
                return this.calculateHash(peerCertificate);
            }
        }
        return null;
    }

    @Override
    protected AbstractScram.BindType getBindType(SessionObject sessionObject) {
        if (sessionObject.getProperty("TLS_SESSION_ID_KEY") != null) {
            return AbstractScram.BindType.tls_unique;
        }
        if (sessionObject.getProperty("TLS_PEER_CERTIFICATE_KEY") != null) {
            return AbstractScram.BindType.tls_server_end_point;
        }
        return AbstractScram.BindType.n;
    }

    @Override
    public boolean isAllowedToUse(SessionObject sessionObject) {
        return (sessionObject.getProperty("TLS_SESSION_ID_KEY") != null || sessionObject.getProperty("TLS_PEER_CERTIFICATE_KEY") != null) && super.isAllowedToUse(sessionObject);
    }
}

