/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.filetransfer;

import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.capabilities.CapabilitiesCache;
import tigase.jaxmpp.core.client.xmpp.modules.capabilities.CapabilitiesModule;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionSession;
import tigase.jaxmpp.core.client.xmpp.modules.jingle.JingleModule;
import tigase.jaxmpp.core.client.xmpp.modules.jingle.Transport;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.Presence;
import tigase.jaxmpp.core.client.xmpp.utils.DateTimeFormat;
import tigase.jaxmpp.core.client.xmpp.utils.MutableBoolean;
import tigase.jaxmpp.j2se.connection.ConnectionManager;
import tigase.jaxmpp.j2se.connection.ConnectionSessionHandler;
import tigase.jaxmpp.j2se.connection.socks5bytestream.JingleSocks5BytestreamsConnectionManager;
import tigase.jaxmpp.j2se.filetransfer.FileTransfer;
import tigase.jaxmpp.j2se.filetransfer.FileTransferManager;
import tigase.jaxmpp.j2se.filetransfer.FileTransferNegotiatorAbstract;

public class JingleFileTransferNegotiator
extends FileTransferNegotiatorAbstract
implements ConnectionSessionHandler,
JingleModule.JingleSessionAcceptHandler,
JingleModule.JingleSessionInitiationHandler,
JingleModule.JingleSessionTerminateHandler,
ConnectionManager.ConnectionEstablishedHandler {
    private static DateTimeFormat dateTimeFormat = new DateTimeFormat();
    public static final String JINGLE_FT_XMLNS = "urn:xmpp:jingle:apps:file-transfer:3";
    private static final String[] FEATURES = new String[]{"urn:xmpp:jingle:apps:file-transfer:3", "urn:xmpp:jingle:transports:s5b:1"};
    private static final Logger log = Logger.getLogger(JingleFileTransferNegotiator.class.getCanonicalName());
    private static final long TIMEOUT = 300000L;
    private static final String TRANSPORTS_KEY = "transports-key";
    private final JingleSocks5BytestreamsConnectionManager connectionManager = new JingleSocks5BytestreamsConnectionManager(this);
    private Map<String, FileTransfer> sessions = Collections.synchronizedMap(new HashMap());
    private final Timer timer = new Timer();

    @Override
    public void acceptFile(JaxmppCore jaxmpp, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer ft) throws JaxmppException {
        final String sid = ft.getSid();
        this.sessions.put(sid, (FileTransfer)ft);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                JingleFileTransferNegotiator.this.sessions.remove(sid);
            }
        }, 300000L);
        JingleModule jingleModule = (JingleModule)jaxmpp.getModule(JingleModule.class);
        jingleModule.acceptSession(ft.getPeer(), sid, "ex", ElementFactory.create((String)"description", null, (String)JINGLE_FT_XMLNS), null);
        this.connectionManager.connectTcp(jaxmpp, (ConnectionSession)ft);
    }

    @Override
    public String[] getFeatures() {
        return FEATURES;
    }

    @Override
    public ConnectionSession getSession(String sid) {
        return (ConnectionSession)this.sessions.get(sid);
    }

    protected List<Transport> getTransports(JaxmppCore jaxmpp, FileTransfer ft) throws XMLException, JaxmppException {
        ArrayList<Transport> transports = (ArrayList<Transport>)ft.getData(TRANSPORTS_KEY);
        if (transports == null) {
            transports = new ArrayList<Transport>();
            Transport transport = this.connectionManager.getTransport(jaxmpp, (ConnectionSession)ft);
            if (transport != null) {
                transports.add(transport);
            }
            ft.setData(TRANSPORTS_KEY, transports);
        }
        return transports;
    }

    @Override
    public boolean isSupported(JaxmppCore jaxmpp, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer ft) {
        Presence p = PresenceModule.getPresenceStore((SessionObject)jaxmpp.getSessionObject()).getPresence(ft.getPeer());
        CapabilitiesModule capsModule = (CapabilitiesModule)jaxmpp.getModule(CapabilitiesModule.class);
        CapabilitiesCache capsCache = capsModule.getCache();
        try {
            String capsNode = FileTransferManager.getCapsNode(p);
            Set<String> features = capsCache != null ? capsCache.getFeatures(capsNode) : null;
            String featuresStr = "for " + ft.getPeer().toString() + " for caps = " + capsNode + " got = ";
            if (features != null) {
                for (String feature : features) {
                    featuresStr = featuresStr + "\n" + feature;
                }
            }
            return features != null && features.contains("urn:xmpp:jingle:1") && features.contains(JINGLE_FT_XMLNS) && features.contains("urn:xmpp:jingle:transports:s5b:1");
        }
        catch (XMLException ex) {
            return false;
        }
    }

    @Override
    public void onConnectionEstablished(SessionObject sessionObject, ConnectionSession connectionSession, Socket socket) throws JaxmppException {
        FileTransfer ft = (FileTransfer)connectionSession;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "got ft incoming = {0} with packet id = {1}", new Object[]{ft.isIncoming(), ft.getData("packet-id")});
        }
        if (socket != null) {
            this.fireOnSuccess(ft);
        }
    }

    public void onJingleSessionAccept(SessionObject sessionObject, JID sender, String sid, Element description, List<Transport> transports, MutableBoolean handled) {
        if (this.sessions.containsKey(sid)) {
            handled.setValue(true);
            log.log(Level.FINER, "jingle session accepted");
        }
    }

    public void onJingleSessionInitiation(SessionObject sessionObject, JID sender, String sid, Element desc, List<Transport> transports, MutableBoolean handled) {
        try {
            if (!JINGLE_FT_XMLNS.equals(desc.getXMLNS())) {
                return;
            }
            handled.setValue(true);
            Element file = null;
            List elems = desc.getChildren();
            block2: for (Element e : elems) {
                if (!"offer".equals(e.getName())) continue;
                for (Element f : e.getChildren()) {
                    if (!"file".equals(f.getName())) continue;
                    file = f;
                    break block2;
                }
            }
            if (file == null) {
                log.log(Level.WARNING, "received file request but without file description = " + desc.getAsString());
                return;
            }
            String name = null;
            Long filesize = null;
            String mimetype = null;
            Date lastModified = null;
            for (Element child : file.getChildren()) {
                String elName = child.getName();
                if ("name".equals(elName)) {
                    name = child.getValue();
                    continue;
                }
                if (!"size".equals(elName)) continue;
                filesize = Long.parseLong(child.getValue());
            }
            FileTransfer ft = new FileTransfer(sessionObject, sender, sid);
            ft.setFileInfo(name, filesize, lastModified, mimetype);
            ft.setData(TRANSPORTS_KEY, transports);
            this.fireOnRequest(sessionObject, ft);
        }
        catch (JaxmppException ex) {
            log.log(Level.SEVERE, "Exception during processing JingleSessionInitiation", ex);
            handled.setValue(false);
        }
    }

    public void onJingleSessionTerminate(SessionObject sessionObject, JID sender, String sid, MutableBoolean handled) {
        FileTransfer ft = this.sessions.get(sid);
        if (ft == null) {
            return;
        }
        handled.setValue(true);
        if (ft.getTransferredBytes() > 0L) {
            log.log(Level.FINE, "transfer finished");
        } else {
            this.fireOnFailure(ft, null);
        }
    }

    @Override
    public void registerListeners(JaxmppCore jaxmpp) {
        jaxmpp.getEventBus().addHandler(JingleModule.JingleSessionInitiationHandler.JingleSessionInitiationEvent.class, (EventHandler)this);
        jaxmpp.getEventBus().addHandler(JingleModule.JingleSessionAcceptHandler.JingleSessionAcceptEvent.class, (EventHandler)this);
        jaxmpp.getEventBus().addHandler(JingleModule.JingleSessionTerminateHandler.JingleSessionTerminateEvent.class, (EventHandler)this);
    }

    @Override
    public void rejectFile(JaxmppCore jaxmpp, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer ft) throws JaxmppException {
        JingleModule jingleModule = (JingleModule)jaxmpp.getModule(JingleModule.class);
        this.sessions.remove(ft.getSid());
        jingleModule.terminateSession(ft.getPeer(), ft.getSid(), ft.getPeer());
    }

    @Override
    public void sendFile(JaxmppCore jaxmpp, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer ft) throws JaxmppException {
        JingleModule jingleModule = (JingleModule)jaxmpp.getModule(JingleModule.class);
        final String sid = ft.getSid();
        Element description = ElementFactory.create((String)"description");
        description.setXMLNS(JINGLE_FT_XMLNS);
        Element offer = ElementFactory.create((String)"offer");
        description.addChild(offer);
        this.connectionManager.initConnection(jaxmpp, (ConnectionSession)ft, null);
        Element file = ElementFactory.create((String)"file");
        file.addChild(ElementFactory.create((String)"name", (String)file.getName(), null));
        file.addChild(ElementFactory.create((String)"size", (String)String.valueOf(ft.getFileSize()), null));
        if (ft.getFileModification() != null) {
            file.addChild(ElementFactory.create((String)"date", (String)dateTimeFormat.format(ft.getFileModification()), null));
        }
        offer.addChild(file);
        List<Transport> transports = this.getTransports(jaxmpp, (FileTransfer)ft);
        this.sessions.put(sid, (FileTransfer)ft);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                JingleFileTransferNegotiator.this.sessions.remove(sid);
            }
        }, 300000L);
        jingleModule.initiateSession(ft.getPeer(), sid, "ex", description, transports);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.connectionManager.setContext(context);
        context.getEventBus().addHandler(ConnectionManager.ConnectionEstablishedHandler.ConnectionEstablishedEvent.class, (Object)this.connectionManager, (EventHandler)this);
    }

    @Override
    public void unregisterListeners(JaxmppCore jaxmpp) {
        jaxmpp.getEventBus().remove(JingleModule.JingleSessionInitiationHandler.JingleSessionInitiationEvent.class, (EventHandler)this);
        jaxmpp.getEventBus().remove(JingleModule.JingleSessionAcceptHandler.JingleSessionAcceptEvent.class, (EventHandler)this);
        jaxmpp.getEventBus().remove(JingleModule.JingleSessionTerminateHandler.JingleSessionTerminateEvent.class, (EventHandler)this);
    }
}

