/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connection.socks5bytestream;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.AsyncCallback;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xmpp.modules.ResourceBinderModule;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionEndpoint;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionSession;
import tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.Socks5BytestreamsModule;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.Streamhost;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.StreamhostUsedCallback;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.StreamhostsCallback;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;
import tigase.jaxmpp.j2se.connection.ConnectionManager;
import tigase.jaxmpp.j2se.connection.socks5bytestream.Socks5ConnectionManager;

public class Socks5BytestreamsConnectionManager
extends Socks5ConnectionManager {
    private static final Logger log = Logger.getLogger(Socks5BytestreamsConnectionManager.class.getCanonicalName());

    @Override
    public void connectTcp(JaxmppCore jaxmpp, ConnectionSession session) throws JaxmppException {
        session.setData("jaxmpp", (Object)jaxmpp);
        JID proxyJid = (JID)session.getData("proxy-jid");
        if (proxyJid != null) {
            this.requestStreamHosts(jaxmpp, session, proxyJid);
        } else {
            this.sendStreamHosts(jaxmpp, session, null);
        }
    }

    @Override
    public void connectUdp(JaxmppCore jaxmpp, ConnectionSession session) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initConnection(JaxmppCore jaxmpp, ConnectionSession session, ConnectionManager.InitializedCallback callback) throws JaxmppException {
        session.setData("jaxmpp", (Object)jaxmpp);
        this.discoverProxy(jaxmpp, session, callback);
    }

    public void register(final JaxmppCore jaxmpp, final ConnectionSession session) {
        session.setData("jaxmpp", (Object)jaxmpp);
        Socks5BytestreamsModule socks5Module = (Socks5BytestreamsModule)jaxmpp.getModule(Socks5BytestreamsModule.class);
        Socks5BytestreamsModule.StreamhostsHandler handler = new Socks5BytestreamsModule.StreamhostsHandler(){

            public void onStreamhostsHandler(SessionObject sessionObject, JID from, String id, String sid, List<Streamhost> hosts) throws JaxmppException {
                session.setData("packet-id", (Object)id);
                if (session.getSid().equals(sid)) {
                    jaxmpp.getEventBus().remove((EventHandler)this);
                    for (Streamhost host : hosts) {
                        try {
                            Socks5BytestreamsConnectionManager.this.connectToProxy(jaxmpp, session, session.getSid(), (ConnectionEndpoint)host);
                            break;
                        }
                        catch (IOException iOException) {
                        }
                    }
                }
            }
        };
        jaxmpp.getEventBus().addHandler(Socks5BytestreamsModule.StreamhostsHandler.StreamhostsEvent.class, (EventHandler)handler);
    }

    protected void requestStreamHosts(final JaxmppCore jaxmpp, final ConnectionSession session, JID proxyJid) throws JaxmppException {
        Socks5BytestreamsModule socks5Module = (Socks5BytestreamsModule)jaxmpp.getModule(Socks5BytestreamsModule.class);
        socks5Module.requestStreamhosts(proxyJid, new StreamhostsCallback(socks5Module){

            public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                Socks5BytestreamsConnectionManager.this.sendStreamHosts(jaxmpp, session, null);
            }

            public void onStreamhosts(List<Streamhost> hosts) throws JaxmppException {
                Socks5BytestreamsConnectionManager.this.sendStreamHosts(jaxmpp, session, hosts);
            }

            public void onTimeout() throws JaxmppException {
                Socks5BytestreamsConnectionManager.this.sendStreamHosts(jaxmpp, session, null);
            }
        });
    }

    protected void sendStreamHosts(final JaxmppCore jaxmpp, final ConnectionSession ft, List<Streamhost> proxyStreamhosts) throws JaxmppException {
        Socks5BytestreamsModule socks5Module = (Socks5BytestreamsModule)jaxmpp.getModule(Socks5BytestreamsModule.class);
        List<Streamhost> streamhosts = this.getLocalStreamHosts(ft, ft.getSid());
        if (proxyStreamhosts != null) {
            streamhosts.addAll(proxyStreamhosts);
        }
        StreamhostUsedCallback streamhostUsedCallback = new StreamhostUsedCallback(){

            public void onError(Exception ex, String errorText) {
                log.log(Level.SEVERE, errorText, ex);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onSuccess(Streamhost host) {
                System.out.println("streamhost-used = " + host.getJid());
                if (host.getJid().equals((Object)ResourceBinderModule.getBindedJID((SessionObject)ft.getSessionObject()))) {
                    System.out.println("streamhost-used = 'local'");
                    ConnectionSession connectionSession = ft;
                    synchronized (connectionSession) {
                        Socks5BytestreamsConnectionManager.this.fireOnConnected(ft);
                    }
                }
                try {
                    Socks5BytestreamsConnectionManager.this.connectToProxy(jaxmpp, ft, ft.getSid(), (ConnectionEndpoint)host);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "exception while connecting to proxy", ex);
                    return false;
                }
                return true;
            }
        };
        streamhostUsedCallback.setHosts(streamhosts);
        socks5Module.sendStreamhosts(ft.getPeer(), ft.getSid(), streamhosts, (AsyncCallback)streamhostUsedCallback);
    }

    public void sendStreamhostUsed(FileTransfer ft, String packetId) throws JaxmppException {
        JaxmppCore jaxmpp = (JaxmppCore)ft.getData("jaxmpp");
        Streamhost streamhost = (Streamhost)ft.getData("streamhost");
        ((Socks5BytestreamsModule)jaxmpp.getModule(Socks5BytestreamsModule.class)).sendStreamhostUsed(ft.getPeer(), packetId, ft.getSid(), streamhost);
    }
}

