/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.StreamFeaturesModule;
import tigase.jaxmpp.core.client.xmpp.modules.registration.InBandRegistrationModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.IQ;
import tigase.jaxmpp.j2se.connectors.socket.SocketConnector;

public class SocketInBandRegistrationXmppSessionLogic
implements XmppSessionLogic {
    private final SocketConnector connector;
    private final Context context;
    private StreamFeaturesModule featuresModule;
    private final XmppModulesManager modulesManager;
    private InBandRegistrationModule.NotSupportedErrorHandler notSupportedErrorHandler;
    private InBandRegistrationModule.ReceivedErrorHandler receivedErrorHandler;
    private InBandRegistrationModule.ReceivedTimeoutHandler receivedTimeoutHandler;
    private InBandRegistrationModule registrationModule;
    private XmppSessionLogic.SessionListener sessionListener;
    private final StreamFeaturesModule.StreamFeaturesReceivedHandler streamFeaturesEventHandler;

    public SocketInBandRegistrationXmppSessionLogic(SocketConnector connector, XmppModulesManager modulesManager, Context context) {
        this.connector = connector;
        this.modulesManager = modulesManager;
        this.context = context;
        this.streamFeaturesEventHandler = new StreamFeaturesModule.StreamFeaturesReceivedHandler(){

            public void onStreamFeaturesReceived(SessionObject sessionObject, Element featuresElement) throws JaxmppException {
                SocketInBandRegistrationXmppSessionLogic.this.processStreamFeatures(sessionObject, featuresElement);
            }
        };
        this.receivedErrorHandler = new InBandRegistrationModule.ReceivedErrorHandler(){

            public void onReceivedError(SessionObject sessionObject, IQ responseStanza, XMPPException.ErrorCondition errorCondition) throws JaxmppException {
                SocketInBandRegistrationXmppSessionLogic.this.connector.stop();
            }
        };
        this.receivedTimeoutHandler = new InBandRegistrationModule.ReceivedTimeoutHandler(){

            public void onReceivedTimeout(SessionObject sessionObject) throws JaxmppException {
                SocketInBandRegistrationXmppSessionLogic.this.connector.stop();
            }
        };
        this.notSupportedErrorHandler = new InBandRegistrationModule.NotSupportedErrorHandler(){

            public void onNotSupportedError(SessionObject sessionObject) throws JaxmppException {
                SocketInBandRegistrationXmppSessionLogic.this.connector.stop();
            }
        };
    }

    public void beforeStart() throws JaxmppException {
    }

    protected void processException(JaxmppException e) throws JaxmppException {
        if (this.sessionListener != null) {
            this.sessionListener.onException(e);
        }
    }

    protected void processStreamFeatures(SessionObject sessionObject, Element featuresElement) throws JaxmppException {
        try {
            Boolean tlsDisabled = (Boolean)sessionObject.getProperty("TLS_DISABLED");
            boolean tlsAvailable = SocketConnector.isTLSAvailable(sessionObject);
            boolean isConnectionSecure = this.connector.isSecure();
            if (!(isConnectionSecure || !tlsAvailable || tlsDisabled != null && tlsDisabled.booleanValue())) {
                this.connector.startTLS();
            } else {
                this.registrationModule.start();
            }
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
    }

    public void setSessionListener(XmppSessionLogic.SessionListener sessionListener) throws JaxmppException {
        this.sessionListener = sessionListener;
        this.featuresModule = (StreamFeaturesModule)this.modulesManager.getModule(StreamFeaturesModule.class);
        this.registrationModule = (InBandRegistrationModule)this.modulesManager.getModule(InBandRegistrationModule.class);
        this.registrationModule.addNotSupportedErrorHandler(this.notSupportedErrorHandler);
        this.registrationModule.addReceivedErrorHandler(this.receivedErrorHandler);
        this.registrationModule.addReceivedTimeoutHandler(this.receivedTimeoutHandler);
        this.featuresModule.addStreamFeaturesReceivedHandler(this.streamFeaturesEventHandler);
    }

    public void unbind() throws JaxmppException {
        this.featuresModule.removeStreamFeaturesReceivedHandler(this.streamFeaturesEventHandler);
        this.registrationModule.removeNotSupportedErrorHandler(this.notSupportedErrorHandler);
        this.registrationModule.removeReceivedErrorHandler(this.receivedErrorHandler);
        this.registrationModule.removeReceivedTimeoutHandler(this.receivedTimeoutHandler);
    }
}

