/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public class DefaultHostnameVerifier
implements HostnameVerifier {
    private static final String IPv4_IPv6_PATTERN = "^(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))|([0-9a-fA-F:]{2,}(:([0-9]{1,3}\\.){3}[0-9]{1,3})?))$";
    protected final Logger log = Logger.getLogger(this.getClass().getName());

    protected static String extractCN(X500Principal principal) {
        String[] dd;
        for (String string : dd = principal.getName("RFC2253").split(",")) {
            if (!string.toLowerCase().startsWith("cn=")) continue;
            return string.substring(3);
        }
        return null;
    }

    protected boolean match(String hostname, String altName) {
        int dotIdx;
        if (hostname == null || hostname.isEmpty() || altName == null || altName.isEmpty()) {
            return false;
        }
        String normalizedAltName = altName.toLowerCase(Locale.US);
        if (!normalizedAltName.contains("*")) {
            return hostname.equals(normalizedAltName);
        }
        if (normalizedAltName.startsWith("*.") && hostname.regionMatches(0, normalizedAltName, 2, normalizedAltName.length() - 2)) {
            return true;
        }
        int asteriskIdx = normalizedAltName.indexOf(42);
        if (asteriskIdx > (dotIdx = normalizedAltName.indexOf(46))) {
            return false;
        }
        if (!hostname.regionMatches(0, normalizedAltName, 0, asteriskIdx)) {
            return false;
        }
        int suffixLength = normalizedAltName.length() - (asteriskIdx + 1);
        int suffixStart = hostname.length() - suffixLength;
        if (hostname.indexOf(46, asteriskIdx) < suffixStart) {
            return false;
        }
        return hostname.regionMatches(suffixStart, normalizedAltName, asteriskIdx + 1, suffixLength);
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        try {
            Certificate[] certificates = session.getPeerCertificates();
            if (hostname.matches(IPv4_IPv6_PATTERN)) {
                return this.verifyIp(hostname, (X509Certificate)certificates[0]);
            }
            return this.verifyHostname(hostname, (X509Certificate)certificates[0]);
        }
        catch (Exception e) {
            this.log.log(Level.FINE, "Can't validate hostname", e);
            return false;
        }
    }

    protected boolean verifyHostname(String hostname, X509Certificate x509Certificate) throws CertificateParsingException {
        X500Principal principal;
        String cn;
        boolean altNamePresents = false;
        for (List<?> entry : x509Certificate.getSubjectAlternativeNames()) {
            Integer altNameType = (Integer)entry.get(0);
            if (altNameType != 2) continue;
            altNamePresents = true;
            String altName = (String)entry.get(1);
            if (!this.match(hostname, altName)) continue;
            return true;
        }
        if (!altNamePresents && (cn = DefaultHostnameVerifier.extractCN(principal = x509Certificate.getSubjectX500Principal())) != null) {
            return this.match(hostname, cn);
        }
        return false;
    }

    protected boolean verifyIp(String ipAddr, X509Certificate x509Certificate) throws CertificateParsingException {
        for (List<?> entry : x509Certificate.getSubjectAlternativeNames()) {
            String altName;
            Integer altNameType = (Integer)entry.get(0);
            if (altNameType != 7 || !ipAddr.equalsIgnoreCase(altName = (String)entry.get(1))) continue;
            return true;
        }
        return false;
    }
}

