/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.PacketWriter;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.connector.StreamError;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.factory.UniversalFactory;
import tigase.jaxmpp.core.client.observer.BaseEvent;
import tigase.jaxmpp.core.client.observer.EventType;
import tigase.jaxmpp.core.client.observer.Listener;
import tigase.jaxmpp.core.client.observer.Observable;
import tigase.jaxmpp.core.client.observer.ObservableFactory;
import tigase.jaxmpp.core.client.xml.DefaultElement;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.j2se.DNSResolver;
import tigase.jaxmpp.j2se.connectors.socket.SocketInBandRegistrationXmppSessionLogic;
import tigase.jaxmpp.j2se.connectors.socket.SocketXmppSessionLogic;
import tigase.jaxmpp.j2se.connectors.socket.StreamListener;
import tigase.jaxmpp.j2se.connectors.socket.XMPPDomBuilderHandler;
import tigase.jaxmpp.j2se.xml.J2seElement;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class SocketConnector
implements Connector {
    public static final EventType HostChanged = new EventType();
    private static final String RECONNECTING_KEY = "s:reconnecting";
    public static final String SERVER_HOST = "socket#ServerHost";
    public static final String SERVER_PORT = "socket#ServerPort";
    public static final String SSL_SOCKET_FACTORY_KEY = "socket#SSLSocketFactory";
    public static final String TLS_DISABLED_KEY = "TLS_DISABLED";
    private final TrustManager dummyTrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    private final Logger log;
    protected Observable observable;
    private TimerTask pingTask;
    private boolean preventAgainstFireErrors = false;
    private Reader reader;
    private SessionObject sessionObject;
    private Socket socket;
    private int SOCKET_TIMEOUT = 180000;
    private Timer timer;
    private Worker worker;
    private OutputStream writer;

    public static boolean isTLSAvailable(SessionObject sessionObject) throws XMLException {
        tigase.jaxmpp.core.client.xml.Element sf = sessionObject.getStreamFeatures();
        if (sf == null) {
            return false;
        }
        tigase.jaxmpp.core.client.xml.Element m = sf.getChildrenNS("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
        return m != null;
    }

    public SocketConnector(Observable parentObservable, SessionObject sessionObject2) {
        this.observable = ObservableFactory.instance((Observable)parentObservable);
        this.log = Logger.getLogger(this.getClass().getName());
        this.sessionObject = sessionObject2;
    }

    public void addListener(EventType eventType, Listener<? extends Connector.ConnectorEvent> listener) {
        this.observable.addListener(eventType, listener);
    }

    public void addListener(Listener<? extends BaseEvent> listener) {
        this.observable.addListener(listener);
    }

    public XmppSessionLogic createSessionLogic(XmppModulesManager modulesManager, PacketWriter writer) {
        if (this.sessionObject.getProperty("IN_BAND_REGISTRATION_MODE_KEY") == Boolean.TRUE) {
            this.log.info("Using XEP-0077 mode!!!!");
            return new SocketInBandRegistrationXmppSessionLogic(this, modulesManager, this.sessionObject, writer);
        }
        return new SocketXmppSessionLogic(this, modulesManager, this.sessionObject, writer);
    }

    protected void fireOnConnected(SessionObject sessionObject) throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        SocketConnectorEvent event = new SocketConnectorEvent(Connected, sessionObject);
        this.observable.fireEvent(event.getType(), (BaseEvent)event);
    }

    protected void fireOnError(tigase.jaxmpp.core.client.xml.Element response, Throwable caught, SessionObject sessionObject) throws JaxmppException {
        List es;
        SocketConnectorEvent event = new SocketConnectorEvent(Error, sessionObject);
        event.setStanza(response);
        event.setCaught(caught);
        if (response != null && (es = response.getChildrenNS("urn:ietf:params:xml:ns:xmpp-streams")) != null) {
            for (tigase.jaxmpp.core.client.xml.Element element : es) {
                String n = element.getName();
                StreamError err = StreamError.getByElementName((String)n);
                event.setStreamError(err);
                event.setStreamErrorElement(element);
            }
        }
        this.observable.fireEvent(event.getType(), (BaseEvent)event);
    }

    protected void fireOnStanzaReceived(tigase.jaxmpp.core.client.xml.Element response, SessionObject sessionObject) throws JaxmppException {
        SocketConnectorEvent event = new SocketConnectorEvent(StanzaReceived, sessionObject);
        event.setStanza(response);
        this.observable.fireEvent(event.getType(), (BaseEvent)event);
    }

    protected void fireOnTerminate(SessionObject sessionObject) throws JaxmppException {
        SocketConnectorEvent event = new SocketConnectorEvent(StreamTerminated, sessionObject);
        this.observable.fireEvent(event.getType(), (BaseEvent)event);
    }

    private Entry getHostFromSessionObject() {
        String serverHost = (String)this.sessionObject.getProperty(SERVER_HOST);
        Integer port = (Integer)this.sessionObject.getProperty(SERVER_PORT);
        if (serverHost == null) {
            return null;
        }
        return new Entry(serverHost, port == null ? 5222 : port);
    }

    public Observable getObservable() {
        return this.observable;
    }

    public Connector.State getState() {
        Connector.State st = (Connector.State)this.sessionObject.getProperty("CONNECTOR#STAGE_KEY");
        return st == null ? Connector.State.disconnected : st;
    }

    public boolean isSecure() {
        return (Boolean)this.sessionObject.getProperty("CONNECTOR#ENCRYPTED_KEY") == Boolean.TRUE;
    }

    public void keepalive() throws JaxmppException {
        if (this.sessionObject.getProperty("CONNECTOR#DISABLEKEEPALIVE") == Boolean.TRUE) {
            return;
        }
        if (this.getState() == Connector.State.connected) {
            this.send(new byte[]{32});
        }
    }

    protected void onError(tigase.jaxmpp.core.client.xml.Element response, Throwable caught) throws JaxmppException {
        tigase.jaxmpp.core.client.xml.Element seeOtherHost;
        if (response != null && (seeOtherHost = response.getChildrenNS("see-other-host", "urn:ietf:params:xml:ns:xmpp-streams")) != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Received see-other-host=" + seeOtherHost.getValue());
            }
            this.preventAgainstFireErrors = true;
            this.reconnect(seeOtherHost.getValue());
            return;
        }
        this.stop();
        this.fireOnError(response, caught, this.sessionObject);
    }

    protected void onErrorInThread(Exception e) throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.stop();
        this.fireOnError(null, e, this.sessionObject);
    }

    protected void onResponse(tigase.jaxmpp.core.client.xml.Element response) throws JaxmppException {
        if ("error".equals(response.getName()) && response.getXMLNS() != null && response.getXMLNS().equals("http://etherx.jabber.org/streams")) {
            this.onError(response, null);
        } else {
            this.fireOnStanzaReceived(response, this.sessionObject);
        }
    }

    protected void onStreamStart(Map<String, String> attribs) {
    }

    protected void onStreamTerminate() throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.setStage(Connector.State.disconnected);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Stream terminated");
        }
        this.terminateAllWorkers();
        this.fireOnTerminate(this.sessionObject);
    }

    public void onTLSStanza(Element elem) throws JaxmppException {
        if (elem.getName().equals("proceed")) {
            this.proceedTLS();
        } else if (elem.getName().equals("failure")) {
            this.log.info("TLS Failure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedTLS() throws JaxmppException {
        this.log.fine("Proceeding TLS");
        try {
            SSLSocketFactory factory;
            this.sessionObject.setProperty("CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.TRUE);
            TrustManager[] trustManagers = (TrustManager[])this.sessionObject.getProperty("TRUST_MANAGERS_KEY");
            if (trustManagers == null) {
                factory = this.sessionObject.getProperty(SSL_SOCKET_FACTORY_KEY) != null ? (SSLSocketFactory)this.sessionObject.getProperty(SSL_SOCKET_FACTORY_KEY) : (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], trustManagers, new SecureRandom());
                factory = ctx.getSocketFactory();
            }
            SSLSocket s1 = (SSLSocket)factory.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
            s1.setSoTimeout(0);
            s1.setKeepAlive(false);
            s1.setTcpNoDelay(true);
            s1.setUseClientMode(true);
            s1.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent arg0) {
                    SocketConnector.this.log.info("TLS completed " + arg0);
                    SocketConnector.this.sessionObject.setProperty("CONNECTOR#ENCRYPTED_KEY", (Object)Boolean.TRUE);
                    SocketConnectorEvent event = new SocketConnectorEvent(Connector.EncryptionEstablished, SocketConnector.this.sessionObject);
                    try {
                        SocketConnector.this.observable.fireEvent(Connector.EncryptionEstablished, (BaseEvent)event);
                    }
                    catch (JaxmppException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.writer = null;
            this.reader = null;
            this.log.fine("Start handshake");
            s1.startHandshake();
            this.socket = s1;
            this.writer = this.socket.getOutputStream();
            this.reader = new InputStreamReader(this.socket.getInputStream());
            this.restartStream();
        }
        catch (SSLHandshakeException e) {
            this.log.log(Level.SEVERE, "Can't establish encrypted connection", e);
            this.onError(null, e);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Can't establish encrypted connection", e);
            this.onError(null, e);
        }
        finally {
            this.sessionObject.setProperty("CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
        }
    }

    public void processElement(Element elem) throws JaxmppException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("RECV: " + elem.toString());
        }
        if (elem != null && elem.getXMLNS() != null && elem.getXMLNS().equals("urn:ietf:params:xml:ns:xmpp-tls")) {
            this.onTLSStanza(elem);
        } else {
            try {
                this.onResponse(new J2seElement(elem));
            }
            catch (JaxmppException e) {
                this.onErrorInThread((Exception)((Object)e));
            }
        }
    }

    private void reconnect(String newHost) {
        this.log.info("See other host: " + newHost);
        try {
            this.terminateAllWorkers();
            Object x1 = this.sessionObject.getProperty("jaxmpp#synchronized");
            this.sessionObject.clear();
            this.sessionObject.setProperty(SERVER_HOST, (Object)newHost);
            this.worker = null;
            this.reader = null;
            this.writer = null;
            this.sessionObject.setProperty(RECONNECTING_KEY, (Object)Boolean.TRUE);
            this.sessionObject.setProperty("jaxmpp#synchronized", x1);
            this.log.finest("Waiting for workers termination");
        }
        catch (JaxmppException e) {
            e.printStackTrace();
        }
    }

    public void removeAllListeners() {
        this.observable.removeAllListeners();
    }

    public void removeListener(EventType eventType, Listener<Connector.ConnectorEvent> listener) {
        this.observable.removeListener(eventType, listener);
    }

    public void restartStream() throws XMLException, JaxmppException {
        String to;
        StringBuilder sb = new StringBuilder();
        sb.append("<stream:stream ");
        BareJID from = (BareJID)this.sessionObject.getProperty("userBareJid");
        Boolean seeOtherHost = (Boolean)this.sessionObject.getProperty("BOSH#SEE_OTHER_HOST_KEY");
        if (from != null && (seeOtherHost == null || seeOtherHost.booleanValue())) {
            to = from.getDomain();
            sb.append("from='").append(from.toString()).append("' ");
        } else {
            to = (String)this.sessionObject.getProperty("domainName");
        }
        if (to != null) {
            sb.append("to='").append(to).append("' ");
        }
        sb.append("xmlns='jabber:client' ");
        sb.append("xmlns:stream='http://etherx.jabber.org/streams' ");
        sb.append("version='1.0'>");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Restarting XMPP Stream");
        }
        this.send(sb.toString().getBytes());
    }

    public void send(byte[] buffer) throws JaxmppException {
        if (this.writer != null) {
            try {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Send: " + new String(buffer));
                }
                this.writer.write(buffer);
            }
            catch (IOException e) {
                throw new JaxmppException((Throwable)e);
            }
        }
    }

    public void send(tigase.jaxmpp.core.client.xml.Element stanza) throws XMLException, JaxmppException {
        if (this.writer != null) {
            try {
                String t = stanza.getAsString();
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Send: " + t);
                }
                try {
                    SocketConnectorEvent event = new SocketConnectorEvent(StanzaSending, this.sessionObject);
                    event.setStanza(stanza);
                    this.observable.fireEvent((BaseEvent)event);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.writer.write(t.getBytes());
            }
            catch (IOException e) {
                this.stop(true);
                throw new JaxmppException((Throwable)e);
            }
        }
    }

    public void setObservable(Observable observable) {
        this.observable = observable == null ? ObservableFactory.instance(null) : observable;
    }

    protected void setStage(Connector.State state) throws JaxmppException {
        Connector.State s = (Connector.State)this.sessionObject.getProperty("CONNECTOR#STAGE_KEY");
        this.sessionObject.setProperty("CONNECTOR#STAGE_KEY", (Object)state);
        if (s != state) {
            this.log.fine("Connector state changed: " + s + "->" + state);
            SocketConnectorEvent e = new SocketConnectorEvent(StateChanged, this.sessionObject);
            this.observable.fireEvent((BaseEvent)e);
            if (!this.preventAgainstFireErrors && state == Connector.State.disconnected) {
                this.fireOnTerminate(this.sessionObject);
            }
        }
    }

    public void start() throws XMLException, JaxmppException {
        this.preventAgainstFireErrors = false;
        this.log.fine("Start connector.");
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.timer = new Timer(true);
        if (this.sessionObject.getProperty("TRUST_MANAGERS_KEY") == null) {
            this.sessionObject.setProperty("TRUST_MANAGERS_KEY", (Object)new TrustManager[]{this.dummyTrustManager});
        }
        this.setStage(Connector.State.connecting);
        try {
            Object x;
            Entry serverHost = this.getHostFromSessionObject();
            if (serverHost == null) {
                x = (String)this.sessionObject.getProperty("domainName");
                this.log.info("Resolving SRV recrd of domain '" + (String)x + "'");
                DnsResolver dnsResolver = (DnsResolver)UniversalFactory.createInstance((String)DnsResolver.class.getName());
                List<Entry> xx = dnsResolver != null ? dnsResolver.resolve((String)x) : DNSResolver.resolve((String)x);
                if (xx.size() > 0) {
                    serverHost = xx.get(0);
                }
            }
            this.sessionObject.setProperty("CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Preparing connection to " + serverHost);
            }
            x = InetAddress.getByName(serverHost.getHostname());
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Starting socket " + x + ":" + serverHost.getPort());
            }
            this.socket = new Socket((InetAddress)x, (int)serverHost.getPort());
            this.socket.setSoTimeout(this.SOCKET_TIMEOUT);
            this.socket.setKeepAlive(false);
            this.socket.setTcpNoDelay(true);
            this.writer = this.socket.getOutputStream();
            this.reader = new InputStreamReader(this.socket.getInputStream());
            this.worker = new Worker(this);
            this.log.finest("Starting worker...");
            this.worker.start();
            this.restartStream();
            this.setStage(Connector.State.connected);
            this.pingTask = new TimerTask(){

                @Override
                public void run() {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                SocketConnector.this.keepalive();
                            }
                            catch (JaxmppException e) {
                                SocketConnector.this.log.log(Level.SEVERE, "Can't ping!", e);
                            }
                        }
                    }.start();
                }
            };
            long delay = this.SOCKET_TIMEOUT - 5000;
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Whitespace ping period is setted to " + delay + "ms");
            }
            if (this.sessionObject.getProperty("CONNECTOR#EXTERNAL_KEEPALIVE_KEY") == null || !((Boolean)this.sessionObject.getProperty("CONNECTOR#EXTERNAL_KEEPALIVE_KEY")).booleanValue()) {
                this.timer.schedule(this.pingTask, delay, delay);
            }
            this.fireOnConnected(this.sessionObject);
        }
        catch (Exception e) {
            this.stop();
            this.onError(null, e);
            throw new JaxmppException((Throwable)e);
        }
    }

    public void startTLS() throws JaxmppException {
        if (this.writer != null) {
            try {
                this.log.fine("Start TLS");
                DefaultElement e = new DefaultElement("starttls", null, "urn:ietf:params:xml:ns:xmpp-tls");
                this.send(e.getAsString().getBytes());
            }
            catch (Exception e) {
                throw new JaxmppException((Throwable)e);
            }
        }
    }

    public void stop() throws JaxmppException {
        this.stop(false);
    }

    public void stop(boolean terminate) throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.setStage(Connector.State.disconnecting);
        if (!terminate) {
            this.terminateStream();
        }
        this.terminateAllWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateAllWorkers() throws JaxmppException {
        this.log.finest("Terminating all workers");
        if (this.pingTask != null) {
            this.pingTask.cancel();
            this.pingTask = null;
        }
        this.setStage(Connector.State.disconnected);
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            this.log.log(Level.FINEST, "Problem with closing socket", e);
        }
        try {
            if (this.worker != null) {
                this.worker.interrupt();
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Problem with interrupting w2", e);
        }
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Problem with canceling timer", e);
        }
        finally {
            this.timer = null;
        }
    }

    private void terminateStream() throws JaxmppException {
        Connector.State state = this.getState();
        if (state == Connector.State.connected || state == Connector.State.connecting) {
            String x = "</stream:stream>";
            this.log.fine("Terminating XMPP Stream");
            this.send(x.getBytes());
        } else {
            this.log.fine("Stream terminate not sent, because of connection state==" + state);
        }
    }

    private void workerTerminated(Worker worker) {
        try {
            this.setStage(Connector.State.disconnected);
        }
        catch (JaxmppException e) {
            // empty catch block
        }
        this.log.finest("Worker terminated");
        try {
            if (this.sessionObject.getProperty(RECONNECTING_KEY) == Boolean.TRUE) {
                this.sessionObject.setProperty(RECONNECTING_KEY, null);
                SocketConnectorEvent event = new SocketConnectorEvent(HostChanged, this.sessionObject);
                this.observable.fireEvent(HostChanged, (BaseEvent)event);
                this.log.finest("Restarting...");
                this.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Worker
    extends Thread {
        private final char[] buffer = new char[10240];
        private SocketConnector connector;
        private final XMPPDomBuilderHandler domHandler = new XMPPDomBuilderHandler(new StreamListener(){

            @Override
            public void nextElement(Element element) {
                try {
                    SocketConnector.this.processElement(element);
                }
                catch (JaxmppException e) {
                    SocketConnector.this.log.log(Level.SEVERE, "Error on processing element", e);
                }
            }

            @Override
            public void xmppStreamClosed() {
                try {
                    if (SocketConnector.this.log.isLoggable(Level.FINEST)) {
                        SocketConnector.this.log.finest("xmppStreamClosed()");
                    }
                    SocketConnector.this.onStreamTerminate();
                }
                catch (JaxmppException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void xmppStreamOpened(Map<String, String> attribs) {
                if (SocketConnector.this.log.isLoggable(Level.FINEST)) {
                    SocketConnector.this.log.finest("xmppStreamOpened()");
                }
                SocketConnector.this.onStreamStart(attribs);
            }
        });
        private final SimpleParser parser = SingletonFactory.getParserInstance();

        public Worker(SocketConnector connector) {
            this.connector = connector;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            SocketConnector.this.log.fine("Worker Interrupted");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            SocketConnector.this.log.finest(this.hashCode() + " Starting " + this);
            int r = -2;
            try {
                while (this.connector.reader != null && !this.isInterrupted() && (r = this.connector.reader.read(this.buffer)) != -1 && this.connector.getState() != Connector.State.disconnected) {
                    this.parser.parse((SimpleHandler)this.domHandler, this.buffer, 0, r);
                }
                SocketConnector.this.log.finest(this.hashCode() + "Disconnecting: state=" + this.connector.getState() + "; buffer=" + r + "   " + this);
                if (!this.isInterrupted()) {
                    this.connector.onStreamTerminate();
                }
            }
            catch (Exception e) {
                if (SocketConnector.this.getState() != Connector.State.disconnecting && SocketConnector.this.getState() != Connector.State.disconnected) {
                    SocketConnector.this.log.log(Level.WARNING, "Exception in worker", e);
                    try {
                        SocketConnector.this.onErrorInThread(e);
                    }
                    catch (JaxmppException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                this.interrupt();
                SocketConnector.this.log.finest("Worker2 is interrupted");
                this.connector.workerTerminated(this);
            }
        }
    }

    public static class SocketConnectorEvent
    extends Connector.ConnectorEvent {
        private static final long serialVersionUID = 1L;

        public SocketConnectorEvent(EventType type, SessionObject sessionObject) {
            super(type, sessionObject);
        }
    }

    public static final class Entry {
        private final String hostname;
        private final Integer port;

        public Entry(String host, Integer port) {
            this.hostname = host;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Integer getPort() {
            return this.port;
        }

        public String toString() {
            return this.hostname + ":" + this.port;
        }
    }

    public static interface DnsResolver {
        public List<Entry> resolve(String var1);
    }
}

