/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.bosh;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.util.Queue;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.connector.BoshRequest;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.j2se.xml.J2seElement;
import tigase.xml.DomBuilderHandler;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;

public abstract class BoshWorker
implements BoshRequest {
    private final Element body;
    private HttpURLConnection conn;
    private final DomBuilderHandler domHandler;
    private final SimpleParser parser;
    private final String rid;
    private final SessionObject sessionObject;
    private boolean terminated = false;

    public BoshWorker(DomBuilderHandler domHandler, SimpleParser parser, SessionObject sessionObject, Element body) throws XMLException, JaxmppException {
        this.domHandler = domHandler;
        this.parser = parser;
        this.sessionObject = sessionObject;
        this.body = body;
        this.rid = body.getAttribute("rid");
        if (this.rid == null) {
            throw new RuntimeException("rid must be defined");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BoshWorker)) {
            return false;
        }
        return ((BoshWorker)obj).rid.equals(this.rid);
    }

    public String getRid() {
        return this.rid;
    }

    public int hashCode() {
        return this.rid.hashCode();
    }

    protected abstract void onError(int var1, String var2, Element var3, Throwable var4) throws JaxmppException;

    protected abstract void onSuccess(int var1, String var2, Element var3) throws JaxmppException;

    protected abstract void onTerminate(int var1, String var2, Element var3) throws JaxmppException;

    public void run() {
        if (this.terminated) {
            return;
        }
        try {
            try {
                tigase.xml.Element elem;
                String line;
                URL url = (URL)this.sessionObject.getProperty("bosh#url");
                this.conn = (HttpURLConnection)url.openConnection();
                String b = this.body.getAsString();
                if (!this.conn.getDoOutput()) {
                    this.conn.setDoOutput(true);
                }
                OutputStreamWriter wr = new OutputStreamWriter(this.conn.getOutputStream());
                wr.write(b);
                wr.flush();
                int responseCode = this.conn.getResponseCode();
                StringBuilder sb = new StringBuilder();
                BufferedReader rd = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                String responseData = sb.toString();
                if (responseCode != 200) {
                    this.onError(responseCode, responseData, null, null);
                    return;
                }
                this.parser.parse((SimpleHandler)this.domHandler, responseData.toCharArray(), 0, responseData.length());
                Queue elems = this.domHandler.getParsedElements();
                while ((elem = (tigase.xml.Element)elems.poll()) != null) {
                    String type = elem.getAttribute("type");
                    J2seElement response = new J2seElement(elem);
                    if (type != null && "terminate".equals(type)) {
                        this.onTerminate(responseCode, responseData, response);
                        continue;
                    }
                    if (type != null && "error".equals(type)) {
                        this.onError(responseCode, responseData, response, null);
                        continue;
                    }
                    if (type == null) {
                        this.onSuccess(responseCode, responseData, response);
                        continue;
                    }
                    throw new RuntimeException("Unknown response type '" + type + "'");
                }
            }
            catch (SocketException e) {
                if (this.terminated) {
                    return;
                }
                this.onError(0, null, null, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.onError(0, null, null, e);
            }
        }
        catch (JaxmppException e1) {
            e1.printStackTrace();
        }
    }

    public void terminate() {
        this.terminated = true;
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    public String toString() {
        return "rid=" + this.rid;
    }
}

