/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.capabilities;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.PacketWriter;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.XmppModule;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.criteria.Criteria;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.observer.Listener;
import tigase.jaxmpp.core.client.xml.DefaultElement;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.capabilities.CapabilitiesCache;
import tigase.jaxmpp.core.client.xmpp.modules.disco.DiscoInfoModule;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.Presence;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;

public class CapabilitiesModule
implements XmppModule {
    private static final String ALGORITHM = "SHA-1";
    public static final String NODE_NAME_KEY = "NODE_NAME_KEY";
    public static final String VERIFICATION_STRING_KEY = "XEP115VerificationString";
    private CapabilitiesCache cache;
    private final DiscoInfoModule discoInfoModule;
    private final XmppModulesManager modulesManager;
    private final PresenceModule presenceModule;
    private final SessionObject sessionObject;
    private final PacketWriter writer;

    public static String generateVerificationString(String[] identities, String[] features) {
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            String[] stringArray = identities;
            int n = identities.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                md.update(id.getBytes());
                md.update((byte)60);
                ++n2;
            }
            Arrays.sort(features);
            stringArray = features;
            n = features.length;
            n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                md.update(f.getBytes());
                md.update((byte)60);
                ++n2;
            }
            byte[] digest = md.digest();
            return Base64.encode((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CapabilitiesModule(SessionObject sessionObject, PacketWriter writer, DiscoInfoModule discoInfoModule, PresenceModule presenceModule, XmppModulesManager modulesManager) {
        this.sessionObject = sessionObject;
        this.writer = writer;
        this.discoInfoModule = discoInfoModule;
        this.presenceModule = presenceModule;
        this.presenceModule.addListener(PresenceModule.BeforePresenceSend, (Listener)new Listener<PresenceModule.PresenceEvent>(){

            public void handleEvent(PresenceModule.PresenceEvent be) throws JaxmppException {
                CapabilitiesModule.this.onBeforePresenceSend(be);
            }
        });
        Listener<PresenceModule.PresenceEvent> presenceListener = new Listener<PresenceModule.PresenceEvent>(){

            public void handleEvent(PresenceModule.PresenceEvent be) throws JaxmppException {
                CapabilitiesModule.this.onReceivedPresence(be);
            }
        };
        this.presenceModule.addListener(PresenceModule.ContactAvailable, (Listener)presenceListener);
        this.presenceModule.addListener(PresenceModule.ContactChangedPresence, (Listener)presenceListener);
        this.discoInfoModule.addListener((Listener)new Listener<DiscoInfoModule.DiscoInfoEvent>(){

            public void handleEvent(DiscoInfoModule.DiscoInfoEvent be) {
                CapabilitiesModule.this.onDiscoInfoModuleRequest(be);
            }
        });
        this.modulesManager = modulesManager;
    }

    private String calculateVerificationString() {
        String category = (String)this.sessionObject.getProperty("IDENTITY_CATEGORY_KEY");
        String type = (String)this.sessionObject.getProperty("IDENTITY_TYPE_KEY");
        String nme = (String)this.sessionObject.getProperty("SOFTWARE_VERSION#NAME_KEY");
        String v = (String)this.sessionObject.getProperty("SOFTWARE_VERSION#VERSION_KEY");
        String identity = String.valueOf(category) + "/" + type + "//" + nme + " " + v;
        String ver = CapabilitiesModule.generateVerificationString(new String[]{identity}, this.modulesManager.getAvailableFeatures().toArray(new String[0]));
        this.sessionObject.setProperty(VERIFICATION_STRING_KEY, (Object)ver);
        return ver;
    }

    public CapabilitiesCache getCache() {
        return this.cache;
    }

    public Criteria getCriteria() {
        return null;
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/caps"};
    }

    protected String getNodeName() {
        String s = (String)this.sessionObject.getProperty(NODE_NAME_KEY);
        return s == null ? "http://tigase.org" : s;
    }

    protected boolean isEnabled() {
        return true;
    }

    protected void onBeforePresenceSend(PresenceModule.PresenceEvent be) throws XMLException {
        if (!this.isEnabled()) {
            return;
        }
        String ver = (String)this.sessionObject.getProperty(VERIFICATION_STRING_KEY);
        if (ver == null) {
            ver = this.calculateVerificationString();
        }
        if (ver == null) {
            return;
        }
        Presence p = be.getPresence();
        if (p != null) {
            DefaultElement c = new DefaultElement("c", null, "http://jabber.org/protocol/caps");
            c.setAttribute("hash", "sha-1");
            c.setAttribute("node", this.getNodeName());
            c.setAttribute("ver", ver);
            p.addChild((Element)c);
        }
    }

    protected void onDiscoInfoModuleRequest(DiscoInfoModule.DiscoInfoEvent be) {
        if (be.getNode() == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        String ver = (String)this.sessionObject.getProperty(VERIFICATION_STRING_KEY);
        if (ver == null) {
            ver = this.calculateVerificationString();
        }
        if (ver == null) {
            return;
        }
        if (!be.getNode().equals(String.valueOf(this.getNodeName()) + '#' + ver)) {
            return;
        }
        this.discoInfoModule.processDefaultDiscoEvent(be);
    }

    protected void onReceivedPresence(PresenceModule.PresenceEvent be) throws JaxmppException {
        if (this.cache == null) {
            return;
        }
        Presence presence = be.getPresence();
        if (presence == null) {
            return;
        }
        Element c = presence.getChildrenNS("c", "http://jabber.org/protocol/caps");
        if (c == null) {
            return;
        }
        String node = c.getAttribute("node");
        String ver = c.getAttribute("ver");
        if (node == null || ver == null) {
            return;
        }
        if (this.cache.isCached(String.valueOf(node) + "#" + ver)) {
            return;
        }
        this.discoInfoModule.getInfo(presence.getFrom(), String.valueOf(node) + "#" + ver, new DiscoInfoModule.DiscoInfoAsyncCallback(String.valueOf(node) + "#" + ver){

            public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                System.out.println("Error: " + error);
            }

            protected void onInfoReceived(String node, Collection<DiscoInfoModule.Identity> identities, Collection<String> features) throws XMLException {
                String name = "?";
                String category = "?";
                String type = "?";
                if (identities != null && identities.size() > 0) {
                    DiscoInfoModule.Identity identity = identities.iterator().next();
                    name = identity.getName();
                    category = identity.getCategory();
                    type = identity.getType();
                }
                if (CapabilitiesModule.this.cache != null) {
                    CapabilitiesModule.this.cache.store(node, name, category, type, features);
                }
            }

            public void onTimeout() throws JaxmppException {
                System.out.println("Timeout");
            }
        });
    }

    public void process(Element element) throws XMPPException, XMLException, JaxmppException {
    }

    public void setCache(CapabilitiesCache cache) {
        this.cache = cache;
    }
}

