/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.PacketWriter;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.observer.Listener;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.ResourceBinderModule;
import tigase.jaxmpp.core.client.xmpp.modules.SessionEstablishmentModule;
import tigase.jaxmpp.core.client.xmpp.modules.StreamFeaturesModule;
import tigase.jaxmpp.core.client.xmpp.modules.auth.AuthModule;
import tigase.jaxmpp.core.client.xmpp.modules.auth.NonSaslAuthModule;
import tigase.jaxmpp.core.client.xmpp.modules.auth.SaslModule;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.modules.roster.RosterModule;
import tigase.jaxmpp.j2se.connectors.socket.SocketConnector;

public class SocketXmppSessionLogic
implements XmppSessionLogic {
    private AuthModule authModule;
    private final SocketConnector connector;
    private StreamFeaturesModule featuresModule;
    private final XmppModulesManager modulesManager;
    private ResourceBinderModule resourceBinder;
    private Listener<ResourceBinderModule.ResourceBindEvent> resourceBindListener;
    private final Listener<AuthModule.AuthEvent> saslEventListener;
    private Listener<SessionEstablishmentModule.SessionEstablishmentEvent> sessionEstablishmentListener;
    private SessionEstablishmentModule sessionEstablishmentModule;
    private XmppSessionLogic.SessionListener sessionListener;
    private final SessionObject sessionObject;
    private final Listener<StreamFeaturesModule.StreamFeaturesReceivedEvent> streamFeaturesEventListener;

    public SocketXmppSessionLogic(SocketConnector connector, XmppModulesManager modulesManager, SessionObject sessionObject, PacketWriter writer) {
        this.connector = connector;
        this.modulesManager = modulesManager;
        this.sessionObject = sessionObject;
        this.streamFeaturesEventListener = new Listener<StreamFeaturesModule.StreamFeaturesReceivedEvent>(){

            public void handleEvent(StreamFeaturesModule.StreamFeaturesReceivedEvent be) throws JaxmppException {
                try {
                    SocketXmppSessionLogic.this.processStreamFeatures(be);
                }
                catch (JaxmppException e) {
                    SocketXmppSessionLogic.this.processException(e);
                }
            }
        };
        this.saslEventListener = new Listener<AuthModule.AuthEvent>(){

            public void handleEvent(AuthModule.AuthEvent be) throws JaxmppException {
                try {
                    if (be instanceof SaslModule.SaslEvent) {
                        SocketXmppSessionLogic.this.processSaslEvent((SaslModule.SaslEvent)be);
                    } else if (be instanceof NonSaslAuthModule.NonSaslAuthEvent) {
                        SocketXmppSessionLogic.this.processNonSaslEvent((NonSaslAuthModule.NonSaslAuthEvent)be);
                    }
                }
                catch (JaxmppException e) {
                    SocketXmppSessionLogic.this.processException(e);
                }
            }
        };
        this.resourceBindListener = new Listener<ResourceBinderModule.ResourceBindEvent>(){

            public void handleEvent(ResourceBinderModule.ResourceBindEvent be) throws JaxmppException {
                try {
                    SocketXmppSessionLogic.this.processResourceBindEvent(be);
                }
                catch (JaxmppException e) {
                    SocketXmppSessionLogic.this.processException(e);
                }
            }
        };
        this.sessionEstablishmentListener = new Listener<SessionEstablishmentModule.SessionEstablishmentEvent>(){

            public void handleEvent(SessionEstablishmentModule.SessionEstablishmentEvent be) throws JaxmppException {
                SocketXmppSessionLogic.this.sessionBindedAndEstablished();
            }
        };
    }

    public void beforeStart() throws JaxmppException {
        if (this.sessionObject.getProperty("domainName") == null && this.sessionObject.getProperty("userBareJid") == null) {
            throw new JaxmppException("No user JID or server name specified");
        }
        if (this.sessionObject.getProperty("domainName") == null) {
            this.sessionObject.setProperty("domainName", (Object)((BareJID)this.sessionObject.getProperty("userBareJid")).getDomain());
        }
    }

    protected void processException(JaxmppException e) throws JaxmppException {
        if (this.sessionListener != null) {
            this.sessionListener.onException(e);
        }
    }

    protected void processNonSaslEvent(NonSaslAuthModule.NonSaslAuthEvent be) throws JaxmppException {
        if (be.getType() == AuthModule.AuthFailed) {
            throw new JaxmppException("Unauthorized with condition=" + be.getError());
        }
        if (be.getType() == AuthModule.AuthSuccess) {
            this.connector.restartStream();
        }
    }

    protected void processResourceBindEvent(ResourceBinderModule.ResourceBindEvent be) throws JaxmppException {
        if (SessionEstablishmentModule.isSessionEstablishingAvailable((SessionObject)this.sessionObject)) {
            ((SessionEstablishmentModule)this.modulesManager.getModule(SessionEstablishmentModule.class)).establish();
        } else {
            this.sessionBindedAndEstablished();
        }
    }

    protected void processSaslEvent(SaslModule.SaslEvent be) throws JaxmppException {
        if (be.getType() == AuthModule.AuthFailed) {
            throw new JaxmppException("Unauthorized with condition=" + be.getError());
        }
        if (be.getType() == AuthModule.AuthSuccess) {
            this.connector.restartStream();
        }
    }

    protected void processStreamFeatures(StreamFeaturesModule.StreamFeaturesReceivedEvent be) throws JaxmppException {
        try {
            Boolean tlsDisabled = (Boolean)this.sessionObject.getProperty("TLS_DISABLED");
            boolean authAvailable = AuthModule.isAuthAvailable((SessionObject)this.sessionObject);
            boolean tlsAvailable = SocketConnector.isTLSAvailable(this.sessionObject);
            boolean isAuthorized = this.sessionObject.getProperty("jaxmpp#authorized") == Boolean.TRUE;
            boolean isConnectionSecure = this.connector.isSecure();
            if (!(isConnectionSecure || !tlsAvailable || tlsDisabled != null && tlsDisabled.booleanValue())) {
                this.connector.startTLS();
            } else if (!isAuthorized && authAvailable) {
                this.authModule.login();
            } else if (isAuthorized) {
                this.resourceBinder.bind();
            }
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
    }

    private void sessionBindedAndEstablished() throws JaxmppException {
        try {
            PresenceModule presence;
            RosterModule roster = (RosterModule)this.modulesManager.getModule(RosterModule.class);
            if (roster != null) {
                roster.rosterRequest();
            }
            if ((presence = (PresenceModule)this.modulesManager.getModule(PresenceModule.class)) != null) {
                presence.sendInitialPresence();
            }
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
    }

    public void setSessionListener(XmppSessionLogic.SessionListener sessionListener) throws JaxmppException {
        this.sessionListener = sessionListener;
        this.featuresModule = (StreamFeaturesModule)this.modulesManager.getModule(StreamFeaturesModule.class);
        this.authModule = (AuthModule)this.modulesManager.getModule(AuthModule.class);
        this.resourceBinder = (ResourceBinderModule)this.modulesManager.getModule(ResourceBinderModule.class);
        this.sessionEstablishmentModule = (SessionEstablishmentModule)this.modulesManager.getModule(SessionEstablishmentModule.class);
        this.featuresModule.addListener(StreamFeaturesModule.StreamFeaturesReceived, this.streamFeaturesEventListener);
        this.authModule.addListener(AuthModule.AuthSuccess, this.saslEventListener);
        this.authModule.addListener(AuthModule.AuthFailed, this.saslEventListener);
        this.resourceBinder.addListener(ResourceBinderModule.ResourceBindSuccess, this.resourceBindListener);
        this.sessionEstablishmentModule.addListener(SessionEstablishmentModule.SessionEstablishmentSuccess, this.sessionEstablishmentListener);
        this.sessionEstablishmentModule.addListener(SessionEstablishmentModule.SessionEstablishmentError, this.sessionEstablishmentListener);
    }

    public void unbind() throws JaxmppException {
        this.featuresModule.removeListener(StreamFeaturesModule.StreamFeaturesReceived, this.streamFeaturesEventListener);
        this.authModule.removeListener(AuthModule.AuthSuccess, this.saslEventListener);
        this.authModule.removeListener(AuthModule.AuthFailed, this.saslEventListener);
        this.resourceBinder.removeListener(ResourceBinderModule.ResourceBindSuccess, this.resourceBindListener);
        this.sessionEstablishmentModule.removeListener(SessionEstablishmentModule.SessionEstablishmentSuccess, this.sessionEstablishmentListener);
        this.sessionEstablishmentModule.removeListener(SessionEstablishmentModule.SessionEstablishmentError, this.sessionEstablishmentListener);
    }
}

