/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import tigase.jaxmpp.core.client.PacketWriter;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.observer.BaseEvent;
import tigase.jaxmpp.core.client.observer.Listener;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.StreamFeaturesModule;
import tigase.jaxmpp.core.client.xmpp.modules.registration.InBandRegistrationModule;
import tigase.jaxmpp.j2se.connectors.socket.SocketConnector;

public class SocketInBandRegistrationXmppSessionLogic
implements XmppSessionLogic {
    private final SocketConnector connector;
    private StreamFeaturesModule featuresModule;
    private final XmppModulesManager modulesManager;
    private final Listener<BaseEvent> registrationListener;
    private InBandRegistrationModule registrationModule;
    private XmppSessionLogic.SessionListener sessionListener;
    private final SessionObject sessionObject;
    private final Listener<StreamFeaturesModule.StreamFeaturesReceivedEvent> streamFeaturesEventListener;

    public SocketInBandRegistrationXmppSessionLogic(SocketConnector connector, XmppModulesManager modulesManager, SessionObject sessionObject, PacketWriter writer) {
        this.connector = connector;
        this.modulesManager = modulesManager;
        this.sessionObject = sessionObject;
        this.streamFeaturesEventListener = new Listener<StreamFeaturesModule.StreamFeaturesReceivedEvent>(){

            public void handleEvent(StreamFeaturesModule.StreamFeaturesReceivedEvent be) throws JaxmppException {
                try {
                    SocketInBandRegistrationXmppSessionLogic.this.processStreamFeatures(be);
                }
                catch (JaxmppException e) {
                    SocketInBandRegistrationXmppSessionLogic.this.processException(e);
                }
            }
        };
        this.registrationListener = new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) throws JaxmppException {
                if (be.getType() == InBandRegistrationModule.ReceivedError) {
                    SocketInBandRegistrationXmppSessionLogic.this.connector.stop();
                } else if (be.getType() == InBandRegistrationModule.ReceivedTimeout) {
                    SocketInBandRegistrationXmppSessionLogic.this.connector.stop();
                } else if (be.getType() == InBandRegistrationModule.NotSupportedError) {
                    SocketInBandRegistrationXmppSessionLogic.this.connector.stop();
                }
            }
        };
    }

    public void beforeStart() throws JaxmppException {
    }

    protected void processException(JaxmppException e) throws JaxmppException {
        if (this.sessionListener != null) {
            this.sessionListener.onException(e);
        }
    }

    protected void processStreamFeatures(StreamFeaturesModule.StreamFeaturesReceivedEvent be) throws JaxmppException {
        System.out.println(be.getFeatures().getAsString());
        try {
            Boolean tlsDisabled = (Boolean)this.sessionObject.getProperty("TLS_DISABLED");
            boolean tlsAvailable = SocketConnector.isTLSAvailable(this.sessionObject);
            boolean isConnectionSecure = this.connector.isSecure();
            if (!(isConnectionSecure || !tlsAvailable || tlsDisabled != null && tlsDisabled.booleanValue())) {
                this.connector.startTLS();
            } else {
                this.registrationModule.start();
            }
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
    }

    public void setSessionListener(XmppSessionLogic.SessionListener sessionListener) throws JaxmppException {
        this.sessionListener = sessionListener;
        this.featuresModule = (StreamFeaturesModule)this.modulesManager.getModule(StreamFeaturesModule.class);
        this.registrationModule = (InBandRegistrationModule)this.modulesManager.getModule(InBandRegistrationModule.class);
        this.featuresModule.addListener(StreamFeaturesModule.StreamFeaturesReceived, this.streamFeaturesEventListener);
        this.registrationModule.addListener(this.registrationListener);
    }

    public void unbind() throws JaxmppException {
        this.featuresModule.removeListener(StreamFeaturesModule.StreamFeaturesReceived, this.streamFeaturesEventListener);
        this.registrationModule.removeListener(this.registrationListener);
    }
}

