/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.observer;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.observer.BaseEvent;
import tigase.jaxmpp.core.client.observer.EventType;
import tigase.jaxmpp.core.client.observer.Listener;
import tigase.jaxmpp.core.client.observer.Observable;

public class ThreadSafeObservable
implements Observable {
    private final CopyOnWriteArrayList<Listener<? extends BaseEvent>> everythingListener = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<EventType, CopyOnWriteArrayList<Listener<? extends BaseEvent>>> listeners = new ConcurrentHashMap();
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final Observable parent;

    public ThreadSafeObservable() {
        this(null);
    }

    public ThreadSafeObservable(Observable parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EventType eventType, Listener<? extends BaseEvent> listener) {
        ConcurrentHashMap<EventType, CopyOnWriteArrayList<Listener<? extends BaseEvent>>> concurrentHashMap = this.listeners;
        synchronized (concurrentHashMap) {
            CopyOnWriteArrayList<Object> lst = this.listeners.get(eventType);
            if (lst == null) {
                lst = new CopyOnWriteArrayList();
                this.listeners.put(eventType, lst);
            }
            lst.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener<? extends BaseEvent> listener) {
        CopyOnWriteArrayList<Listener<? extends BaseEvent>> copyOnWriteArrayList = this.everythingListener;
        synchronized (copyOnWriteArrayList) {
            this.everythingListener.add(listener);
        }
    }

    public void fireEvent(BaseEvent event) throws JaxmppException {
        this.fireEvent(event.getType(), event);
    }

    public void fireEvent(EventType eventType, BaseEvent event) throws JaxmppException {
        try {
            List lst = this.listeners.get(eventType);
            if (lst != null) {
                event.setHandled(true);
                for (Listener listener : lst) {
                    listener.handleEvent(event);
                }
            }
            if (!this.everythingListener.isEmpty()) {
                event.setHandled(true);
                for (Listener listener : this.everythingListener) {
                    listener.handleEvent(event);
                }
            }
        }
        catch (JaxmppException e) {
            this.log.log(Level.WARNING, "Problem on calling observers", e);
            throw e;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on calling observers", e);
            throw new JaxmppException((Throwable)e);
        }
        if (this.parent != null) {
            this.parent.fireEvent(eventType, event);
        }
    }

    public void fireEvent(EventType eventType, SessionObject sessionObject) throws JaxmppException {
        this.fireEvent(eventType, new BaseEvent(eventType, sessionObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Serializable serializable = this.everythingListener;
        synchronized (serializable) {
            this.everythingListener.clear();
        }
        serializable = this.listeners;
        synchronized (serializable) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EventType eventType, Listener<? extends BaseEvent> listener) {
        ConcurrentHashMap<EventType, CopyOnWriteArrayList<Listener<? extends BaseEvent>>> concurrentHashMap = this.listeners;
        synchronized (concurrentHashMap) {
            List lst = this.listeners.get(eventType);
            if (lst != null) {
                lst.remove(listener);
                if (lst.isEmpty()) {
                    this.listeners.remove(eventType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener<? extends BaseEvent> listener) {
        CopyOnWriteArrayList<Listener<? extends BaseEvent>> copyOnWriteArrayList = this.everythingListener;
        synchronized (copyOnWriteArrayList) {
            this.everythingListener.remove(listener);
        }
    }
}

