/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.Processor;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppModule;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.observer.BaseEvent;
import tigase.jaxmpp.core.client.observer.Observable;
import tigase.jaxmpp.core.client.observer.ObservableFactory;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.ResourceBinderModule;
import tigase.jaxmpp.core.client.xmpp.modules.capabilities.CapabilitiesModule;
import tigase.jaxmpp.core.client.xmpp.modules.disco.DiscoInfoModule;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.utils.DateTimeFormat;
import tigase.jaxmpp.j2se.ConnectionConfiguration;
import tigase.jaxmpp.j2se.DateTimeFormatProviderImpl;
import tigase.jaxmpp.j2se.J2SESessionObject;
import tigase.jaxmpp.j2se.connectors.bosh.BoshConnector;
import tigase.jaxmpp.j2se.connectors.socket.SocketConnector;
import tigase.jaxmpp.j2se.observer.ThreadSafeObservable;

public class Jaxmpp
extends JaxmppCore {
    public static final String CONNECTOR_TYPE = "connectorType";
    private static final Executor DEFAULT_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            new Thread(command).start();
        }
    };
    public static final String EXCEPTION_KEY = "jaxmpp#ThrowedException";
    public static final String LOGIN_TIMEOUT_KEY = "LOGIN_TIMEOUT_KEY";
    public static final String SYNCHRONIZED_MODE = "jaxmpp#synchronized";
    private Executor executor;
    private TimerTask loginTimeoutTask;
    private final Timer timer = new Timer(true);

    public Jaxmpp() {
        this((SessionObject)new J2SESessionObject());
        this.setExecutor(DEFAULT_EXECUTOR);
    }

    public Jaxmpp(SessionObject sessionObject) {
        super(sessionObject);
        this.setExecutor(DEFAULT_EXECUTOR);
        TimerTask checkTimeouts = new TimerTask(){

            @Override
            public void run() {
                try {
                    Jaxmpp.this.checkTimeouts();
                }
                catch (JaxmppException e) {
                    e.printStackTrace();
                }
            }
        };
        this.timer.schedule(checkTimeouts, 30000L, 30000L);
        this.processor = new Processor(this.modulesManager, this.sessionObject, this.writer);
        this.modulesInit();
        ResourceBinderModule r = (ResourceBinderModule)this.modulesManager.getModule(ResourceBinderModule.class);
        r.addListener(ResourceBinderModule.ResourceBindSuccess, this.resourceBindListener);
    }

    protected void checkTimeouts() throws JaxmppException {
        this.sessionObject.checkHandlersTimeout();
    }

    protected Connector createConnector() throws JaxmppException {
        if (this.sessionObject.getProperty(CONNECTOR_TYPE) == null || "socket".equals(this.sessionObject.getProperty(CONNECTOR_TYPE))) {
            this.log.info("Using SocketConnector");
            return new SocketConnector(this.observable, (SessionObject)this.sessionObject);
        }
        if ("bosh".equals(this.sessionObject.getProperty(CONNECTOR_TYPE))) {
            this.log.info("Using BOSHConnector");
            return new BoshConnector(this.observable, (SessionObject)this.sessionObject);
        }
        throw new JaxmppException("Unknown connector type");
    }

    public void disconnect() throws JaxmppException {
        this.disconnect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean snc) throws JaxmppException {
        if (this.connector != null) {
            try {
                this.connector.stop();
            }
            catch (XMLException e) {
                throw new JaxmppException((Throwable)e);
            }
            Boolean sync = (Boolean)this.sessionObject.getProperty(SYNCHRONIZED_MODE);
            if (sync != null && sync.booleanValue()) {
                Jaxmpp jaxmpp = this;
                synchronized (jaxmpp) {
                }
            }
        }
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return new ConnectionConfiguration((SessionObject)this.sessionObject);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void login() throws JaxmppException {
        this.login(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(boolean sync) throws JaxmppException {
        this.sessionObject.clear();
        if (this.sessionLogic != null) {
            this.sessionLogic.unbind();
            this.sessionLogic = null;
        }
        if (this.connector != null) {
            this.connector.removeAllListeners();
            this.connector = null;
        }
        this.connector = this.createConnector();
        this.connector.addListener(Connector.StanzaReceived, this.stanzaReceivedListener);
        this.connector.addListener(Connector.StreamTerminated, this.streamTerminateListener);
        this.connector.addListener(Connector.Error, this.streamErrorListener);
        this.sessionLogic = this.connector.createSessionLogic(this.modulesManager, this.writer);
        this.sessionLogic.setSessionListener(new XmppSessionLogic.SessionListener(){

            public void onException(JaxmppException e) throws JaxmppException {
                Jaxmpp.this.onException(e);
            }
        });
        try {
            this.sessionLogic.beforeStart();
            this.connector.start();
            this.sessionObject.setProperty(SYNCHRONIZED_MODE, (Object)sync);
            if (sync) {
                this.loginTimeoutTask = new LoginTimeoutTask();
                Long delay = (Long)this.sessionObject.getProperty(LOGIN_TIMEOUT_KEY);
                this.log.finest("Starting LoginTimeoutTask");
                this.timer.schedule(this.loginTimeoutTask, delay == null ? 300000L : delay);
                Jaxmpp jaxmpp = this;
                synchronized (jaxmpp) {
                    ((Object)((Object)this)).wait();
                    this.log.finest("Waked up");
                }
                if (this.loginTimeoutTask != null) {
                    this.log.finest("Canceling LoginTimeoutTask");
                    this.loginTimeoutTask.cancel();
                    this.loginTimeoutTask = null;
                }
            }
            if (this.sessionObject.getProperty(EXCEPTION_KEY) != null) {
                JaxmppException r = (JaxmppException)((Object)this.sessionObject.getProperty(EXCEPTION_KEY));
                JaxmppException e = new JaxmppException(r.getMessage(), r.getCause());
                throw e;
            }
        }
        catch (JaxmppException e) {
            throw e;
        }
        catch (Exception e1) {
            JaxmppException e = new JaxmppException((Throwable)e1);
            throw e;
        }
    }

    protected void modulesInit() {
        super.modulesInit();
        this.modulesManager.register((XmppModule)new CapabilitiesModule((SessionObject)this.sessionObject, this.writer, (DiscoInfoModule)this.modulesManager.getModule(DiscoInfoModule.class), (PresenceModule)this.modulesManager.getModule(PresenceModule.class), this.modulesManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onException(JaxmppException e) throws JaxmppException {
        this.log.log(Level.FINE, "Catching exception", e);
        this.sessionObject.setProperty(EXCEPTION_KEY, (Object)e);
        try {
            this.connector.stop();
        }
        catch (Exception e1) {
            this.log.log(Level.FINE, "Disconnecting error", e1);
        }
        Jaxmpp e1 = this;
        synchronized (e1) {
            ((Object)((Object)this)).notify();
        }
        JaxmppCore.JaxmppEvent event = new JaxmppCore.JaxmppEvent(Disconnected, (SessionObject)this.sessionObject);
        this.observable.fireEvent((BaseEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onResourceBinded(ResourceBinderModule.ResourceBindEvent be) throws JaxmppException {
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            ((Object)((Object)this)).notify();
        }
        JaxmppCore.JaxmppEvent event = new JaxmppCore.JaxmppEvent(Connected, (SessionObject)this.sessionObject);
        this.observable.fireEvent((BaseEvent)event);
    }

    protected void onStanzaReceived(Element stanza) {
        Runnable r = this.processor.process(stanza);
        if (r != null) {
            this.executor.execute(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStreamError(Connector.ConnectorEvent be) throws JaxmppException {
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            ((Object)((Object)this)).notify();
        }
        JaxmppCore.JaxmppEvent event = new JaxmppCore.JaxmppEvent(Disconnected, (SessionObject)this.sessionObject);
        this.observable.fireEvent((BaseEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStreamTerminated(Connector.ConnectorEvent be) throws JaxmppException {
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            ((Object)((Object)this)).notify();
        }
        JaxmppCore.JaxmppEvent event = new JaxmppCore.JaxmppEvent(Disconnected, (SessionObject)this.sessionObject);
        this.observable.fireEvent((BaseEvent)event);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor == null ? DEFAULT_EXECUTOR : executor;
    }

    static {
        ObservableFactory.setFactorySpi((ObservableFactory.FactorySpi)new ObservableFactory.FactorySpi(){

            public Observable create() {
                return this.create(null);
            }

            public Observable create(Observable parent) {
                return new ThreadSafeObservable(parent);
            }
        });
        DateTimeFormat.setProvider((DateTimeFormat.DateTimeFormatProvider)new DateTimeFormatProviderImpl());
    }

    private class LoginTimeoutTask
    extends TimerTask {
        private LoginTimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Jaxmpp jaxmpp = Jaxmpp.this;
            synchronized (jaxmpp) {
                ((Object)((Object)Jaxmpp.this)).notify();
            }
        }
    }
}

