/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.chat.xep0085;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.eventbus.JaxmppEvent;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xmpp.modules.ContextAware;
import tigase.jaxmpp.core.client.xmpp.modules.chat.AbstractChatManager;
import tigase.jaxmpp.core.client.xmpp.modules.chat.Chat;
import tigase.jaxmpp.core.client.xmpp.modules.chat.MessageModule;
import tigase.jaxmpp.core.client.xmpp.modules.chat.xep0085.ChatState;
import tigase.jaxmpp.core.client.xmpp.modules.extensions.Extension;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceStore;
import tigase.jaxmpp.core.client.xmpp.stanzas.Message;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;
import tigase.jaxmpp.core.client.xmpp.stanzas.StanzaType;

public class ChatStateExtension
implements Extension,
ContextAware,
MessageModule.ChatClosedHandler,
JaxmppCore.LoggedOutHandler {
    private static final Logger log = Logger.getLogger(ChatStateExtension.class.getCanonicalName());
    public static final String CHAT_STATE_DISABLED_KEY = "xep-0085#disabled";
    private static final String[] FEATURES = new String[]{ChatState.XMLNS};
    private final AbstractChatManager chatManager;
    private final Map<Long, StateHolder> chatStates = new HashMap<Long, StateHolder>();
    private Context context;

    public ChatStateExtension(AbstractChatManager chatManager) {
        this.chatManager = chatManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element afterReceive(Element received) throws JaxmppException {
        List elems;
        Chat chat;
        Message msg = (Message)Stanza.create((Element)received);
        if (msg.getType() == StanzaType.chat && !ChatStateExtension.isDisabled(this.context.getSessionObject()) && (chat = this.chatManager.getChat(msg.getFrom(), msg.getThread())) != null && (elems = received.getChildrenNS(ChatState.XMLNS)) != null && !elems.isEmpty()) {
            StateHolder holder;
            ChatState state = ChatState.fromElement((Element)elems.get(0));
            Map<Long, StateHolder> map = this.chatStates;
            synchronized (map) {
                holder = this.chatStates.get(chat.getId());
                if (holder == null) {
                    holder = new StateHolder();
                    this.chatStates.put(chat.getId(), holder);
                }
            }
            boolean changed = holder.setRecipientChatState(state);
            if (changed) {
                this.context.getEventBus().fire((Event)new ChatStateChangedHandler.ChatStateChangedEvent(this.context.getSessionObject(), chat, state));
            }
        }
        return received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element beforeSend(Element received) throws JaxmppException {
        Chat chat;
        Message msg = (Message)Stanza.create((Element)received);
        if (msg.getType() == StanzaType.chat && !ChatStateExtension.isDisabled(this.context.getSessionObject()) && (chat = this.chatManager.getChat(msg.getTo(), msg.getThread())) != null) {
            StateHolder holder;
            Map<Long, StateHolder> map = this.chatStates;
            synchronized (map) {
                holder = this.chatStates.get(chat.getId());
            }
            if (holder != null) {
                holder.setOwnChatState(ChatState.active);
                received.addChild(ChatState.active.toElement());
            }
        }
        return received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatState getRecipientChatState(Chat chat) {
        StateHolder holder;
        Map<Long, StateHolder> map = this.chatStates;
        synchronized (map) {
            holder = this.chatStates.get(chat.getId());
        }
        return holder == null ? null : holder.getRecipientChatState();
    }

    public void setOwnChatState(Chat chat, ChatState state) throws JaxmppException {
        this.setOwnChatState(chat, state, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOwnChatState(Chat chat, ChatState state, boolean force) throws JaxmppException {
        StateHolder holder;
        if (!force && ChatStateExtension.isDisabled(chat.getSessionObject())) {
            return;
        }
        PresenceStore presenceStore = PresenceModule.getPresenceStore((SessionObject)this.context.getSessionObject());
        if (presenceStore == null || !presenceStore.isAvailable(chat.getJid().getBareJid())) {
            return;
        }
        Map<Long, StateHolder> map = this.chatStates;
        synchronized (map) {
            holder = this.chatStates.get(chat.getId());
            if (holder == null) {
                holder = new StateHolder();
                this.chatStates.put(chat.getId(), holder);
            }
        }
        boolean changed = holder.setOwnChatState(state);
        if (changed) {
            Message msg = Message.create();
            msg.setTo(chat.getJid());
            msg.setType(StanzaType.chat);
            msg.addChild(state.toElement());
            this.context.getWriter().write((Element)msg);
        }
    }

    public String[] getFeatures() {
        if (!ChatStateExtension.isDisabled(this.context.getSessionObject())) {
            return FEATURES;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoggedOut(SessionObject sessionObject) {
        for (Chat chat : this.chatManager.getChats()) {
            StateHolder holder;
            Map<Long, StateHolder> map = this.chatStates;
            synchronized (map) {
                holder = this.chatStates.remove(chat.getId());
            }
            if (holder == null || holder.getRecipientChatState() == null) continue;
            this.context.getEventBus().fire((Event)new ChatStateChangedHandler.ChatStateChangedEvent(this.context.getSessionObject(), chat, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChatClosed(SessionObject sessionObject, Chat chat) {
        try {
            if (!ChatStateExtension.isDisabled(sessionObject)) {
                this.setOwnChatState(chat, ChatState.gone);
            }
        }
        catch (JaxmppException ex) {
            log.log(Level.FINE, "Exception while sending gone notification on chat close", ex);
        }
        Map<Long, StateHolder> map = this.chatStates;
        synchronized (map) {
            this.chatStates.remove(chat.getId());
        }
    }

    public void setContext(Context context) {
        this.context = context;
        context.getEventBus().addHandler(MessageModule.ChatClosedHandler.ChatClosedEvent.class, (EventHandler)this);
        context.getEventBus().addHandler(JaxmppCore.LoggedOutHandler.LoggedOutEvent.class, (EventHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabled(boolean disabled) {
        this.context.getSessionObject().setProperty(CHAT_STATE_DISABLED_KEY, (Object)disabled);
        if (disabled) {
            for (Chat chat : this.chatManager.getChats()) {
                try {
                    StateHolder holder;
                    Map<Long, StateHolder> map = this.chatStates;
                    synchronized (map) {
                        holder = this.chatStates.remove(chat.getId());
                    }
                    if (holder == null) continue;
                    if (holder.getRecipientChatState() != null) {
                        this.context.getEventBus().fire((Event)new ChatStateChangedHandler.ChatStateChangedEvent(this.context.getSessionObject(), chat, null));
                    }
                    if (holder.getOwnChatState() == null || holder.getOwnChatState() == ChatState.active && holder.getOwnChatState() == ChatState.gone) continue;
                    this.setOwnChatState(chat, ChatState.active, true);
                }
                catch (JaxmppException ex) {
                    log.log(Level.FINE, "Exception sending chat state on disabling chat state support", ex);
                }
            }
        }
    }

    public static boolean isDisabled(SessionObject sessionObject) {
        Boolean value = (Boolean)sessionObject.getProperty(CHAT_STATE_DISABLED_KEY);
        return value != null && value != false;
    }

    private class StateHolder {
        private ChatState ownChatState;
        private ChatState recipientChatState;

        private StateHolder() {
        }

        public ChatState getOwnChatState() {
            return this.ownChatState;
        }

        public boolean setOwnChatState(ChatState state) {
            boolean changed = this.ownChatState != state;
            this.ownChatState = state;
            return changed;
        }

        public ChatState getRecipientChatState() {
            return this.recipientChatState;
        }

        public boolean setRecipientChatState(ChatState state) {
            boolean changed = this.recipientChatState != state;
            this.recipientChatState = state;
            return changed;
        }
    }

    public static interface ChatStateChangedHandler
    extends EventHandler {
        public void onChatStateChanged(SessionObject var1, Chat var2, ChatState var3);

        public static class ChatStateChangedEvent
        extends JaxmppEvent<ChatStateChangedHandler> {
            private final Chat chat;
            private final ChatState chatState;

            public ChatStateChangedEvent(SessionObject sessionObject, Chat chat, ChatState state) {
                super(sessionObject);
                this.chat = chat;
                this.chatState = state;
            }

            protected void dispatch(ChatStateChangedHandler handler) throws Exception {
                handler.onChatStateChanged(this.sessionObject, this.chat, this.chatState);
            }
        }
    }
}

