/*
 * XOAuth2TokenCallback.java
 *
 * Tigase XMPP Client Library
 * Copyright (C) 2004-2018 "Tigase, Inc." <office@tigase.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */
package tigase.jaxmpp.core.client.xmpp.modules.auth;

import tigase.jaxmpp.core.client.SessionObject;

/**
 * With this callback user password may be not stored in
 * {@linkplain SessionObject} but may be calculated my class.
 * <p>
 * Callback must be stored in {@linkplain SessionObject} with key
 * {@linkplain AuthModule#CREDENTIALS_CALLBACK}.
 * </p>
 */
public interface XOAuth2TokenCallback {

	String getCredential();

}