/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state;

import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPrivateKey;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.kdf.HKDF;
import org.whispersystems.libsignal.logging.Log;
import org.whispersystems.libsignal.ratchet.ChainKey;
import org.whispersystems.libsignal.ratchet.MessageKeys;
import org.whispersystems.libsignal.ratchet.RootKey;
import org.whispersystems.libsignal.state.StorageProtos;
import org.whispersystems.libsignal.util.Pair;
import org.whispersystems.libsignal.util.guava.Optional;

public class SessionState {
    private static final int MAX_MESSAGE_KEYS = 2000;
    private StorageProtos.SessionStructure sessionStructure;

    public SessionState() {
        this.sessionStructure = StorageProtos.SessionStructure.newBuilder().build();
    }

    public SessionState(StorageProtos.SessionStructure sessionStructure) {
        this.sessionStructure = sessionStructure;
    }

    public SessionState(SessionState copy) {
        this.sessionStructure = copy.sessionStructure.toBuilder().build();
    }

    public StorageProtos.SessionStructure getStructure() {
        return this.sessionStructure;
    }

    public byte[] getAliceBaseKey() {
        return this.sessionStructure.getAliceBaseKey().toByteArray();
    }

    public void setAliceBaseKey(byte[] aliceBaseKey) {
        this.sessionStructure = this.sessionStructure.toBuilder().setAliceBaseKey(ByteString.copyFrom((byte[])aliceBaseKey)).build();
    }

    public void setSessionVersion(int version) {
        this.sessionStructure = this.sessionStructure.toBuilder().setSessionVersion(version).build();
    }

    public int getSessionVersion() {
        int sessionVersion = this.sessionStructure.getSessionVersion();
        if (sessionVersion == 0) {
            return 2;
        }
        return sessionVersion;
    }

    public void setRemoteIdentityKey(IdentityKey identityKey) {
        this.sessionStructure = this.sessionStructure.toBuilder().setRemoteIdentityPublic(ByteString.copyFrom((byte[])identityKey.serialize())).build();
    }

    public void setLocalIdentityKey(IdentityKey identityKey) {
        this.sessionStructure = this.sessionStructure.toBuilder().setLocalIdentityPublic(ByteString.copyFrom((byte[])identityKey.serialize())).build();
    }

    public IdentityKey getRemoteIdentityKey() {
        try {
            if (!this.sessionStructure.hasRemoteIdentityPublic()) {
                return null;
            }
            return new IdentityKey(this.sessionStructure.getRemoteIdentityPublic().toByteArray(), 0);
        }
        catch (InvalidKeyException e) {
            Log.w("SessionRecordV2", e);
            return null;
        }
    }

    public IdentityKey getLocalIdentityKey() {
        try {
            return new IdentityKey(this.sessionStructure.getLocalIdentityPublic().toByteArray(), 0);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getPreviousCounter() {
        return this.sessionStructure.getPreviousCounter();
    }

    public void setPreviousCounter(int previousCounter) {
        this.sessionStructure = this.sessionStructure.toBuilder().setPreviousCounter(previousCounter).build();
    }

    public RootKey getRootKey() {
        return new RootKey(HKDF.createFor(this.getSessionVersion()), this.sessionStructure.getRootKey().toByteArray());
    }

    public void setRootKey(RootKey rootKey) {
        this.sessionStructure = this.sessionStructure.toBuilder().setRootKey(ByteString.copyFrom((byte[])rootKey.getKeyBytes())).build();
    }

    public ECPublicKey getSenderRatchetKey() {
        try {
            return Curve.decodePoint(this.sessionStructure.getSenderChain().getSenderRatchetKey().toByteArray(), 0);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ECKeyPair getSenderRatchetKeyPair() {
        ECPublicKey publicKey = this.getSenderRatchetKey();
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getSenderChain().getSenderRatchetKeyPrivate().toByteArray());
        return new ECKeyPair(publicKey, privateKey);
    }

    public boolean hasReceiverChain(ECPublicKey senderEphemeral) {
        return this.getReceiverChain(senderEphemeral) != null;
    }

    public boolean hasSenderChain() {
        return this.sessionStructure.hasSenderChain();
    }

    private Pair<StorageProtos.SessionStructure.Chain, Integer> getReceiverChain(ECPublicKey senderEphemeral) {
        List<StorageProtos.SessionStructure.Chain> receiverChains = this.sessionStructure.getReceiverChainsList();
        int index = 0;
        for (StorageProtos.SessionStructure.Chain receiverChain : receiverChains) {
            try {
                ECPublicKey chainSenderRatchetKey = Curve.decodePoint(receiverChain.getSenderRatchetKey().toByteArray(), 0);
                if (chainSenderRatchetKey.equals(senderEphemeral)) {
                    return new Pair<StorageProtos.SessionStructure.Chain, Integer>(receiverChain, index);
                }
            }
            catch (InvalidKeyException e) {
                Log.w("SessionRecordV2", e);
            }
            ++index;
        }
        return null;
    }

    public ChainKey getReceiverChainKey(ECPublicKey senderEphemeral) {
        Pair<StorageProtos.SessionStructure.Chain, Integer> receiverChainAndIndex = this.getReceiverChain(senderEphemeral);
        StorageProtos.SessionStructure.Chain receiverChain = receiverChainAndIndex.first();
        if (receiverChain == null) {
            return null;
        }
        return new ChainKey(HKDF.createFor(this.getSessionVersion()), receiverChain.getChainKey().getKey().toByteArray(), receiverChain.getChainKey().getIndex());
    }

    public void addReceiverChain(ECPublicKey senderRatchetKey, ChainKey chainKey) {
        StorageProtos.SessionStructure.Chain.ChainKey chainKeyStructure = StorageProtos.SessionStructure.Chain.ChainKey.newBuilder().setKey(ByteString.copyFrom((byte[])chainKey.getKey())).setIndex(chainKey.getIndex()).build();
        StorageProtos.SessionStructure.Chain chain = StorageProtos.SessionStructure.Chain.newBuilder().setChainKey(chainKeyStructure).setSenderRatchetKey(ByteString.copyFrom((byte[])senderRatchetKey.serialize())).build();
        this.sessionStructure = this.sessionStructure.toBuilder().addReceiverChains(chain).build();
        if (this.sessionStructure.getReceiverChainsList().size() > 5) {
            this.sessionStructure = this.sessionStructure.toBuilder().removeReceiverChains(0).build();
        }
    }

    public void setSenderChain(ECKeyPair senderRatchetKeyPair, ChainKey chainKey) {
        StorageProtos.SessionStructure.Chain.ChainKey chainKeyStructure = StorageProtos.SessionStructure.Chain.ChainKey.newBuilder().setKey(ByteString.copyFrom((byte[])chainKey.getKey())).setIndex(chainKey.getIndex()).build();
        StorageProtos.SessionStructure.Chain senderChain = StorageProtos.SessionStructure.Chain.newBuilder().setSenderRatchetKey(ByteString.copyFrom((byte[])senderRatchetKeyPair.getPublicKey().serialize())).setSenderRatchetKeyPrivate(ByteString.copyFrom((byte[])senderRatchetKeyPair.getPrivateKey().serialize())).setChainKey(chainKeyStructure).build();
        this.sessionStructure = this.sessionStructure.toBuilder().setSenderChain(senderChain).build();
    }

    public ChainKey getSenderChainKey() {
        StorageProtos.SessionStructure.Chain.ChainKey chainKeyStructure = this.sessionStructure.getSenderChain().getChainKey();
        return new ChainKey(HKDF.createFor(this.getSessionVersion()), chainKeyStructure.getKey().toByteArray(), chainKeyStructure.getIndex());
    }

    public void setSenderChainKey(ChainKey nextChainKey) {
        StorageProtos.SessionStructure.Chain.ChainKey chainKey = StorageProtos.SessionStructure.Chain.ChainKey.newBuilder().setKey(ByteString.copyFrom((byte[])nextChainKey.getKey())).setIndex(nextChainKey.getIndex()).build();
        StorageProtos.SessionStructure.Chain chain = this.sessionStructure.getSenderChain().toBuilder().setChainKey(chainKey).build();
        this.sessionStructure = this.sessionStructure.toBuilder().setSenderChain(chain).build();
    }

    public boolean hasMessageKeys(ECPublicKey senderEphemeral, int counter) {
        Pair<StorageProtos.SessionStructure.Chain, Integer> chainAndIndex = this.getReceiverChain(senderEphemeral);
        StorageProtos.SessionStructure.Chain chain = chainAndIndex.first();
        if (chain == null) {
            return false;
        }
        List<StorageProtos.SessionStructure.Chain.MessageKey> messageKeyList = chain.getMessageKeysList();
        for (StorageProtos.SessionStructure.Chain.MessageKey messageKey : messageKeyList) {
            if (messageKey.getIndex() != counter) continue;
            return true;
        }
        return false;
    }

    public MessageKeys removeMessageKeys(ECPublicKey senderEphemeral, int counter) {
        Pair<StorageProtos.SessionStructure.Chain, Integer> chainAndIndex = this.getReceiverChain(senderEphemeral);
        StorageProtos.SessionStructure.Chain chain = chainAndIndex.first();
        if (chain == null) {
            return null;
        }
        LinkedList<StorageProtos.SessionStructure.Chain.MessageKey> messageKeyList = new LinkedList<StorageProtos.SessionStructure.Chain.MessageKey>(chain.getMessageKeysList());
        Iterator messageKeyIterator = messageKeyList.iterator();
        MessageKeys result = null;
        while (messageKeyIterator.hasNext()) {
            StorageProtos.SessionStructure.Chain.MessageKey messageKey = (StorageProtos.SessionStructure.Chain.MessageKey)messageKeyIterator.next();
            if (messageKey.getIndex() != counter) continue;
            result = new MessageKeys(new SecretKeySpec(messageKey.getCipherKey().toByteArray(), "AES"), new SecretKeySpec(messageKey.getMacKey().toByteArray(), "HmacSHA256"), new IvParameterSpec(messageKey.getIv().toByteArray()), messageKey.getIndex());
            messageKeyIterator.remove();
            break;
        }
        StorageProtos.SessionStructure.Chain updatedChain = chain.toBuilder().clearMessageKeys().addAllMessageKeys(messageKeyList).build();
        this.sessionStructure = this.sessionStructure.toBuilder().setReceiverChains((int)chainAndIndex.second(), updatedChain).build();
        return result;
    }

    public void setMessageKeys(ECPublicKey senderEphemeral, MessageKeys messageKeys) {
        Pair<StorageProtos.SessionStructure.Chain, Integer> chainAndIndex = this.getReceiverChain(senderEphemeral);
        StorageProtos.SessionStructure.Chain chain = chainAndIndex.first();
        StorageProtos.SessionStructure.Chain.MessageKey messageKeyStructure = StorageProtos.SessionStructure.Chain.MessageKey.newBuilder().setCipherKey(ByteString.copyFrom((byte[])messageKeys.getCipherKey().getEncoded())).setMacKey(ByteString.copyFrom((byte[])messageKeys.getMacKey().getEncoded())).setIndex(messageKeys.getCounter()).setIv(ByteString.copyFrom((byte[])messageKeys.getIv().getIV())).build();
        StorageProtos.SessionStructure.Chain.Builder updatedChain = chain.toBuilder().addMessageKeys(messageKeyStructure);
        if (updatedChain.getMessageKeysCount() > 2000) {
            updatedChain.removeMessageKeys(0);
        }
        this.sessionStructure = this.sessionStructure.toBuilder().setReceiverChains((int)chainAndIndex.second(), updatedChain.build()).build();
    }

    public void setReceiverChainKey(ECPublicKey senderEphemeral, ChainKey chainKey) {
        Pair<StorageProtos.SessionStructure.Chain, Integer> chainAndIndex = this.getReceiverChain(senderEphemeral);
        StorageProtos.SessionStructure.Chain chain = chainAndIndex.first();
        StorageProtos.SessionStructure.Chain.ChainKey chainKeyStructure = StorageProtos.SessionStructure.Chain.ChainKey.newBuilder().setKey(ByteString.copyFrom((byte[])chainKey.getKey())).setIndex(chainKey.getIndex()).build();
        StorageProtos.SessionStructure.Chain updatedChain = chain.toBuilder().setChainKey(chainKeyStructure).build();
        this.sessionStructure = this.sessionStructure.toBuilder().setReceiverChains((int)chainAndIndex.second(), updatedChain).build();
    }

    public void setPendingKeyExchange(int sequence, ECKeyPair ourBaseKey, ECKeyPair ourRatchetKey, IdentityKeyPair ourIdentityKey) {
        StorageProtos.SessionStructure.PendingKeyExchange structure = StorageProtos.SessionStructure.PendingKeyExchange.newBuilder().setSequence(sequence).setLocalBaseKey(ByteString.copyFrom((byte[])ourBaseKey.getPublicKey().serialize())).setLocalBaseKeyPrivate(ByteString.copyFrom((byte[])ourBaseKey.getPrivateKey().serialize())).setLocalRatchetKey(ByteString.copyFrom((byte[])ourRatchetKey.getPublicKey().serialize())).setLocalRatchetKeyPrivate(ByteString.copyFrom((byte[])ourRatchetKey.getPrivateKey().serialize())).setLocalIdentityKey(ByteString.copyFrom((byte[])ourIdentityKey.getPublicKey().serialize())).setLocalIdentityKeyPrivate(ByteString.copyFrom((byte[])ourIdentityKey.getPrivateKey().serialize())).build();
        this.sessionStructure = this.sessionStructure.toBuilder().setPendingKeyExchange(structure).build();
    }

    public int getPendingKeyExchangeSequence() {
        return this.sessionStructure.getPendingKeyExchange().getSequence();
    }

    public ECKeyPair getPendingKeyExchangeBaseKey() throws InvalidKeyException {
        ECPublicKey publicKey = Curve.decodePoint(this.sessionStructure.getPendingKeyExchange().getLocalBaseKey().toByteArray(), 0);
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getPendingKeyExchange().getLocalBaseKeyPrivate().toByteArray());
        return new ECKeyPair(publicKey, privateKey);
    }

    public ECKeyPair getPendingKeyExchangeRatchetKey() throws InvalidKeyException {
        ECPublicKey publicKey = Curve.decodePoint(this.sessionStructure.getPendingKeyExchange().getLocalRatchetKey().toByteArray(), 0);
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getPendingKeyExchange().getLocalRatchetKeyPrivate().toByteArray());
        return new ECKeyPair(publicKey, privateKey);
    }

    public IdentityKeyPair getPendingKeyExchangeIdentityKey() throws InvalidKeyException {
        IdentityKey publicKey = new IdentityKey(this.sessionStructure.getPendingKeyExchange().getLocalIdentityKey().toByteArray(), 0);
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getPendingKeyExchange().getLocalIdentityKeyPrivate().toByteArray());
        return new IdentityKeyPair(publicKey, privateKey);
    }

    public boolean hasPendingKeyExchange() {
        return this.sessionStructure.hasPendingKeyExchange();
    }

    public void setUnacknowledgedPreKeyMessage(Optional<Integer> preKeyId, int signedPreKeyId, ECPublicKey baseKey) {
        StorageProtos.SessionStructure.PendingPreKey.Builder pending = StorageProtos.SessionStructure.PendingPreKey.newBuilder().setSignedPreKeyId(signedPreKeyId).setBaseKey(ByteString.copyFrom((byte[])baseKey.serialize()));
        if (preKeyId.isPresent()) {
            pending.setPreKeyId(preKeyId.get());
        }
        this.sessionStructure = this.sessionStructure.toBuilder().setPendingPreKey(pending.build()).build();
    }

    public boolean hasUnacknowledgedPreKeyMessage() {
        return this.sessionStructure.hasPendingPreKey();
    }

    public UnacknowledgedPreKeyMessageItems getUnacknowledgedPreKeyMessageItems() {
        try {
            Optional<Integer> preKeyId = this.sessionStructure.getPendingPreKey().hasPreKeyId() ? Optional.of(this.sessionStructure.getPendingPreKey().getPreKeyId()) : Optional.absent();
            return new UnacknowledgedPreKeyMessageItems(preKeyId, this.sessionStructure.getPendingPreKey().getSignedPreKeyId(), Curve.decodePoint(this.sessionStructure.getPendingPreKey().getBaseKey().toByteArray(), 0));
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void clearUnacknowledgedPreKeyMessage() {
        this.sessionStructure = this.sessionStructure.toBuilder().clearPendingPreKey().build();
    }

    public void setRemoteRegistrationId(int registrationId) {
        this.sessionStructure = this.sessionStructure.toBuilder().setRemoteRegistrationId(registrationId).build();
    }

    public int getRemoteRegistrationId() {
        return this.sessionStructure.getRemoteRegistrationId();
    }

    public void setLocalRegistrationId(int registrationId) {
        this.sessionStructure = this.sessionStructure.toBuilder().setLocalRegistrationId(registrationId).build();
    }

    public int getLocalRegistrationId() {
        return this.sessionStructure.getLocalRegistrationId();
    }

    public byte[] serialize() {
        return this.sessionStructure.toByteArray();
    }

    public static class UnacknowledgedPreKeyMessageItems {
        private final Optional<Integer> preKeyId;
        private final int signedPreKeyId;
        private final ECPublicKey baseKey;

        public UnacknowledgedPreKeyMessageItems(Optional<Integer> preKeyId, int signedPreKeyId, ECPublicKey baseKey) {
            this.preKeyId = preKeyId;
            this.signedPreKeyId = signedPreKeyId;
            this.baseKey = baseKey;
        }

        public Optional<Integer> getPreKeyId() {
            return this.preKeyId;
        }

        public int getSignedPreKeyId() {
            return this.signedPreKeyId;
        }

        public ECPublicKey getBaseKey() {
            return this.baseKey;
        }
    }
}

