/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.whispersystems.libsignal.state.SessionState;
import org.whispersystems.libsignal.state.StorageProtos;

public class SessionRecord {
    private static final int ARCHIVED_STATES_MAX_LENGTH = 40;
    private SessionState sessionState = new SessionState();
    private LinkedList<SessionState> previousStates = new LinkedList();
    private boolean fresh = false;

    public SessionRecord() {
        this.fresh = true;
    }

    public SessionRecord(SessionState sessionState) {
        this.sessionState = sessionState;
        this.fresh = false;
    }

    public SessionRecord(byte[] serialized) throws IOException {
        StorageProtos.RecordStructure record = StorageProtos.RecordStructure.parseFrom(serialized);
        this.sessionState = new SessionState(record.getCurrentSession());
        this.fresh = false;
        for (StorageProtos.SessionStructure previousStructure : record.getPreviousSessionsList()) {
            this.previousStates.add(new SessionState(previousStructure));
        }
    }

    public boolean hasSessionState(int version, byte[] aliceBaseKey) {
        if (this.sessionState.getSessionVersion() == version && Arrays.equals(aliceBaseKey, this.sessionState.getAliceBaseKey())) {
            return true;
        }
        for (SessionState state : this.previousStates) {
            if (state.getSessionVersion() != version || !Arrays.equals(aliceBaseKey, state.getAliceBaseKey())) continue;
            return true;
        }
        return false;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public List<SessionState> getPreviousSessionStates() {
        return this.previousStates;
    }

    public void removePreviousSessionStates() {
        this.previousStates.clear();
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public void archiveCurrentState() {
        this.promoteState(new SessionState());
    }

    public void promoteState(SessionState promotedState) {
        this.previousStates.addFirst(this.sessionState);
        this.sessionState = promotedState;
        if (this.previousStates.size() > 40) {
            this.previousStates.removeLast();
        }
    }

    public void setState(SessionState sessionState) {
        this.sessionState = sessionState;
    }

    public byte[] serialize() {
        LinkedList<StorageProtos.SessionStructure> previousStructures = new LinkedList<StorageProtos.SessionStructure>();
        for (SessionState previousState : this.previousStates) {
            previousStructures.add(previousState.getStructure());
        }
        StorageProtos.RecordStructure record = StorageProtos.RecordStructure.newBuilder().setCurrentSession(this.sessionState.getStructure()).addAllPreviousSessions(previousStructures).build();
        return record.toByteArray();
    }
}

