/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.groups;

import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.groups.GroupCipher;
import org.whispersystems.libsignal.groups.SenderKeyName;
import org.whispersystems.libsignal.groups.state.SenderKeyRecord;
import org.whispersystems.libsignal.groups.state.SenderKeyState;
import org.whispersystems.libsignal.groups.state.SenderKeyStore;
import org.whispersystems.libsignal.protocol.SenderKeyDistributionMessage;
import org.whispersystems.libsignal.util.KeyHelper;

public class GroupSessionBuilder {
    private final SenderKeyStore senderKeyStore;

    public GroupSessionBuilder(SenderKeyStore senderKeyStore) {
        this.senderKeyStore = senderKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SenderKeyName senderKeyName, SenderKeyDistributionMessage senderKeyDistributionMessage) {
        Object object = GroupCipher.LOCK;
        synchronized (object) {
            SenderKeyRecord senderKeyRecord = this.senderKeyStore.loadSenderKey(senderKeyName);
            senderKeyRecord.addSenderKeyState(senderKeyDistributionMessage.getId(), senderKeyDistributionMessage.getIteration(), senderKeyDistributionMessage.getChainKey(), senderKeyDistributionMessage.getSignatureKey());
            this.senderKeyStore.storeSenderKey(senderKeyName, senderKeyRecord);
        }
    }

    public SenderKeyDistributionMessage create(SenderKeyName senderKeyName) {
        Object object = GroupCipher.LOCK;
        synchronized (object) {
            try {
                SenderKeyRecord senderKeyRecord = this.senderKeyStore.loadSenderKey(senderKeyName);
                if (senderKeyRecord.isEmpty()) {
                    senderKeyRecord.setSenderKeyState(KeyHelper.generateSenderKeyId(), 0, KeyHelper.generateSenderKey(), KeyHelper.generateSenderSigningKey());
                    this.senderKeyStore.storeSenderKey(senderKeyName, senderKeyRecord);
                }
                SenderKeyState state = senderKeyRecord.getSenderKeyState();
                return new SenderKeyDistributionMessage(state.getKeyId(), state.getSenderChainKey().getIteration(), state.getSenderChainKey().getSeed(), state.getSigningKeyPublic());
            }
            catch (InvalidKeyException | InvalidKeyIdException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

