/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.groups;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.DecryptionCallback;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.groups.SenderKeyName;
import org.whispersystems.libsignal.groups.ratchet.SenderChainKey;
import org.whispersystems.libsignal.groups.ratchet.SenderMessageKey;
import org.whispersystems.libsignal.groups.state.SenderKeyRecord;
import org.whispersystems.libsignal.groups.state.SenderKeyState;
import org.whispersystems.libsignal.groups.state.SenderKeyStore;
import org.whispersystems.libsignal.protocol.SenderKeyMessage;

public class GroupCipher {
    static final Object LOCK = new Object();
    private final SenderKeyStore senderKeyStore;
    private final SenderKeyName senderKeyId;

    public GroupCipher(SenderKeyStore senderKeyStore, SenderKeyName senderKeyId) {
        this.senderKeyStore = senderKeyStore;
        this.senderKeyId = senderKeyId;
    }

    public byte[] encrypt(byte[] paddedPlaintext) throws NoSessionException {
        Object object = LOCK;
        synchronized (object) {
            try {
                SenderKeyRecord record = this.senderKeyStore.loadSenderKey(this.senderKeyId);
                SenderKeyState senderKeyState = record.getSenderKeyState();
                SenderMessageKey senderKey = senderKeyState.getSenderChainKey().getSenderMessageKey();
                byte[] ciphertext = this.getCipherText(senderKey.getIv(), senderKey.getCipherKey(), paddedPlaintext);
                SenderKeyMessage senderKeyMessage = new SenderKeyMessage(senderKeyState.getKeyId(), senderKey.getIteration(), ciphertext, senderKeyState.getSigningKeyPrivate());
                senderKeyState.setSenderChainKey(senderKeyState.getSenderChainKey().getNext());
                this.senderKeyStore.storeSenderKey(this.senderKeyId, record);
                return senderKeyMessage.serialize();
            }
            catch (InvalidKeyIdException e) {
                throw new NoSessionException(e);
            }
        }
    }

    public byte[] decrypt(byte[] senderKeyMessageBytes) throws LegacyMessageException, DuplicateMessageException, InvalidMessageException, NoSessionException {
        return this.decrypt(senderKeyMessageBytes, new NullDecryptionCallback());
    }

    public byte[] decrypt(byte[] senderKeyMessageBytes, DecryptionCallback callback) throws LegacyMessageException, InvalidMessageException, DuplicateMessageException, NoSessionException {
        Object object = LOCK;
        synchronized (object) {
            try {
                SenderKeyRecord record = this.senderKeyStore.loadSenderKey(this.senderKeyId);
                if (record.isEmpty()) {
                    throw new NoSessionException("No sender key for: " + this.senderKeyId);
                }
                SenderKeyMessage senderKeyMessage = new SenderKeyMessage(senderKeyMessageBytes);
                SenderKeyState senderKeyState = record.getSenderKeyState(senderKeyMessage.getKeyId());
                senderKeyMessage.verifySignature(senderKeyState.getSigningKeyPublic());
                SenderMessageKey senderKey = this.getSenderKey(senderKeyState, senderKeyMessage.getIteration());
                byte[] plaintext = this.getPlainText(senderKey.getIv(), senderKey.getCipherKey(), senderKeyMessage.getCipherText());
                callback.handlePlaintext(plaintext);
                this.senderKeyStore.storeSenderKey(this.senderKeyId, record);
                return plaintext;
            }
            catch (InvalidKeyException | InvalidKeyIdException e) {
                throw new InvalidMessageException(e);
            }
        }
    }

    private SenderMessageKey getSenderKey(SenderKeyState senderKeyState, int iteration) throws DuplicateMessageException, InvalidMessageException {
        SenderChainKey senderChainKey = senderKeyState.getSenderChainKey();
        if (senderChainKey.getIteration() > iteration) {
            if (senderKeyState.hasSenderMessageKey(iteration)) {
                return senderKeyState.removeSenderMessageKey(iteration);
            }
            throw new DuplicateMessageException("Received message with old counter: " + senderChainKey.getIteration() + " , " + iteration);
        }
        if (iteration - senderChainKey.getIteration() > 2000) {
            throw new InvalidMessageException("Over 2000 messages into the future!");
        }
        while (senderChainKey.getIteration() < iteration) {
            senderKeyState.addSenderMessageKey(senderChainKey.getSenderMessageKey());
            senderChainKey = senderChainKey.getNext();
        }
        senderKeyState.setSenderChainKey(senderChainKey.getNext());
        return senderChainKey.getSenderMessageKey();
    }

    private byte[] getPlainText(byte[] iv, byte[] key, byte[] ciphertext) throws InvalidMessageException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), ivParameterSpec);
            return cipher.doFinal(ciphertext);
        }
        catch (InvalidAlgorithmParameterException | java.security.InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidMessageException(e);
        }
    }

    private byte[] getCipherText(byte[] iv, byte[] key, byte[] plaintext) {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), ivParameterSpec);
            return cipher.doFinal(plaintext);
        }
        catch (InvalidAlgorithmParameterException | java.security.InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class NullDecryptionCallback
    implements DecryptionCallback {
        private NullDecryptionCallback() {
        }

        @Override
        public void handlePlaintext(byte[] plaintext) {
        }
    }
}

