/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.j2se.connectors.socket.Reader;
import tigase.jaxmpp.j2se.connectors.socket.StreamListener;
import tigase.jaxmpp.j2se.connectors.socket.XMPPDomBuilderHandler;
import tigase.jaxmpp.j2se.xml.J2seElement;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public abstract class Worker
extends Thread {
    private final char[] buffer = new char[2048];
    private final Connector connector;
    private final Logger log = Logger.getLogger(Worker.class.getCanonicalName());
    private final XMPPDomBuilderHandler domHandler = new XMPPDomBuilderHandler(new StreamListener(){

        @Override
        public void nextElement(tigase.xml.Element element) {
            try {
                try {
                    Worker.this.processElement(new J2seElement(element));
                }
                catch (JaxmppException e) {
                    Worker.this.onErrorInThread((Exception)((Object)e));
                }
            }
            catch (JaxmppException e) {
                Worker.this.log.log(Level.SEVERE, "Error on processing element", e);
            }
        }

        @Override
        public void xmppStreamClosed() {
            try {
                if (Worker.this.log.isLoggable(Level.FINEST)) {
                    Worker.this.log.finest("xmppStreamClosed()");
                }
                Worker.this.onStreamTerminate();
            }
            catch (JaxmppException e) {
                Worker.this.log.log(Level.WARNING, "Error on processing Stream Closed", e);
            }
        }

        @Override
        public void xmppStreamOpened(Map<String, String> attribs) {
            if (Worker.this.log.isLoggable(Level.FINEST)) {
                Worker.this.log.finest("xmppStreamOpened()");
            }
            Worker.this.onStreamStart(attribs);
        }
    });
    private final SimpleParser parser = SingletonFactory.getParserInstance();

    public Worker(Connector connector) {
        this.connector = connector;
        this.setName("Socket-Worker-Thread");
        this.setDaemon(true);
    }

    protected abstract Reader getReader();

    @Override
    public void interrupt() {
        super.interrupt();
        this.log.log(Level.FINE, "Worker Interrupted");
    }

    protected abstract void onErrorInThread(Exception var1) throws JaxmppException;

    protected abstract void onStreamStart(Map<String, String> var1);

    protected abstract void onStreamTerminate() throws JaxmppException;

    protected abstract void processElement(Element var1) throws JaxmppException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        this.log.finest(this.hashCode() + " Starting " + this);
        int r = -2;
        try {
            Reader reader;
            while ((reader = this.getReader()) != null && !this.isInterrupted() && (r = reader.read(this.buffer)) != -1 && this.connector.getState() != Connector.State.disconnected) {
                this.parser.parse((SimpleHandler)this.domHandler, this.buffer, 0, r);
            }
            this.log.finest(this.hashCode() + " / Disconnecting: state=" + this.connector.getState() + "; isInterrupted():" + this.isInterrupted() + "; buffer=" + r + "   " + this);
            if (!this.isInterrupted()) {
                this.onStreamTerminate();
            }
        }
        catch (Exception e) {
            if (this.connector.getState() != Connector.State.disconnecting && this.connector.getState() != Connector.State.disconnected) {
                this.log.log(Level.WARNING, "Exception in worker", e);
                try {
                    this.onErrorInThread(e);
                }
                catch (JaxmppException e1) {
                    this.log.log(Level.WARNING, "Error on handling another exception", e);
                }
            }
        }
        finally {
            this.interrupt();
            this.log.finest("Worker2 is interrupted");
            this.workerTerminated();
        }
    }

    protected abstract void workerTerminated();
}

