/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connection.socks5bytestream;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.factory.UniversalFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.ResourceBinderModule;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionEndpoint;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionSession;
import tigase.jaxmpp.core.client.xmpp.modules.disco.DiscoveryModule;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.Socks5BytestreamsModule;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.Streamhost;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;
import tigase.jaxmpp.j2se.connection.ConnectionManager;
import tigase.jaxmpp.j2se.connection.socks5bytestream.StreamhostsResolver;
import tigase.jaxmpp.j2se.filetransfer.FileTransfer;
import tigase.jaxmpp.j2se.filetransfer.FileTransferManager;

public abstract class Socks5ConnectionManager
implements ConnectionManager {
    public static final String PACKET_ID = "packet-id";
    protected static final String JAXMPP_KEY = "jaxmpp";
    protected static final String PROXY_JID_KEY = "proxy-jid";
    protected static final String PROXY_JID_USED_KEY = "proxy-jid-used";
    protected static final String SID_KEY = "socks5-sid";
    protected static final String STREAMHOST_KEY = "streamhost";
    private static final Charset UTF_CHARSET = Charset.forName("UTF-8");
    private static final Logger log = Logger.getLogger(Socks5ConnectionManager.class.getCanonicalName());
    private static final Map<String, ConnectionSession> sessions = new HashMap<String, ConnectionSession>();
    private static final long TIMEOUT = 900000L;
    private static TcpServerThread server = null;
    private static Timer timer = new Timer("Socks5Timer", true);
    protected Context context;

    protected static boolean checkHash(String data, ConnectionSession session) {
        return data.equals(Socks5ConnectionManager.generateHash(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearSessions() {
        Map<String, ConnectionSession> map = sessions;
        synchronized (map) {
            for (ConnectionSession session : new HashSet<ConnectionSession>(sessions.values())) {
                Socks5ConnectionManager connectionManager = (Socks5ConnectionManager)session.getData(Socks5ConnectionManager.class.getCanonicalName());
                connectionManager.fireOnFailure(session);
            }
            sessions.clear();
        }
    }

    protected static String generateHash(ConnectionSession session) {
        try {
            String sid = (String)session.getData(SID_KEY);
            String data = session.isIncoming() ? sid + session.getPeer().toString() + ResourceBinderModule.getBindedJID((SessionObject)session.getSessionObject()).toString() : sid + ResourceBinderModule.getBindedJID((SessionObject)session.getSessionObject()).toString() + session.getPeer();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(data.getBytes(UTF_CHARSET));
            byte[] buff = md.digest();
            StringBuilder enc = new StringBuilder();
            for (byte b : buff) {
                char ch = Character.forDigit(b >> 4 & 0xF, 16);
                enc.append(ch);
                ch = Character.forDigit(b & 0xF, 16);
                enc.append(ch);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("for " + ResourceBinderModule.getBindedJID((SessionObject)session.getSessionObject()).toString() + " generated " + data + " hash = " + enc.toString());
            }
            return enc.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ConnectionSession getSession(String hash) {
        Map<String, ConnectionSession> map = sessions;
        synchronized (map) {
            return sessions.get(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static State processData(ConnectionSession ft, SocketChannel socket, State state, ByteBuffer buf) throws IOException {
        if (buf != null && buf.hasRemaining()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "processing received data of size {0} bytes", buf.remaining());
            }
            switch (state) {
                case WelcomeServ: {
                    byte ver1 = buf.get();
                    if (ver1 != 5) {
                        log.fine("bad protocol version! ver = " + ver1);
                        socket.close();
                        return State.Closed;
                    }
                    int count = buf.get();
                    boolean ok = false;
                    for (int i = 0; i < count; ++i) {
                        if (buf.get() != 0) continue;
                        ok = true;
                        break;
                    }
                    buf.clear();
                    state = State.Command;
                    if (ok) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "sending welcome 0x05 0x00");
                        }
                        socket.write(ByteBuffer.wrap(new byte[]{5, 0}));
                        break;
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "stopping service {0} after failure during WELCOME step", socket.toString());
                    }
                    socket.close();
                    return State.Closed;
                }
                case Command: {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("for Command read = " + buf.remaining());
                    }
                    if (buf.get() != 5) {
                        log.fine("bad protocol version!");
                        socket.close();
                        return State.Closed;
                    }
                    byte cmd = buf.get();
                    buf.get();
                    byte atype = buf.get();
                    if (cmd != 1 || atype != 3) break;
                    byte len = buf.get();
                    byte[] data = new byte[len];
                    buf.get(data);
                    buf.clear();
                    ByteBuffer tmp = ByteBuffer.allocate(len + 7);
                    tmp.put((byte)5);
                    tmp.put((byte)0);
                    tmp.put((byte)0);
                    tmp.put(atype);
                    tmp.put(len);
                    tmp.put(data);
                    tmp.put((byte)0);
                    tmp.put((byte)0);
                    tmp.flip();
                    ft = Socks5ConnectionManager.getSession(new String(data));
                    if (ft == null) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "stopping service {0} without file transfer", socket.toString());
                        }
                        socket.close();
                        return State.Closed;
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "sending response to COMMAND");
                    }
                    socket.write(tmp);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!socket.socket().isClosed()) {
                        ConnectionSession connectionSession = ft;
                        synchronized (connectionSession) {
                            ArrayList<Socket> sockets = (ArrayList<Socket>)ft.getData("sockets");
                            if (sockets == null) {
                                sockets = new ArrayList<Socket>();
                                ft.setData("sockets", sockets);
                            }
                            sockets.add(socket.socket());
                        }
                        state = State.ActiveServ;
                        break;
                    }
                    return State.Closed;
                }
                case WelcomeResp: {
                    byte ver;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("for WELCOME response read = " + buf.remaining());
                    }
                    if ((ver = buf.get()) != 5) {
                        log.fine("bad protocol version!");
                        socket.close();
                        return State.Closed;
                    }
                    byte status = buf.get();
                    buf.clear();
                    if (status != 0) break;
                    state = State.Auth;
                    break;
                }
                case AuthResp: {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("for AUTH response read = " + buf.remaining());
                    }
                    if (buf.get() != 5) {
                        log.fine("bad protocol version!");
                    }
                    buf.clear();
                    state = State.Active;
                    break;
                }
                case Active: {
                    buf.clear();
                    break;
                }
                default: {
                    log.log(Level.FINE, "wrong state, buffer has remainging = {0}", buf.remaining());
                    buf.clear();
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "after processing received data set in state = {0}", (Object)state);
            }
        }
        if (state == State.Welcome) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "sending WELCOME request");
            }
            ByteBuffer out = ByteBuffer.allocate(128);
            out.put((byte)5);
            out.put((byte)1);
            out.put((byte)0);
            out.flip();
            state = State.WelcomeResp;
            socket.write(out);
            buf.clear();
        } else if (state == State.Auth) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "sending AUTH request");
            }
            state = State.AuthResp;
            ByteBuffer out = ByteBuffer.allocate(256);
            out.put((byte)5);
            out.put((byte)1);
            out.put((byte)0);
            out.put((byte)3);
            byte[] hexHash = Socks5ConnectionManager.generateHash(ft).getBytes(UTF_CHARSET);
            out.put((byte)hexHash.length);
            out.put(hexHash);
            out.put((byte)0);
            out.put((byte)0);
            out.flip();
            int len = out.remaining();
            int wrote = socket.write(out);
            if (out.hasRemaining()) {
                log.log(Level.FINE, "we wrote to stream = {0} but we have remaining = {1}", new Object[]{wrote, out.remaining()});
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerSession(ConnectionSession session, String sid, Socks5ConnectionManager instance) {
        Map<String, ConnectionSession> map = sessions;
        synchronized (map) {
            session.setData(SID_KEY, (Object)sid);
            String hash = Socks5ConnectionManager.generateHash(session);
            session.setData(Socks5ConnectionManager.class.getCanonicalName(), (Object)instance);
            sessions.put(hash, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregisterSession(ConnectionSession session) {
        Map<String, ConnectionSession> map = sessions;
        synchronized (map) {
            String hash = Socks5ConnectionManager.generateHash(session);
            sessions.remove(hash);
            if (sessions.isEmpty() && server != null) {
                server.shutdown();
            }
        }
    }

    protected void connectToProxy(JaxmppCore jaxmpp, ConnectionSession session, String sid, ConnectionEndpoint host) throws IOException, JaxmppException {
        session.setData(JAXMPP_KEY, (Object)jaxmpp);
        InetSocketAddress address = new InetSocketAddress(host.getHost(), (int)host.getPort());
        SocketChannel channel = SocketChannel.open(address);
        if (!session.isIncoming() && !session.getPeer().equals((Object)host.getJid())) {
            session.setData(PROXY_JID_USED_KEY, (Object)host.getJid());
        }
        session.setData(SID_KEY, (Object)sid);
        session.setData(STREAMHOST_KEY, (Object)host);
        this.handleConnection(session, channel.socket(), false);
    }

    public void discoverProxy(final JaxmppCore jaxmpp, final ConnectionSession session, final ConnectionManager.InitializedCallback callback) throws JaxmppException {
        session.setData(JAXMPP_KEY, (Object)jaxmpp);
        DiscoveryModule discoItemsModule = (DiscoveryModule)jaxmpp.getModule(DiscoveryModule.class);
        JID jid = ResourceBinderModule.getBindedJID((SessionObject)jaxmpp.getSessionObject());
        discoItemsModule.getItems(JID.jidInstance((String)jid.getDomain()), new DiscoveryModule.DiscoItemsAsyncCallback(){

            public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                Socks5ConnectionManager.this.proxyDiscoveryError(jaxmpp, session, callback, "not supported by this server");
            }

            public void onInfoReceived(String attribute, final ArrayList<DiscoveryModule.Item> items) throws XMLException {
                int all = items.size();
                if (all == 0) {
                    Socks5ConnectionManager.this.proxyDiscoveryError(jaxmpp, session, callback, "not supported by this server");
                } else {
                    final AtomicInteger counter = new AtomicInteger(0);
                    DiscoveryModule discoInfoModule = (DiscoveryModule)jaxmpp.getModule(DiscoveryModule.class);
                    final List<JID> proxyComponents = Collections.synchronizedList(new ArrayList());
                    for (final DiscoveryModule.Item item : items) {
                        try {
                            discoInfoModule.getInfo(item.getJid(), new DiscoveryModule.DiscoInfoAsyncCallback(null){

                                protected void checkFinished() {
                                    int count = counter.addAndGet(1);
                                    if (count == items.size()) {
                                        Socks5ConnectionManager.this.proxyDiscoveryFinished(jaxmpp, session, callback, proxyComponents);
                                    }
                                }

                                public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                                    this.checkFinished();
                                }

                                protected void onInfoReceived(String node, Collection<DiscoveryModule.Identity> identities, Collection<String> features) throws XMLException {
                                    if (identities != null) {
                                        for (DiscoveryModule.Identity identity : identities) {
                                            if (!"proxy".equals(identity.getCategory()) || !"bytestreams".equals(identity.getType())) continue;
                                            proxyComponents.add(item.getJid());
                                        }
                                    }
                                    this.checkFinished();
                                }

                                public void onTimeout() throws JaxmppException {
                                    this.checkFinished();
                                }
                            });
                        }
                        catch (JaxmppException e) {
                            int count = counter.addAndGet(1);
                            if (count != items.size()) continue;
                            Socks5ConnectionManager.this.proxyDiscoveryFinished(jaxmpp, session, callback, proxyComponents);
                        }
                    }
                }
            }

            public void onTimeout() throws JaxmppException {
                Socks5ConnectionManager.this.proxyDiscoveryError(jaxmpp, session, callback, "proxy discovery timed out");
            }
        });
    }

    protected void fireOnConnected(ConnectionSession session) {
        List sockets = (List)session.getData("sockets");
        for (Socket socket : sockets) {
            if (socket.isClosed()) continue;
            try {
                socket.getInputStream().read(new byte[0]);
                socket.getOutputStream().write(new byte[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (socket.isClosed()) continue;
            this.fireOnConnected(session, socket);
        }
    }

    protected void fireOnConnected(ConnectionSession session, Socket socket) {
        try {
            this.context.getEventBus().fire((Event)new ConnectionManager.ConnectionEstablishedHandler.ConnectionEstablishedEvent(session.getSessionObject(), session, socket));
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "failure firing ConnectionEstablished event", ex);
        }
    }

    protected void fireOnFailure(ConnectionSession session) {
        try {
            Socks5ConnectionManager.unregisterSession(session);
            this.context.getEventBus().fire((Event)new ConnectionManager.ConnectionFailedHandler.ConnectionFailedEvent(session.getSessionObject(), session));
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "failure firing ConnectionFailed event", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Streamhost> getLocalStreamHosts(ConnectionSession session, String sid) throws JaxmppException {
        try {
            StreamhostsResolver streamhostsResolver = (StreamhostsResolver)UniversalFactory.createInstance((String)StreamhostsResolver.class.getCanonicalName());
            Class<TcpServerThread> clazz = TcpServerThread.class;
            synchronized (TcpServerThread.class) {
                if (server == null || !server.isAlive()) {
                    server = new TcpServerThread(0);
                    server.start();
                }
                Socks5ConnectionManager.registerSession(session, sid, this);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return streamhostsResolver.getLocalStreamHosts(ResourceBinderModule.getBindedJID((SessionObject)session.getSessionObject()), server.getPort());
            }
        }
        catch (Exception ex) {
            throw new JaxmppException("problem in getting local streamhosts", (Throwable)ex);
        }
    }

    protected void handleConnection(ConnectionSession session, Socket socket, boolean incoming) throws IOException {
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(0);
        socket.getChannel().configureBlocking(true);
        State state = incoming ? State.WelcomeServ : State.Welcome;
        ByteBuffer buf = ByteBuffer.allocate(4096);
        SocketChannel socketChannel = socket.getChannel();
        while (state != State.Closed && state != State.Active && state != State.ActiveServ) {
            if (state == State.Welcome) {
                buf.flip();
            } else {
                int read;
                if (!buf.hasRemaining()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.warning("no space to read from socket!!");
                    }
                    buf.clear();
                }
                if ((read = socketChannel.read(buf)) == -1) {
                    state = State.Closed;
                    break;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "read data = {0} state = {1}", new Object[]{read, state.name()});
                }
                buf.flip();
            }
            state = Socks5ConnectionManager.processData(session, socketChannel, state, buf);
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "socket state changed to = {0}", (Object)state);
        }
        switch (state) {
            case Active: {
                if (session.isIncoming()) {
                    this.fireOnConnected(session, socket);
                    break;
                }
                try {
                    this.requestActivate(session, socket);
                }
                catch (JaxmppException ex) {
                    socket.close();
                    this.fireOnFailure(session);
                }
                break;
            }
            case ActiveServ: {
                break;
            }
            case Closed: {
                if (incoming) break;
                throw new IOException("Could not establish Socks5 connection");
            }
        }
        buf.clear();
    }

    protected void proxyDiscoveryError(JaxmppCore jaxmpp, ConnectionSession ft, ConnectionManager.InitializedCallback callback, String errorText) {
        log.log(Level.FINE, "error during Socks5 proxy discovery = {0}", errorText);
        ft.setData(PROXY_JID_KEY, null);
        callback.initialized(jaxmpp, ft);
    }

    protected void proxyDiscoveryFinished(JaxmppCore jaxmpp, ConnectionSession ft, ConnectionManager.InitializedCallback callback, List<JID> proxyComponents) {
        JID proxyJid = proxyComponents == null || proxyComponents.isEmpty() ? null : proxyComponents.get(0);
        ft.setData(PROXY_JID_KEY, (Object)proxyJid);
        callback.initialized(jaxmpp, ft);
    }

    protected void requestActivate(final ConnectionSession session, final Socket socket) throws JaxmppException {
        JaxmppCore jaxmpp = (JaxmppCore)session.getData(JAXMPP_KEY);
        JID usedProxyJid = (JID)session.getData(PROXY_JID_USED_KEY);
        if (jaxmpp == null) {
            log.severe("no jaxmpp instance!!");
        } else if (session.getPeer() == null) {
            log.fine("no peer");
        }
        ((Socks5BytestreamsModule)jaxmpp.getModule(Socks5BytestreamsModule.class)).requestActivate(usedProxyJid, session.getSid(), session.getPeer(), new Socks5BytestreamsModule.ActivateCallback(){

            public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                Socks5ConnectionManager.this.fireOnFailure(session);
            }

            public void onSuccess(Stanza responseStanza) throws JaxmppException {
                Socks5ConnectionManager.this.fireOnConnected(session, socket);
            }

            public void onTimeout() throws JaxmppException {
                Socks5ConnectionManager.this.fireOnFailure(session);
            }
        });
    }

    public void setContext(Context context) {
        this.context = context;
        this.context.getEventBus().addHandler(FileTransferManager.FileTransferSuccessHandler.FileTransferSuccessEvent.class, (EventHandler)new FileTransferManager.FileTransferSuccessHandler(){

            @Override
            public void onFileTransferSuccess(SessionObject sessionObject, FileTransfer fileTransfer) {
                Socks5ConnectionManager.unregisterSession((ConnectionSession)fileTransfer);
            }
        });
        this.context.getEventBus().addHandler(FileTransferManager.FileTransferFailureHandler.FileTransferFailureEvent.class, (EventHandler)new FileTransferManager.FileTransferFailureHandler(){

            @Override
            public void onFileTransferFailure(SessionObject sessionObject, FileTransfer fileTransfer) {
                Socks5ConnectionManager.unregisterSession((ConnectionSession)fileTransfer);
            }
        });
    }

    private class TcpServerThread
    extends Thread {
        private ServerSocketChannel serverSocket = ServerSocketChannel.open();
        private boolean shutdown = false;
        private TimerTask shutdownTask = null;
        private long timeout = 900000L;

        public TcpServerThread(int port) throws IOException {
            this.serverSocket.socket().bind(null);
            this.setDaemon(true);
        }

        public int getPort() {
            if (this.shutdownTask != null) {
                this.shutdownTask.cancel();
                this.shutdownTask = null;
            }
            this.shutdownTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Class<TcpServerThread> clazz = TcpServerThread.class;
                        synchronized (TcpServerThread.class) {
                            if (TcpServerThread.this.shutdownTask == null) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                            Socks5ConnectionManager.clearSessions();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                    catch (Exception ex) {
                        log.log(Level.FINEST, "problem with closing server socket", ex);
                    }
                    {
                        return;
                    }
                }
            };
            timer.schedule(this.shutdownTask, this.timeout);
            return this.serverSocket.socket().getLocalPort();
        }

        @Override
        public void run() {
            while (this.serverSocket.socket().isBound() && !this.shutdown) {
                try {
                    SocketChannel socketChannel = this.serverSocket.accept();
                    new IncomingConnectionHandlerThread(socketChannel).start();
                }
                catch (ClosedChannelException ex) {
                    log.log(Level.FINEST, "Socket already closed, when we tried to accept connection", ex);
                }
                catch (IOException ex) {
                    log.log(Level.FINEST, "Exception occurred while we tried to accept incoming connection", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Class<TcpServerThread> clazz = TcpServerThread.class;
            synchronized (TcpServerThread.class) {
                if (this.shutdownTask != null) {
                    this.shutdownTask.cancel();
                    this.shutdownTask = null;
                }
                this.shutdown = true;
                try {
                    this.serverSocket.close();
                }
                catch (IOException ex) {
                    log.log(Level.FINEST, "problem with closing server socket", ex);
                }
                return;
            }
        }
    }

    private class IncomingConnectionHandlerThread
    extends Thread {
        private final SocketChannel socketChannel;

        private IncomingConnectionHandlerThread(SocketChannel channel) {
            this.socketChannel = channel;
        }

        @Override
        public void run() {
            try {
                Socks5ConnectionManager.this.handleConnection(null, this.socketChannel.socket(), true);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }
    }

    public static enum State {
        Active,
        ActiveServ,
        Auth,
        AuthResp,
        Closed,
        Command,
        Welcome,
        WelcomeResp,
        WelcomeServ;

    }
}

