/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnsname.DnsName;
import org.minidns.record.Data;
import org.minidns.record.Record;
import org.minidns.util.Base64;

public class RRSIG
extends Data {
    public final Record.TYPE typeCovered;
    public final DnssecConstants.SignatureAlgorithm algorithm;
    public final byte algorithmByte;
    public final byte labels;
    public final long originalTtl;
    public final Date signatureExpiration;
    public final Date signatureInception;
    public final int keyTag;
    public final DnsName signerName;
    public final byte[] signature;

    public static RRSIG parse(DataInputStream dis, byte[] data, int length) throws IOException {
        Record.TYPE typeCovered = Record.TYPE.getType(dis.readUnsignedShort());
        byte algorithm = dis.readByte();
        byte labels = dis.readByte();
        long originalTtl = (long)dis.readInt() & 0xFFFFFFFFL;
        Date signatureExpiration = new Date(((long)dis.readInt() & 0xFFFFFFFFL) * 1000L);
        Date signatureInception = new Date(((long)dis.readInt() & 0xFFFFFFFFL) * 1000L);
        int keyTag = dis.readUnsignedShort();
        DnsName signerName = DnsName.parse(dis, data);
        int sigSize = length - signerName.size() - 18;
        byte[] signature = new byte[sigSize];
        if (dis.read(signature) != signature.length) {
            throw new IOException();
        }
        return new RRSIG(typeCovered, null, algorithm, labels, originalTtl, signatureExpiration, signatureInception, keyTag, signerName, signature);
    }

    private RRSIG(Record.TYPE typeCovered, DnssecConstants.SignatureAlgorithm algorithm, byte algorithmByte, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, DnsName signerName, byte[] signature) {
        this.typeCovered = typeCovered;
        assert (algorithmByte == (algorithm != null ? algorithm.number : algorithmByte));
        this.algorithmByte = algorithmByte;
        this.algorithm = algorithm != null ? algorithm : DnssecConstants.SignatureAlgorithm.forByte(algorithmByte);
        this.labels = labels;
        this.originalTtl = originalTtl;
        this.signatureExpiration = signatureExpiration;
        this.signatureInception = signatureInception;
        this.keyTag = keyTag;
        this.signerName = signerName;
        this.signature = signature;
    }

    public RRSIG(Record.TYPE typeCovered, int algorithm, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, DnsName signerName, byte[] signature) {
        this(typeCovered, null, (byte)algorithm, labels, originalTtl, signatureExpiration, signatureInception, keyTag, signerName, signature);
    }

    public RRSIG(Record.TYPE typeCovered, int algorithm, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, String signerName, byte[] signature) {
        this(typeCovered, null, (byte)algorithm, labels, originalTtl, signatureExpiration, signatureInception, keyTag, DnsName.from(signerName), signature);
    }

    public RRSIG(Record.TYPE typeCovered, DnssecConstants.SignatureAlgorithm algorithm, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, DnsName signerName, byte[] signature) {
        this(typeCovered, (int)algorithm.number, labels, originalTtl, signatureExpiration, signatureInception, keyTag, signerName, signature);
    }

    public RRSIG(Record.TYPE typeCovered, DnssecConstants.SignatureAlgorithm algorithm, byte labels, long originalTtl, Date signatureExpiration, Date signatureInception, int keyTag, String signerName, byte[] signature) {
        this(typeCovered, (int)algorithm.number, labels, originalTtl, signatureExpiration, signatureInception, keyTag, DnsName.from(signerName), signature);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.RRSIG;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        this.writePartialSignature(dos);
        dos.write(this.signature);
    }

    public void writePartialSignature(DataOutputStream dos) throws IOException {
        dos.writeShort(this.typeCovered.getValue());
        dos.writeByte(this.algorithmByte);
        dos.writeByte(this.labels);
        dos.writeInt((int)this.originalTtl);
        dos.writeInt((int)(this.signatureExpiration.getTime() / 1000L));
        dos.writeInt((int)(this.signatureInception.getTime() / 1000L));
        dos.writeShort(this.keyTag);
        this.signerName.writeToStream(dos);
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        StringBuilder sb = new StringBuilder().append((Object)this.typeCovered).append(' ').append((Object)this.algorithm).append(' ').append(this.labels).append(' ').append(this.originalTtl).append(' ').append(dateFormat.format(this.signatureExpiration)).append(' ').append(dateFormat.format(this.signatureInception)).append(' ').append(this.keyTag).append(' ').append(this.signerName).append(". ").append(Base64.encodeToString(this.signature));
        return sb.toString();
    }
}

