/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.xml.DefaultElementFactory;
import tigase.xml.Element;
import tigase.xml.ElementFactory;
import tigase.xml.SimpleHandler;

public class DomBuilderHandler
implements SimpleHandler {
    private static ElementFactory defaultFactory = new DefaultElementFactory();
    private static Logger log = Logger.getLogger("tigase.xml.DomBuilderHandler");
    private LinkedList<Element> all_roots = new LinkedList();
    private ElementFactory customFactory = null;
    private Stack<Element> el_stack = new Stack();
    private Map<String, String> namespaces = new TreeMap<String, String>();
    private Object parserState = null;
    private String top_xmlns = null;

    public DomBuilderHandler(ElementFactory factory) {
        this.customFactory = factory;
    }

    public DomBuilderHandler() {
        this.customFactory = defaultFactory;
    }

    public Queue<Element> getParsedElements() {
        return this.all_roots;
    }

    @Override
    public void error(String errorMessage) {
        log.warning("XML content parse error.");
        log.warning(errorMessage);
    }

    @Override
    public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
        Element elem;
        String ns;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Start element name: " + name);
            log.finest("Element attributes names: " + Arrays.toString(attr_names));
            log.finest("Element attributes values: " + Arrays.toString(attr_values));
        }
        if (attr_names != null) {
            for (int i = 0; i < attr_names.length && attr_names[i] != null; ++i) {
                if (!attr_names[i].toString().startsWith("xmlns:")) continue;
                this.namespaces.put(attr_names[i].substring("xmlns:".length(), attr_names[i].length()), attr_values[i].toString());
            }
        }
        String tmp_name = name.toString();
        String new_xmlns = null;
        String prefix = null;
        String tmp_name_prefix = null;
        int idx = tmp_name.indexOf(58);
        if (idx > 0) {
            tmp_name_prefix = tmp_name.substring(0, idx);
        }
        if (tmp_name_prefix != null) {
            for (String pref : this.namespaces.keySet()) {
                if (!tmp_name_prefix.equals(pref)) continue;
                new_xmlns = this.namespaces.get(pref);
                tmp_name = tmp_name.substring(pref.length() + 1, tmp_name.length());
                prefix = pref;
            }
        }
        if ((ns = (elem = this.newElement(tmp_name, null, attr_names, attr_values)).getXMLNS()) == null && !this.el_stack.isEmpty() && this.el_stack.peek().getXMLNS() != null) {
            elem.setDefXMLNS(this.el_stack.peek().getXMLNS());
        }
        if (new_xmlns != null) {
            elem.setXMLNS(new_xmlns);
            elem.removeAttribute("xmlns:" + prefix);
        }
        this.el_stack.push(elem);
    }

    @Override
    public void elementCData(StringBuilder cdata) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Element CDATA: " + cdata);
        }
        try {
            this.el_stack.peek().addCData(cdata.toString());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Override
    public boolean endElement(StringBuilder name) {
        Element elem;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("End element name: " + name);
        }
        String tmp_name = name.toString();
        String tmp_name_prefix = null;
        int idx = tmp_name.indexOf(58);
        if (idx > 0) {
            tmp_name_prefix = tmp_name.substring(0, idx);
        }
        if (tmp_name_prefix != null) {
            for (String pref : this.namespaces.keySet()) {
                if (!tmp_name_prefix.equals(pref)) continue;
                tmp_name = tmp_name.substring(pref.length() + 1, tmp_name.length());
            }
        }
        if (this.el_stack.isEmpty()) {
            this.el_stack.push(this.newElement(tmp_name, null, null, null));
        }
        if ((elem = this.el_stack.pop()).getName() != tmp_name.intern()) {
            return false;
        }
        if (this.el_stack.isEmpty()) {
            this.all_roots.offer(elem);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Adding new request: " + elem.toString());
            }
        } else {
            this.el_stack.peek().addChild(elem);
        }
        return true;
    }

    @Override
    public void otherXML(StringBuilder other) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Other XML content: " + other);
        }
    }

    @Override
    public void saveParserState(Object state) {
        this.parserState = state;
    }

    @Override
    public Object restoreParserState() {
        return this.parserState;
    }

    private Element newElement(String name, String cdata, StringBuilder[] attnames, StringBuilder[] attvals) {
        return this.customFactory.elementInstance(name, cdata, attnames, attvals);
    }
}

