/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.algorithms.JavaSecSignatureVerifier;

class EcgostSignatureVerifier
extends JavaSecSignatureVerifier {
    private static final int LENGTH = 32;
    private static final ECParameterSpec SPEC = new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD97", 16)), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD94", 16), new BigInteger("A6", 16)), new ECPoint(BigInteger.ONE, new BigInteger("8D91E471E0989CDA27DF505A453F2B7635294F2DDF23E3B122ACC99C9E9F1E14", 16)), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF6C611070995AD10045841B09B761B893", 16), 1);

    public EcgostSignatureVerifier() throws NoSuchAlgorithmException {
        super("ECGOST3410", "GOST3411withECGOST3410");
    }

    @Override
    protected byte[] getSignature(byte[] rrsigData) {
        return rrsigData;
    }

    @Override
    protected PublicKey getPublicKey(byte[] key) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(key));
        try {
            byte[] xBytes = new byte[32];
            dis.readFully(xBytes);
            EcgostSignatureVerifier.reverse(xBytes);
            BigInteger x = new BigInteger(1, xBytes);
            byte[] yBytes = new byte[32];
            dis.readFully(yBytes);
            EcgostSignatureVerifier.reverse(yBytes);
            BigInteger y = new BigInteger(1, yBytes);
            return this.getKeyFactory().generatePublic(new ECPublicKeySpec(new ECPoint(x, y), SPEC));
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new DnssecValidationFailedException("Invalid public key!", e);
        }
    }

    private static void reverse(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            int j = array.length - i - 1;
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }
}

